/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.coerce;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChild(value="child", type=RubyNode.class)
public abstract class ToAryNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode toAryNode;

    public ToAryNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    @Specialization(guards={"isRubyArray(array)"})
    public DynamicObject coerceRubyArray(DynamicObject array) {
        return array;
    }

    @Specialization(guards={"!isRubyArray(object)"})
    public DynamicObject coerceObject(VirtualFrame frame, Object object) {
        Object coerced;
        if (this.toAryNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.toAryNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
        }
        try {
            coerced = this.toAryNode.call(frame, object, "to_ary", null, new Object[0]);
        }
        catch (RaiseException e) {
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getRubyException()) == this.getContext().getCoreLibrary().getNoMethodErrorClass()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeErrorNoImplicitConversion(object, "Array", this));
            }
            throw e;
        }
        if (RubyGuards.isRubyArray(coerced)) {
            return (DynamicObject)coerced;
        }
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorBadCoercion(object, "Array", "to_ary", coerced, this));
    }
}

