/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.instrument;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.EventHandlerNode;
import com.oracle.truffle.api.instrument.KillException;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.WrapperNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.jruby.truffle.nodes.RubyNode;

@NodeInfo(cost=NodeCost.NONE)
public final class RubyWrapperNode
extends RubyNode
implements WrapperNode {
    @Node.Child
    private RubyNode child;
    @Node.Child
    private EventHandlerNode eventHandlerNode;

    public RubyWrapperNode(RubyNode child) {
        super(child.getContext(), child.getSourceSection());
        assert (!(child instanceof RubyWrapperNode));
        this.child = child;
    }

    @Override
    public String instrumentationInfo() {
        return "Wrapper node for Ruby";
    }

    @Override
    public void insertEventHandlerNode(EventHandlerNode newProbeNode) {
        this.eventHandlerNode = this.insert(newProbeNode);
    }

    @Override
    public Probe getProbe() {
        try {
            return this.eventHandlerNode.getProbe();
        }
        catch (IllegalStateException e) {
            throw new UnsupportedOperationException("A lite-Probed wrapper has no explicit Probe");
        }
    }

    @Override
    public RubyNode getChild() {
        return this.child;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object result;
        this.eventHandlerNode.enter(this.child, frame);
        try {
            result = this.child.execute(frame);
            this.eventHandlerNode.returnValue(this.child, frame, result);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.eventHandlerNode.returnExceptional(this.child, frame, e);
            throw e;
        }
        return result;
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) throws UnexpectedResultException {
        boolean result;
        this.eventHandlerNode.enter(this.child, frame);
        try {
            result = this.child.executeBoolean(frame);
            this.eventHandlerNode.returnValue(this.child, frame, result);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.eventHandlerNode.returnExceptional(this.child, frame, e);
            throw e;
        }
        return result;
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.child.isDefined(frame);
    }

    @Override
    public int executeInteger(VirtualFrame frame) throws UnexpectedResultException {
        int result;
        this.eventHandlerNode.enter(this.child, frame);
        try {
            result = this.child.executeInteger(frame);
            this.eventHandlerNode.returnValue(this.child, frame, result);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.eventHandlerNode.returnExceptional(this.child, frame, e);
            throw e;
        }
        return result;
    }

    @Override
    public long executeLong(VirtualFrame frame) throws UnexpectedResultException {
        long result;
        this.eventHandlerNode.enter(this.child, frame);
        try {
            result = this.child.executeLong(frame);
            this.eventHandlerNode.returnValue(this.child, frame, result);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.eventHandlerNode.returnExceptional(this.child, frame, e);
            throw e;
        }
        return result;
    }

    @Override
    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        double result;
        this.eventHandlerNode.enter(this.child, frame);
        try {
            result = this.child.executeDouble(frame);
            this.eventHandlerNode.returnValue(this.child, frame, result);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.eventHandlerNode.returnExceptional(this.child, frame, e);
            throw e;
        }
        return result;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.eventHandlerNode.enter(this.child, frame);
        try {
            this.child.executeVoid(frame);
            this.eventHandlerNode.returnVoid(this.child, frame);
        }
        catch (KillException e) {
            throw e;
        }
        catch (Exception e) {
            this.eventHandlerNode.returnExceptional(this.child, frame, e);
            throw e;
        }
    }
}

