/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jruby.RubyHash;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.hash.HashGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

public abstract class BucketsStrategy {
    public static final double LOAD_FACTOR = 0.75;
    public static final int OVERALLOCATE_FACTOR = 4;
    public static final int SIGN_BIT_MASK = Integer.MAX_VALUE;
    private static final int[] CAPACITIES = Arrays.copyOf(RubyHash.MRI_PRIMES, RubyHash.MRI_PRIMES.length - 1);

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject create(RubyContext context, Collection<Map.Entry<Object, Object>> entries, boolean byIdentity) {
        int actualSize = entries.size();
        int bucketsCount = BucketsStrategy.capacityGreaterThan(entries.size()) * 4;
        Entry[] newEntries = new Entry[bucketsCount];
        Entry firstInSequence = null;
        Entry lastInSequence = null;
        for (Map.Entry<Object, Object> entry : entries) {
            Object key = entry.getKey();
            if (!byIdentity && RubyGuards.isRubyString(key)) {
                key = context.send(context.send(key, "dup", null, new Object[0]), "freeze", null, new Object[0]);
            }
            int hashed = BucketsStrategy.hashKey(context, key);
            Entry newEntry = new Entry(hashed, key, entry.getValue());
            int index = BucketsStrategy.getBucketIndex(hashed, newEntries.length);
            Entry bucketEntry = newEntries[index];
            if (bucketEntry == null) {
                newEntries[index] = newEntry;
            } else {
                Entry previousInBucket = null;
                while (bucketEntry != null) {
                    if (hashed == bucketEntry.getHashed() && BucketsStrategy.areKeysEqual(context, bucketEntry.getKey(), key, byIdentity)) {
                        bucketEntry.setValue(entry.getValue());
                        --actualSize;
                        if (bucketEntry.getPreviousInSequence() != null) {
                            bucketEntry.getPreviousInSequence().setNextInSequence(bucketEntry.getNextInSequence());
                        }
                        if (bucketEntry.getNextInSequence() != null) {
                            bucketEntry.getNextInSequence().setPreviousInSequence(bucketEntry.getPreviousInSequence());
                        }
                        if (bucketEntry == lastInSequence) {
                            lastInSequence = bucketEntry.getPreviousInSequence();
                        }
                        newEntry = bucketEntry;
                        previousInBucket = null;
                        break;
                    }
                    previousInBucket = bucketEntry;
                    bucketEntry = bucketEntry.getNextInLookup();
                }
                if (previousInBucket != null) {
                    previousInBucket.setNextInLookup(newEntry);
                }
            }
            if (firstInSequence == null) {
                firstInSequence = newEntry;
            }
            if (lastInSequence != null) {
                lastInSequence.setNextInSequence(newEntry);
            }
            newEntry.setPreviousInSequence(lastInSequence);
            newEntry.setNextInSequence(null);
            lastInSequence = newEntry;
        }
        return Layouts.HASH.createHash(context.getCoreLibrary().getHashFactory(), newEntries, actualSize, firstInSequence, lastInSequence, null, null, false);
    }

    public static int capacityGreaterThan(int size) {
        for (int capacity : CAPACITIES) {
            if (capacity <= size) continue;
            return capacity;
        }
        return CAPACITIES[CAPACITIES.length - 1];
    }

    public static int getBucketIndex(int hashed, int bucketsCount) {
        return (hashed & Integer.MAX_VALUE) % bucketsCount;
    }

    public static void addNewEntry(RubyContext context, DynamicObject hash, int hashed, Object key, Object value) {
        assert (HashGuards.isBucketHash(hash));
        assert (HashOperations.verifyStore(context, hash));
        Entry[] buckets = (Entry[])Layouts.HASH.getStore(hash);
        Entry entry = new Entry(hashed, key, value);
        if (Layouts.HASH.getFirstInSequence(hash) == null) {
            Layouts.HASH.setFirstInSequence(hash, entry);
        } else {
            Layouts.HASH.getLastInSequence(hash).setNextInSequence(entry);
            entry.setPreviousInSequence(Layouts.HASH.getLastInSequence(hash));
        }
        Layouts.HASH.setLastInSequence(hash, entry);
        int bucketIndex = BucketsStrategy.getBucketIndex(hashed, buckets.length);
        Entry previousInLookup = buckets[bucketIndex];
        if (previousInLookup == null) {
            buckets[bucketIndex] = entry;
        } else {
            while (previousInLookup.getNextInLookup() != null) {
                previousInLookup = previousInLookup.getNextInLookup();
            }
            previousInLookup.setNextInLookup(entry);
        }
        Layouts.HASH.setSize(hash, Layouts.HASH.getSize(hash) + 1);
        assert (HashOperations.verifyStore(context, hash));
    }

    @CompilerDirectives.TruffleBoundary
    public static void resize(RubyContext context, DynamicObject hash) {
        assert (HashGuards.isBucketHash(hash));
        assert (HashOperations.verifyStore(context, hash));
        int bucketsCount = BucketsStrategy.capacityGreaterThan(Layouts.HASH.getSize(hash)) * 4;
        Entry[] newEntries = new Entry[bucketsCount];
        for (Entry entry = Layouts.HASH.getFirstInSequence(hash); entry != null; entry = entry.getNextInSequence()) {
            int bucketIndex = BucketsStrategy.getBucketIndex(entry.getHashed(), bucketsCount);
            Entry previousInLookup = newEntries[bucketIndex];
            if (previousInLookup == null) {
                newEntries[bucketIndex] = entry;
            } else {
                while (previousInLookup.getNextInLookup() != null) {
                    previousInLookup = previousInLookup.getNextInLookup();
                }
                previousInLookup.setNextInLookup(entry);
            }
            entry.setNextInLookup(null);
        }
        int size = Layouts.HASH.getSize(hash);
        Entry firstInSequence = Layouts.HASH.getFirstInSequence(hash);
        Entry lastInSequence = Layouts.HASH.getLastInSequence(hash);
        assert (HashOperations.verifyStore(context, newEntries, size, firstInSequence, lastInSequence));
        Layouts.HASH.setStore(hash, newEntries);
        Layouts.HASH.setSize(hash, size);
        Layouts.HASH.setFirstInSequence(hash, firstInSequence);
        Layouts.HASH.setLastInSequence(hash, lastInSequence);
        assert (HashOperations.verifyStore(context, hash));
    }

    public static Iterator<Map.Entry<Object, Object>> iterateKeyValues(final Entry firstInSequence) {
        return new Iterator<Map.Entry<Object, Object>>(){
            private Entry entry;
            {
                this.entry = firstInSequence;
            }

            @Override
            public boolean hasNext() {
                return this.entry != null;
            }

            @Override
            public Map.Entry<Object, Object> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                final Entry finalEntry = this.entry;
                Map.Entry<Object, Object> entryResult = new Map.Entry<Object, Object>(){

                    @Override
                    public Object getKey() {
                        return finalEntry.getKey();
                    }

                    @Override
                    public Object getValue() {
                        return finalEntry.getValue();
                    }

                    @Override
                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException();
                    }
                };
                this.entry = this.entry.getNextInSequence();
                return entryResult;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterable<Map.Entry<Object, Object>> iterableKeyValues(final Entry firstInSequence) {
        return new Iterable<Map.Entry<Object, Object>>(){

            @Override
            public Iterator<Map.Entry<Object, Object>> iterator() {
                return BucketsStrategy.iterateKeyValues(firstInSequence);
            }
        };
    }

    public static void copyInto(RubyContext context, DynamicObject from, DynamicObject to) {
        assert (RubyGuards.isRubyHash(from));
        assert (HashGuards.isBucketHash(from));
        assert (HashOperations.verifyStore(context, from));
        assert (RubyGuards.isRubyHash(to));
        assert (HashOperations.verifyStore(context, to));
        Entry[] newEntries = new Entry[((Entry[])Layouts.HASH.getStore(from)).length];
        Entry firstInSequence = null;
        Entry lastInSequence = null;
        for (Entry entry = Layouts.HASH.getFirstInSequence(from); entry != null; entry = entry.getNextInSequence()) {
            Entry newEntry = new Entry(entry.getHashed(), entry.getKey(), entry.getValue());
            int index = BucketsStrategy.getBucketIndex(entry.getHashed(), newEntries.length);
            newEntry.setNextInLookup(newEntries[index]);
            newEntries[index] = newEntry;
            if (firstInSequence == null) {
                firstInSequence = newEntry;
            }
            if (lastInSequence != null) {
                lastInSequence.setNextInSequence(newEntry);
                newEntry.setPreviousInSequence(lastInSequence);
            }
            lastInSequence = newEntry;
        }
        int size = Layouts.HASH.getSize(from);
        assert (HashOperations.verifyStore(context, newEntries, size, firstInSequence, lastInSequence));
        Layouts.HASH.setStore(to, newEntries);
        Layouts.HASH.setSize(to, size);
        Layouts.HASH.setFirstInSequence(to, firstInSequence);
        Layouts.HASH.setLastInSequence(to, lastInSequence);
    }

    private static int hashKey(RubyContext context, Object key) {
        Object hashValue = context.send(key, "hash", null, new Object[0]);
        if (hashValue instanceof Integer) {
            return (Integer)hashValue;
        }
        if (hashValue instanceof Long) {
            return (int)((Long)hashValue).longValue();
        }
        throw new UnsupportedOperationException();
    }

    private static boolean areKeysEqual(RubyContext context, Object a, Object b, boolean byIdentity) {
        String method = byIdentity ? "equal?" : "eql?";
        Object equalityResult = context.send(a, method, null, b);
        if (equalityResult instanceof Boolean) {
            return (Boolean)equalityResult;
        }
        throw new UnsupportedOperationException();
    }
}

