/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CLIManager {
    public static final char ALTERNATE_POM_FILE = 'f';
    public static final char BATCH_MODE = 'B';
    public static final char SET_SYSTEM_PROPERTY = 'D';
    public static final char OFFLINE = 'o';
    public static final char QUIET = 'q';
    public static final char DEBUG = 'X';
    public static final char ERRORS = 'e';
    public static final char HELP = 'h';
    public static final char VERSION = 'v';
    public static final char SHOW_VERSION = 'V';
    public static final char NON_RECURSIVE = 'N';
    public static final char UPDATE_SNAPSHOTS = 'U';
    public static final char ACTIVATE_PROFILES = 'P';
    public static final String SUPRESS_SNAPSHOT_UPDATES = "nsu";
    public static final char CHECKSUM_FAILURE_POLICY = 'C';
    public static final char CHECKSUM_WARNING_POLICY = 'c';
    public static final char ALTERNATE_USER_SETTINGS = 's';
    public static final String ALTERNATE_GLOBAL_SETTINGS = "gs";
    public static final char ALTERNATE_USER_TOOLCHAINS = 't';
    public static final String ALTERNATE_GLOBAL_TOOLCHAINS = "gt";
    public static final String FAIL_FAST = "ff";
    public static final String FAIL_AT_END = "fae";
    public static final String FAIL_NEVER = "fn";
    public static final String RESUME_FROM = "rf";
    public static final String PROJECT_LIST = "pl";
    public static final String ALSO_MAKE = "am";
    public static final String ALSO_MAKE_DEPENDENTS = "amd";
    public static final String LOG_FILE = "l";
    public static final String ENCRYPT_MASTER_PASSWORD = "emp";
    public static final String ENCRYPT_PASSWORD = "ep";
    public static final String THREADS = "T";
    public static final String LEGACY_LOCAL_REPOSITORY = "llr";
    public static final String BUILDER = "b";
    protected Options options = new Options();

    public CLIManager() {
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Display help information");
        this.options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Force the use of an alternate POM file (or directory with pom.xml).");
        this.options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"define");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Define a system property");
        this.options.addOption(OptionBuilder.create((char)'D'));
        OptionBuilder.withLongOpt((String)"offline");
        OptionBuilder.withDescription((String)"Work offline");
        this.options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.withDescription((String)"Display version information");
        this.options.addOption(OptionBuilder.create((char)'v'));
        OptionBuilder.withLongOpt((String)"quiet");
        OptionBuilder.withDescription((String)"Quiet output - only show errors");
        this.options.addOption(OptionBuilder.create((char)'q'));
        OptionBuilder.withLongOpt((String)"debug");
        OptionBuilder.withDescription((String)"Produce execution debug output");
        this.options.addOption(OptionBuilder.create((char)'X'));
        OptionBuilder.withLongOpt((String)"errors");
        OptionBuilder.withDescription((String)"Produce execution error messages");
        this.options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)"non-recursive");
        OptionBuilder.withDescription((String)"Do not recurse into sub-projects");
        this.options.addOption(OptionBuilder.create((char)'N'));
        OptionBuilder.withLongOpt((String)"update-snapshots");
        OptionBuilder.withDescription((String)"Forces a check for missing releases and updated snapshots on remote repositories");
        this.options.addOption(OptionBuilder.create((char)'U'));
        OptionBuilder.withLongOpt((String)"activate-profiles");
        OptionBuilder.withDescription((String)"Comma-delimited list of profiles to activate");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((char)'P'));
        OptionBuilder.withLongOpt((String)"batch-mode");
        OptionBuilder.withDescription((String)"Run in non-interactive (batch) mode");
        this.options.addOption(OptionBuilder.create((char)'B'));
        OptionBuilder.withLongOpt((String)"no-snapshot-updates");
        OptionBuilder.withDescription((String)"Suppress SNAPSHOT updates");
        this.options.addOption(OptionBuilder.create((String)SUPRESS_SNAPSHOT_UPDATES));
        OptionBuilder.withLongOpt((String)"strict-checksums");
        OptionBuilder.withDescription((String)"Fail the build if checksums don't match");
        this.options.addOption(OptionBuilder.create((char)'C'));
        OptionBuilder.withLongOpt((String)"lax-checksums");
        OptionBuilder.withDescription((String)"Warn if checksums don't match");
        this.options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"settings");
        OptionBuilder.withDescription((String)"Alternate path for the user settings file");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"global-settings");
        OptionBuilder.withDescription((String)"Alternate path for the global settings file");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)ALTERNATE_GLOBAL_SETTINGS));
        OptionBuilder.withLongOpt((String)"toolchains");
        OptionBuilder.withDescription((String)"Alternate path for the user toolchains file");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withLongOpt((String)"global-toolchains");
        OptionBuilder.withDescription((String)"Alternate path for the global toolchains file");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)ALTERNATE_GLOBAL_TOOLCHAINS));
        OptionBuilder.withLongOpt((String)"fail-fast");
        OptionBuilder.withDescription((String)"Stop at first failure in reactorized builds");
        this.options.addOption(OptionBuilder.create((String)FAIL_FAST));
        OptionBuilder.withLongOpt((String)"fail-at-end");
        OptionBuilder.withDescription((String)"Only fail the build afterwards; allow all non-impacted builds to continue");
        this.options.addOption(OptionBuilder.create((String)FAIL_AT_END));
        OptionBuilder.withLongOpt((String)"fail-never");
        OptionBuilder.withDescription((String)"NEVER fail the build, regardless of project result");
        this.options.addOption(OptionBuilder.create((String)FAIL_NEVER));
        OptionBuilder.withLongOpt((String)"resume-from");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Resume reactor from specified project");
        this.options.addOption(OptionBuilder.create((String)RESUME_FROM));
        OptionBuilder.withLongOpt((String)"projects");
        OptionBuilder.withDescription((String)"Comma-delimited list of specified reactor projects to build instead of all projects. A project can be specified by [groupId]:artifactId or by its relative path.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)PROJECT_LIST));
        OptionBuilder.withLongOpt((String)"also-make");
        OptionBuilder.withDescription((String)"If project list is specified, also build projects required by the list");
        this.options.addOption(OptionBuilder.create((String)ALSO_MAKE));
        OptionBuilder.withLongOpt((String)"also-make-dependents");
        OptionBuilder.withDescription((String)"If project list is specified, also build projects that depend on projects on the list");
        this.options.addOption(OptionBuilder.create((String)ALSO_MAKE_DEPENDENTS));
        OptionBuilder.withLongOpt((String)"log-file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Log file to where all build output will go.");
        this.options.addOption(OptionBuilder.create((String)LOG_FILE));
        OptionBuilder.withLongOpt((String)"show-version");
        OptionBuilder.withDescription((String)"Display version information WITHOUT stopping build");
        this.options.addOption(OptionBuilder.create((char)'V'));
        OptionBuilder.withLongOpt((String)"encrypt-master-password");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"Encrypt master security password");
        this.options.addOption(OptionBuilder.create((String)ENCRYPT_MASTER_PASSWORD));
        OptionBuilder.withLongOpt((String)"encrypt-password");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"Encrypt server password");
        this.options.addOption(OptionBuilder.create((String)ENCRYPT_PASSWORD));
        OptionBuilder.withLongOpt((String)"threads");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Thread count, for instance 2.0C where C is core multiplied");
        this.options.addOption(OptionBuilder.create((String)THREADS));
        OptionBuilder.withLongOpt((String)"legacy-local-repository");
        OptionBuilder.withDescription((String)"Use Maven 2 Legacy Local Repository behaviour, ie no use of _remote.repositories. Can also be activated by using -Dmaven.legacyLocalRepo=true");
        this.options.addOption(OptionBuilder.create((String)LEGACY_LOCAL_REPOSITORY));
        OptionBuilder.withLongOpt((String)"builder");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"The id of the build strategy to use.");
        this.options.addOption(OptionBuilder.create((String)BUILDER));
        OptionBuilder.withLongOpt((String)"no-plugin-registry");
        OptionBuilder.withDescription((String)"Ineffective, only kept for backward compatibility");
        this.options.addOption(OptionBuilder.create((String)"npr"));
        OptionBuilder.withLongOpt((String)"check-plugin-updates");
        OptionBuilder.withDescription((String)"Ineffective, only kept for backward compatibility");
        this.options.addOption(OptionBuilder.create((String)"cpu"));
        OptionBuilder.withLongOpt((String)"update-plugins");
        OptionBuilder.withDescription((String)"Ineffective, only kept for backward compatibility");
        this.options.addOption(OptionBuilder.create((String)"up"));
        OptionBuilder.withLongOpt((String)"no-plugin-updates");
        OptionBuilder.withDescription((String)"Ineffective, only kept for backward compatibility");
        this.options.addOption(OptionBuilder.create((String)"npu"));
    }

    public CommandLine parse(String[] args) throws ParseException {
        String[] cleanArgs = this.cleanArgs(args);
        GnuParser parser = new GnuParser();
        return parser.parse(this.options, cleanArgs);
    }

    private String[] cleanArgs(String[] args) {
        int cleanedSz;
        ArrayList<String> cleaned = new ArrayList<String>();
        StringBuilder currentArg = null;
        for (String arg : args) {
            boolean addedToBuffer = false;
            if (arg.startsWith("\"")) {
                if (currentArg != null) {
                    cleaned.add(currentArg.toString());
                }
                currentArg = new StringBuilder(arg.substring(1));
                addedToBuffer = true;
            }
            if (arg.endsWith("\"")) {
                String cleanArgPart = arg.substring(0, arg.length() - 1);
                if (currentArg != null) {
                    if (addedToBuffer) {
                        currentArg.setLength(currentArg.length() - 1);
                    } else {
                        currentArg.append(' ').append(cleanArgPart);
                    }
                    cleaned.add(currentArg.toString());
                } else {
                    cleaned.add(cleanArgPart);
                }
                currentArg = null;
                continue;
            }
            if (addedToBuffer) continue;
            if (currentArg != null) {
                currentArg.append(' ').append(arg);
                continue;
            }
            cleaned.add(arg);
        }
        if (currentArg != null) {
            cleaned.add(currentArg.toString());
        }
        String[] cleanArgs = (cleanedSz = cleaned.size()) == 0 ? args : cleaned.toArray(new String[cleanedSz]);
        return cleanArgs;
    }

    public void displayHelp(PrintStream stdout) {
        stdout.println();
        PrintWriter pw = new PrintWriter(stdout);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(pw, 74, "mvn [options] [<goal(s)>] [<phase(s)>]", "\nOptions:", this.options, 1, 3, "\n", false);
        pw.flush();
    }
}

