/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;

public abstract class VirtualContainerBase<C extends Control, B extends BehaviorBase<C>, I extends IndexedCell>
extends SkinBase<C, B> {
    public static final String SCROLL_TO_INDEX_CENTERED = "VirtualContainerBase.scrollToIndexCentered";
    public static final String SCROLL_TO_INDEX_TOP = "VirtualContainerBase.scrollToIndexTop";
    public static final String SCROLL_TO_OFFSET = "VirtualContainerBase.scrollToOffset";
    protected final VirtualFlow flow = new VirtualFlow();

    public VirtualContainerBase(final C c, B b) {
        super(c, b);
        this.handleControlProperties(c);
        ((Node)c).getProperties().addListener(new MapChangeListener<Object, Object>(){

            @Override
            public void onChanged(MapChangeListener.Change<? extends Object, ? extends Object> change) {
                if (change.wasAdded()) {
                    VirtualContainerBase.this.handleControlProperties(c);
                }
            }
        });
    }

    public abstract I createCell();

    public abstract int getItemCount();

    double getMaxCellWidth(int n) {
        return this.getInsets().getLeft() + this.flow.getMaxCellWidth(n) + this.getInsets().getRight();
    }

    double getVirtualFlowPreferredHeight(int n) {
        double d = 1.0;
        for (int i = 0; i < n && i < this.getItemCount(); ++i) {
            d += this.flow.getCellLength(i);
        }
        return d + this.getInsets().getTop() + this.getInsets().getBottom();
    }

    private void handleControlProperties(C c) {
        ObservableMap<Object, Object> observableMap = ((Node)c).getProperties();
        if (observableMap.containsKey(SCROLL_TO_INDEX_CENTERED)) {
            Object v = observableMap.get(SCROLL_TO_INDEX_CENTERED);
            if (v instanceof Integer) {
                this.flow.scrollTo((Integer)v, true);
            }
            observableMap.remove(SCROLL_TO_INDEX_CENTERED);
        } else if (observableMap.containsKey(SCROLL_TO_INDEX_TOP)) {
            Object v = observableMap.get(SCROLL_TO_INDEX_TOP);
            if (v instanceof Integer) {
                this.flow.scrollTo((Integer)v, false);
            }
            observableMap.remove(SCROLL_TO_INDEX_TOP);
        } else if (observableMap.containsKey(SCROLL_TO_OFFSET)) {
            Object v = observableMap.get(SCROLL_TO_OFFSET);
            if (v instanceof Integer) {
                this.flow.scrollToOffset((Integer)v);
            }
            observableMap.remove(SCROLL_TO_OFFSET);
        }
    }
}

