/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.awt.EventQueue;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import org.apache.commons.httpclient.URI;
import org.apache.log4j.Logger;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.spider.ExtensionSpider;
import org.zaproxy.zap.extension.spider.SpiderPanelTableModel;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ScanListenner;
import org.zaproxy.zap.model.ScanThread;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.spider.Spider;
import org.zaproxy.zap.spider.SpiderListener;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.filters.FetchFilter;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.users.User;

public class SpiderThread
extends ScanThread
implements SpiderListener {
    private boolean stopScan = false;
    private boolean isPaused = false;
    private boolean isAlive = false;
    private ExtensionSpider extension;
    private Spider spider = null;
    private List<SpiderListener> pendingSpiderListeners;
    private int spiderDone = 0;
    private int spiderTodo = 1;
    private static final Logger log = Logger.getLogger(SpiderThread.class);
    private boolean justScanInScope = false;
    private boolean scanChildren = false;
    private Context scanContext = null;
    private User scanUser = null;
    private SpiderPanelTableModel resultsModel;
    private URI startURI = null;
    private SpiderParam spiderParams;
    private List<SpiderParser> customSpiderParsers = null;
    private List<FetchFilter> customFetchFilters = null;
    private List<ParseFilter> customParseFilters = null;

    public SpiderThread(ExtensionSpider extensionSpider, SpiderParam spiderParam, String string, ScanListenner scanListenner) {
        super(string, scanListenner);
        log.debug((Object)("Initializing spider thread for site: " + string));
        this.extension = extensionSpider;
        this.site = string;
        this.pendingSpiderListeners = new LinkedList<SpiderListener>();
        this.resultsModel = new SpiderPanelTableModel();
        this.spiderParams = spiderParam;
    }

    @Override
    public void run() {
        this.runScan();
    }

    private void runScan() {
        this.spiderDone = 0;
        Date date = new Date();
        log.info((Object)("Starting spidering scan on " + this.site + " at " + date));
        this.startSpider();
        this.isAlive = true;
    }

    @Override
    public void stopScan() {
        if (this.spider != null) {
            this.spider.stop();
        }
        this.stopScan = true;
        this.isAlive = false;
        this.listenner.scanFinshed(this.site);
    }

    @Override
    public boolean isStopped() {
        return this.stopScan;
    }

    @Override
    public boolean isRunning() {
        return this.isAlive;
    }

    public DefaultListModel<?> getList() {
        return null;
    }

    @Override
    public void pauseScan() {
        if (this.spider != null) {
            this.spider.pause();
        }
        this.isPaused = true;
    }

    @Override
    public void resumeScan() {
        if (this.spider != null) {
            this.spider.resume();
        }
        this.isPaused = false;
    }

    @Override
    public boolean isPaused() {
        return this.isPaused;
    }

    @Override
    public int getMaximum() {
        return this.spiderDone + this.spiderTodo;
    }

    private void startSpider() {
        this.spider = new Spider(this.extension, this.spiderParams, this.extension.getModel().getOptionsParam().getConnectionParam(), this.extension.getModel(), this.scanContext);
        this.spider.addSpiderListener(this);
        for (SpiderListener object : this.pendingSpiderListeners) {
            this.spider.addSpiderListener(object);
        }
        this.spider.setExcludeList(this.extension.getExcludeList());
        if (this.startNode != null || this.justScanInScope) {
            this.addSeeds(this.spider, this.startNode);
        } else if (this.scanContext != null) {
            if (this.startURI != null && this.scanContext.isInContext(this.startURI.toString())) {
                this.spider.addSeed(this.startURI);
            }
            for (SiteNode siteNode : this.scanContext.getNodesInContextFromSiteTree()) {
                this.addSeeds(this.spider, siteNode);
            }
        } else if (this.startURI != null) {
            this.spider.addSeed(this.startURI);
        }
        this.spider.setScanAsUser(this.scanUser);
        if (this.customSpiderParsers != null) {
            for (SpiderParser spiderParser : this.customSpiderParsers) {
                this.spider.addCustomParser(spiderParser);
            }
        }
        if (this.customFetchFilters != null) {
            for (FetchFilter fetchFilter : this.customFetchFilters) {
                this.spider.addFetchFilter(fetchFilter);
            }
        }
        if (this.customParseFilters != null) {
            for (ParseFilter parseFilter : this.customParseFilters) {
                this.spider.addParseFilter(parseFilter);
            }
        }
        this.spider.start();
    }

    private void addSeeds(Spider spider, SiteNode siteNode) {
        Object object;
        if (this.justScanInScope) {
            List<SiteNode> list;
            if (this.scanContext == null) {
                log.debug((Object)"Adding seed for Scan of all in scope.");
                list = Model.getSingleton().getSession().getNodesInScopeFromSiteTree();
            } else {
                log.debug((Object)("Adding seed for Scan of all in context " + this.scanContext.getName()));
                list = Model.getSingleton().getSession().getNodesInContextFromSiteTree(this.scanContext);
            }
            try {
                for (SiteNode siteNode2 : list) {
                    HttpMessage httpMessage;
                    if (siteNode2.isRoot() || siteNode2.getHistoryReference() == null || (httpMessage = siteNode2.getHistoryReference().getHttpMessage()) == null || httpMessage.getResponseHeader().isImage()) continue;
                    spider.addSeed(httpMessage);
                }
            }
            catch (Exception exception) {
                log.error((Object)("Error while adding seeds for Spider scan: " + exception.getMessage()), (Throwable)exception);
            }
            return;
        }
        try {
            if (!siteNode.isRoot() && siteNode.getHistoryReference() != null && (object = siteNode.getHistoryReference().getHttpMessage()) != null && !((HttpMessage)object).getResponseHeader().isImage()) {
                spider.addSeed((HttpMessage)object);
            }
        }
        catch (Exception exception) {
            log.error((Object)("Error while adding seeds for Spider scan: " + exception.getMessage()), (Throwable)exception);
        }
        if (this.scanChildren) {
            object = siteNode.children();
            while (object.hasMoreElements()) {
                SiteNode siteNode3 = (SiteNode)object.nextElement();
                this.addSeeds(spider, siteNode3);
            }
        }
    }

    @Override
    public void spiderComplete(boolean bl) {
        log.info((Object)("Spider scanning complete: " + bl));
        this.stopScan = true;
        this.isAlive = false;
        this.listenner.scanFinshed(this.site);
    }

    @Override
    public void foundURI(String string, String string2, FetchFilter.FetchStatus fetchStatus) {
        if (this.extension.getView() != null) {
            if (fetchStatus == FetchFilter.FetchStatus.VALID) {
                this.resultsModel.addScanResult(string, string2, null, false);
            } else if (fetchStatus == FetchFilter.FetchStatus.SEED) {
                this.resultsModel.addScanResult(string, string2, "SEED", false);
            } else {
                this.resultsModel.addScanResult(string, string2, fetchStatus.toString(), true);
            }
            this.extension.getSpiderPanel().updateFoundCount();
        }
    }

    @Override
    public void readURI(final HttpMessage httpMessage) {
        try {
            final HistoryReference historyReference = new HistoryReference(this.extension.getModel().getSession(), 2, httpMessage);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SessionStructure.addPath(Model.getSingleton().getSession(), historyReference, httpMessage);
                }
            });
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public void spiderProgress(int n, int n2, int n3) {
        this.spiderDone = n2;
        this.spiderTodo = n3;
        this.scanProgress(this.site, n2, n2 + n3);
    }

    @Override
    public SiteNode getStartNode() {
        return this.startNode;
    }

    @Override
    public void setStartNode(SiteNode siteNode) {
        this.startNode = siteNode;
    }

    public void setStartURI(URI uRI) {
        this.startURI = uRI;
    }

    @Override
    public void reset() {
        this.resultsModel.removeAllElements();
    }

    public void addSpiderListener(SpiderListener spiderListener) {
        if (this.spider != null) {
            this.spider.addSpiderListener(spiderListener);
        } else {
            this.pendingSpiderListeners.add(spiderListener);
        }
    }

    @Override
    public void setJustScanInScope(boolean bl) {
        this.justScanInScope = bl;
    }

    @Override
    public boolean getJustScanInScope() {
        return this.justScanInScope;
    }

    @Override
    public void setScanChildren(boolean bl) {
        this.scanChildren = bl;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    public SpiderPanelTableModel getResultsTableModel() {
        return this.resultsModel;
    }

    @Override
    public void setScanContext(Context context) {
        this.scanContext = context;
    }

    @Override
    public void setScanAsUser(User user) {
        this.scanUser = user;
    }

    @Override
    public void setTechSet(TechSet techSet) {
    }

    public void setCustomSpiderParsers(List<SpiderParser> list) {
        this.customSpiderParsers = list;
    }

    public void setCustomFetchFilters(List<FetchFilter> list) {
        this.customFetchFilters = list;
    }

    public void setCustomParseFilters(List<ParseFilter> list) {
        this.customParseFilters = list;
    }
}

