/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import sun.tools.jconsole.InternalDialog;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.Version;

public class AboutDialog
extends InternalDialog {
    private static final Color textColor = new Color(87, 88, 89);
    private static final Color bgColor = new Color(232, 237, 241);
    private static final Color borderColor = Color.black;
    private Icon mastheadIcon = new InternalDialog.MastheadIcon(this, Messages.HELP_ABOUT_DIALOG_MASTHEAD_TITLE);
    private static AboutDialog aboutDialog;
    private JLabel statusBar;
    private Action closeAction;

    public AboutDialog(JConsole jConsole) {
        super(jConsole, Messages.HELP_ABOUT_DIALOG_TITLE, false);
        Utilities.setAccessibleDescription(this, Messages.HELP_ABOUT_DIALOG_ACCESSIBLE_DESCRIPTION);
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        JComponent cp = (JComponent)this.getContentPane();
        this.createActions();
        JLabel mastheadLabel = new JLabel(this.mastheadIcon);
        Utilities.setAccessibleName(mastheadLabel, Messages.HELP_ABOUT_DIALOG_MASTHEAD_ACCESSIBLE_NAME);
        TPanel mainPanel = new TPanel(0, 0);
        mainPanel.add((Component)mastheadLabel, "North");
        String jConsoleVersion = Version.getVersion();
        String vmName = System.getProperty("java.vm.name");
        String vmVersion = System.getProperty("java.vm.version");
        String urlStr = AboutDialog.getOnlineDocUrl();
        if (AboutDialog.isBrowseSupported()) {
            urlStr = "<a style='color:#35556b' href=\"" + urlStr + "\">" + urlStr + "</a>";
        }
        JPanel infoAndLogoPanel = new JPanel(new BorderLayout(10, 10));
        infoAndLogoPanel.setBackground(bgColor);
        String colorStr = String.format("%06x", textColor.getRGB() & 0xFFFFFF);
        JEditorPane helpLink = new JEditorPane("text/html", "<html><font color=#" + colorStr + ">" + Resources.format(Messages.HELP_ABOUT_DIALOG_JCONSOLE_VERSION, jConsoleVersion) + "<p>" + Resources.format(Messages.HELP_ABOUT_DIALOG_JAVA_VERSION, vmName + ", " + vmVersion) + "<p>" + urlStr + "</html>");
        helpLink.setOpaque(false);
        helpLink.setEditable(false);
        helpLink.setForeground(textColor);
        mainPanel.setBorder(BorderFactory.createLineBorder(borderColor));
        infoAndLogoPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        helpLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    AboutDialog.this.browse(e.getDescription());
                }
            }
        });
        infoAndLogoPanel.add((Component)helpLink, "North");
        ImageIcon brandLogoIcon = new ImageIcon(this.getClass().getResource("resources/brandlogo.png"));
        JLabel brandLogo = new JLabel(brandLogoIcon, 10);
        JButton closeButton = new JButton(this.closeAction);
        TPanel bottomPanel = new TPanel(0, 0);
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        buttonPanel.setOpaque(false);
        mainPanel.add((Component)infoAndLogoPanel, "Center");
        cp.add((Component)bottomPanel, "South");
        infoAndLogoPanel.add((Component)brandLogo, "South");
        buttonPanel.setBorder(new EmptyBorder(2, 12, 2, 12));
        buttonPanel.add(closeButton);
        bottomPanel.add((Component)buttonPanel, "North");
        this.statusBar = new JLabel(" ");
        bottomPanel.add((Component)this.statusBar, "South");
        cp.add((Component)mainPanel, "North");
        this.pack();
        this.setLocationRelativeTo(jConsole);
        Utilities.updateTransparency(this);
    }

    public void showDialog() {
        this.statusBar.setText(" ");
        this.setVisible(true);
        try {
            this.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private static AboutDialog getAboutDialog(JConsole jConsole) {
        if (aboutDialog == null) {
            aboutDialog = new AboutDialog(jConsole);
        }
        return aboutDialog;
    }

    static void showAboutDialog(JConsole jConsole) {
        AboutDialog.getAboutDialog(jConsole).showDialog();
    }

    static void browseUserGuide(JConsole jConsole) {
        AboutDialog.getAboutDialog(jConsole).browse(AboutDialog.getOnlineDocUrl());
    }

    static boolean isBrowseSupported() {
        return Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
    }

    void browse(String urlStr) {
        block2: {
            try {
                Desktop.getDesktop().browse(new URI(urlStr));
            }
            catch (Exception ex) {
                this.showDialog();
                this.statusBar.setText(ex.getLocalizedMessage());
                if (!JConsole.isDebug()) break block2;
                ex.printStackTrace();
            }
        }
    }

    private void createActions() {
        this.closeAction = new AbstractAction(Messages.CLOSE){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AboutDialog.this.setVisible(false);
                AboutDialog.this.statusBar.setText("");
            }
        };
    }

    private static String getOnlineDocUrl() {
        String version = Integer.toString(sun.misc.Version.jdkMinorVersion());
        return Resources.format(Messages.HELP_ABOUT_DIALOG_USER_GUIDE_LINK_URL, version);
    }

    private static class TPanel
    extends JPanel {
        TPanel(int hgap, int vgap) {
            super(new BorderLayout(hgap, vgap));
            this.setOpaque(false);
        }
    }
}

