/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.UUID;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFImage;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFXObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFImageXObject
extends PDFXObject {
    private PDFImage pdfimage;

    public PDFImageXObject(int xnumber, PDFImage img) {
        this.put("Name", new PDFName("Im" + xnumber));
        this.pdfimage = img;
    }

    @Override
    public int output(OutputStream stream) throws IOException {
        if (this.getDocument().getProfile().isPDFVTActive()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.pdfimage.outputContents(baos);
            this.put("GTS_XID", "uuid:" + UUID.nameUUIDFromBytes(baos.toByteArray()));
        }
        int length = super.output(stream);
        this.pdfimage = null;
        return length;
    }

    @Override
    protected void populateStreamDict(Object lengthEntry) {
        super.populateStreamDict(lengthEntry);
        if (this.pdfimage.isPS()) {
            this.populateDictionaryFromPS();
        } else {
            this.populateDictionaryFromImage();
        }
    }

    private void populateDictionaryFromPS() {
        this.getDocumentSafely().getProfile().verifyPSXObjectsAllowed();
        this.put("Subtype", new PDFName("PS"));
    }

    private void populateDictionaryFromImage() {
        PDFReference ref;
        this.put("Subtype", new PDFName("Image"));
        this.put("Width", new Integer(this.pdfimage.getWidth()));
        this.put("Height", new Integer(this.pdfimage.getHeight()));
        this.put("BitsPerComponent", new Integer(this.pdfimage.getBitsPerComponent()));
        PDFICCStream pdfICCStream = this.pdfimage.getICCStream();
        if (pdfICCStream != null) {
            this.put("ColorSpace", new PDFArray((PDFObject)this, new Object[]{new PDFName("ICCBased"), pdfICCStream}));
        } else {
            PDFDeviceColorSpace cs = this.pdfimage.getColorSpace();
            this.put("ColorSpace", new PDFName(cs.getName()));
        }
        if (this.pdfimage.isInverted()) {
            Float zero = new Float(0.0f);
            Float one = new Float(1.0f);
            PDFArray decode = new PDFArray(this);
            int c = this.pdfimage.getColorSpace().getNumComponents();
            for (int i = 0; i < c; ++i) {
                decode.add(one);
                decode.add(zero);
            }
            this.put("Decode", decode);
        }
        if (this.pdfimage.isTransparent()) {
            PDFColor transp = this.pdfimage.getTransparentColor();
            PDFArray mask = new PDFArray(this);
            if (this.pdfimage.getColorSpace().isGrayColorSpace()) {
                mask.add(new Integer(transp.red255()));
                mask.add(new Integer(transp.red255()));
            } else {
                mask.add(new Integer(transp.red255()));
                mask.add(new Integer(transp.red255()));
                mask.add(new Integer(transp.green255()));
                mask.add(new Integer(transp.green255()));
                mask.add(new Integer(transp.blue255()));
                mask.add(new Integer(transp.blue255()));
            }
            this.put("Mask", mask);
        }
        if ((ref = this.pdfimage.getSoftMaskReference()) != null) {
            this.put("SMask", ref);
        }
        this.pdfimage.populateXObjectDictionary(this.getDictionary());
    }

    @Override
    protected void outputRawStreamData(OutputStream out) throws IOException {
        this.pdfimage.outputContents(out);
    }

    @Override
    protected int getSizeHint() throws IOException {
        return 0;
    }

    @Override
    protected void prepareImplicitFilters() {
        PDFFilter pdfFilter = this.pdfimage.getPDFFilter();
        if (pdfFilter != null) {
            this.getFilterList().ensureFilterInPlace(pdfFilter);
        }
    }

    @Override
    protected String getDefaultFilterName() {
        return this.pdfimage.getFilterHint();
    }

    @Override
    protected boolean multipleFiltersAllowed() {
        return this.pdfimage.multipleFiltersAllowed();
    }

    @Override
    public void getChildren(Set<PDFObject> children) {
        super.getChildren(children);
        PDFICCStream pdfICCStream = this.pdfimage.getICCStream();
        if (pdfICCStream != null) {
            children.add(pdfICCStream);
            pdfICCStream.getChildren(children);
        }
    }
}

