/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.resolve;

import org.gradle.api.DomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.NativeLibraryRequirement;
import org.gradle.nativeplatform.NativeLibrarySpec;
import org.gradle.nativeplatform.internal.resolve.LibraryBinaryLocator;
import org.gradle.platform.base.ComponentSpecContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectLibraryBinaryLocator
implements LibraryBinaryLocator {
    private final ProjectModelResolver projectModelResolver;

    public ProjectLibraryBinaryLocator(ProjectModelResolver projectModelResolver) {
        this.projectModelResolver = projectModelResolver;
    }

    @Override
    public DomainObjectSet<NativeLibraryBinary> getBinaries(NativeLibraryRequirement requirement) {
        ModelRegistry projectModel = this.findProject(requirement);
        ComponentSpecContainer components = (ComponentSpecContainer)projectModel.find("components", ComponentSpecContainer.class);
        if (components == null) {
            return null;
        }
        String libraryName = requirement.getLibraryName();
        NativeLibrarySpec library = (NativeLibrarySpec)components.withType(NativeLibrarySpec.class).get(libraryName);
        if (library == null) {
            return null;
        }
        ModelMap projectBinaries = library.getBinaries().withType(NativeBinarySpec.class);
        DefaultDomainObjectSet binaries = new DefaultDomainObjectSet(NativeLibraryBinary.class);
        for (NativeBinarySpec nativeBinarySpec : projectBinaries.values()) {
            binaries.add((Object)((NativeLibraryBinary)((Object)nativeBinarySpec)));
        }
        return binaries;
    }

    private ModelRegistry findProject(NativeLibraryRequirement requirement) {
        return this.projectModelResolver.resolveProjectModel(requirement.getProjectPath());
    }
}

