/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publisher;

import java.io.IOException;
import java.util.HashMap;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.IvyUtil;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublisher;
import org.gradle.internal.component.external.model.DefaultIvyModulePublishMetaData;
import org.gradle.internal.component.external.model.IvyModulePublishMetaData;
import org.gradle.util.GUtil;

public class DependencyResolverIvyPublisher
implements IvyPublisher {
    public void publish(IvyNormalizedPublication publication, PublicationAwareRepository repository) {
        ModuleVersionPublisher publisher = repository.createPublisher();
        IvyPublicationIdentity projectIdentity = publication.getProjectIdentity();
        ModuleRevisionId moduleRevisionId = IvyUtil.createModuleRevisionId((String)projectIdentity.getOrganisation(), (String)projectIdentity.getModule(), (String)projectIdentity.getRevision());
        ModuleVersionIdentifier moduleVersionIdentifier = DefaultModuleVersionIdentifier.newId((ModuleRevisionId)moduleRevisionId);
        DefaultIvyModulePublishMetaData publishMetaData = new DefaultIvyModulePublishMetaData(moduleVersionIdentifier, "");
        try {
            for (IvyArtifact publishArtifact : publication.getArtifacts()) {
                Artifact ivyArtifact = this.createIvyArtifact(publishArtifact, moduleRevisionId);
                publishMetaData.addArtifact(ivyArtifact, publishArtifact.getFile());
            }
            Artifact artifact = DefaultArtifact.newIvyArtifact((ModuleRevisionId)moduleRevisionId, null);
            publishMetaData.addArtifact(artifact, publication.getDescriptorFile());
            publisher.publish((IvyModulePublishMetaData)publishMetaData);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private Artifact createIvyArtifact(IvyArtifact ivyArtifact, ModuleRevisionId moduleRevisionId) {
        HashMap<String, String> extraAttributes = new HashMap<String, String>();
        if (GUtil.isTrue((Object)ivyArtifact.getClassifier())) {
            extraAttributes.put("m:classifier", ivyArtifact.getClassifier());
        }
        return new DefaultArtifact(moduleRevisionId, null, (String)GUtil.elvis((Object)ivyArtifact.getName(), (Object)moduleRevisionId.getName()), ivyArtifact.getType(), ivyArtifact.getExtension(), extraAttributes);
    }
}

