/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.ivyservice.IvyUtil;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.component.external.model.BuildableIvyModulePublishMetaData;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.IvyModuleArtifactPublishMetaData;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.local.model.BuildableLocalComponentMetaData;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.util.WrapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIvyModulePublishMetaData
implements BuildableIvyModulePublishMetaData,
BuildableLocalComponentMetaData {
    private final ModuleVersionIdentifier id;
    private final DefaultModuleDescriptor moduleDescriptor;
    private final Map<ModuleComponentArtifactIdentifier, IvyModuleArtifactPublishMetaData> artifactsById = new LinkedHashMap<ModuleComponentArtifactIdentifier, IvyModuleArtifactPublishMetaData>();

    public DefaultIvyModulePublishMetaData(ModuleVersionIdentifier id, String status) {
        this.id = id;
        this.moduleDescriptor = new DefaultModuleDescriptor(IvyUtil.createModuleRevisionId(id), status, null);
        this.moduleDescriptor.addExtraAttributeNamespace("m", "http://ant.apache.org/ivy/maven");
    }

    public DefaultIvyModulePublishMetaData(ModuleVersionIdentifier id, ModuleDescriptor moduleDescriptor) {
        this.id = id;
        this.moduleDescriptor = (DefaultModuleDescriptor)moduleDescriptor;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    public DefaultModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @Override
    public void addConfiguration(String name, String description, Set<String> extendsFrom, Set<String> hierarchy, boolean visible, boolean transitive, TaskDependency buildDependencies) {
        Object[] superConfigs = extendsFrom.toArray(new String[0]);
        Arrays.sort(superConfigs);
        Configuration.Visibility visibility = visible ? Configuration.Visibility.PUBLIC : Configuration.Visibility.PRIVATE;
        Configuration conf = new Configuration(name, visibility, description, (String[])superConfigs, transitive, null);
        this.moduleDescriptor.addConfiguration(conf);
    }

    @Override
    public void addExcludeRule(ExcludeRule excludeRule) {
        this.moduleDescriptor.addExcludeRule(excludeRule);
    }

    @Override
    public void addDependency(DependencyMetaData dependency) {
        ModuleRevisionId moduleRevisionId = IvyUtil.createModuleRevisionId(dependency.getRequested().getGroup(), dependency.getRequested().getName(), dependency.getRequested().getVersion());
        DefaultDependencyDescriptor dependencyDescriptor = new DefaultDependencyDescriptor((ModuleDescriptor)this.moduleDescriptor, moduleRevisionId, dependency.isForce(), dependency.isChanging(), dependency.isTransitive());
        for (String moduleConfiguration : dependency.getModuleConfigurations()) {
            for (String dependencyConfiguration : dependency.getDependencyConfigurations(moduleConfiguration, moduleConfiguration)) {
                dependencyDescriptor.addDependencyConfiguration(moduleConfiguration, dependencyConfiguration);
            }
            this.addDependencyArtifacts(moduleConfiguration, dependency.getArtifacts(), dependencyDescriptor);
        }
        this.moduleDescriptor.addDependency((DependencyDescriptor)dependencyDescriptor);
    }

    private void addDependencyArtifacts(String configuration, Set<IvyArtifactName> artifacts, DefaultDependencyDescriptor dependencyDescriptor) {
        for (IvyArtifactName artifact : artifacts) {
            DefaultDependencyArtifactDescriptor artifactDescriptor = new DefaultDependencyArtifactDescriptor((DependencyDescriptor)dependencyDescriptor, artifact.getName(), artifact.getType(), artifact.getExtension(), null, artifact.getClassifier() != null ? WrapUtil.toMap((Object)"m:classifier", (Object)artifact.getClassifier()) : null);
            dependencyDescriptor.addDependencyArtifact(configuration, (DependencyArtifactDescriptor)artifactDescriptor);
        }
    }

    @Override
    public void addArtifacts(String configuration, Iterable<? extends PublishArtifact> artifacts) {
        for (PublishArtifact publishArtifact : artifacts) {
            MDArtifact ivyArtifact = this.getOrCreate(DefaultIvyArtifactName.forPublishArtifact(publishArtifact));
            ivyArtifact.addConfiguration(configuration);
            this.addArtifact((Artifact)ivyArtifact, publishArtifact.getFile());
        }
    }

    @Override
    public void addArtifact(Artifact artifact, File file) {
        DefaultIvyModuleArtifactPublishMetaData publishMetaData = new DefaultIvyModuleArtifactPublishMetaData(this.id, artifact, file);
        this.artifactsById.put(publishMetaData.getId(), publishMetaData);
    }

    public void addArtifact(IvyModuleArtifactPublishMetaData artifact) {
        this.artifactsById.put(artifact.getId(), artifact);
    }

    private MDArtifact getOrCreate(IvyArtifactName ivyName) {
        for (IvyModuleArtifactPublishMetaData artifactPublishMetaData : this.artifactsById.values()) {
            if (!artifactPublishMetaData.getArtifactName().equals(ivyName)) continue;
            return (MDArtifact)artifactPublishMetaData.toIvyArtifact();
        }
        return new MDArtifact((ModuleDescriptor)this.moduleDescriptor, ivyName.getName(), ivyName.getType(), ivyName.getExtension(), null, this.ivyArtifactAttributes(ivyName));
    }

    private Map<String, String> ivyArtifactAttributes(IvyArtifactName ivyArtifactName) {
        if (ivyArtifactName.getClassifier() == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("m:classifier", ivyArtifactName.getClassifier());
    }

    @Override
    public Collection<IvyModuleArtifactPublishMetaData> getArtifacts() {
        return this.artifactsById.values();
    }

    private static class DefaultIvyModuleArtifactPublishMetaData
    implements IvyModuleArtifactPublishMetaData {
        private final DefaultModuleComponentArtifactIdentifier id;
        private final Artifact artifact;
        private final File file;

        private DefaultIvyModuleArtifactPublishMetaData(ModuleVersionIdentifier moduleVersionIdentifier, Artifact artifact, File file) {
            this.id = new DefaultModuleComponentArtifactIdentifier(DefaultModuleComponentIdentifier.newId(moduleVersionIdentifier), DefaultIvyArtifactName.forIvyArtifact(artifact));
            this.artifact = artifact;
            this.file = file;
        }

        public IvyArtifactName getArtifactName() {
            return this.id.getName();
        }

        public Artifact toIvyArtifact() {
            return this.artifact;
        }

        public ModuleComponentArtifactIdentifier getId() {
            return this.id;
        }

        public File getFile() {
            return this.file;
        }
    }
}

