/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetaData;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;

public class DefaultBuildableModuleComponentMetaDataResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableModuleComponentMetaDataResolveResult {
    private BuildableModuleComponentMetaDataResolveResult.State state = BuildableModuleComponentMetaDataResolveResult.State.Unknown;
    private ModuleVersionResolveException failure;
    private MutableModuleComponentResolveMetaData metaData;
    private boolean authoritative;

    private void reset(BuildableModuleComponentMetaDataResolveResult.State state) {
        this.state = state;
        this.metaData = null;
        this.failure = null;
        this.authoritative = false;
    }

    public void reset() {
        this.reset(BuildableModuleComponentMetaDataResolveResult.State.Unknown);
    }

    public void resolved(MutableModuleComponentResolveMetaData metaData) {
        this.reset(BuildableModuleComponentMetaDataResolveResult.State.Resolved);
        this.metaData = metaData;
        this.authoritative = true;
    }

    public void missing() {
        this.reset(BuildableModuleComponentMetaDataResolveResult.State.Missing);
        this.authoritative = true;
    }

    public void failed(ModuleVersionResolveException failure) {
        this.reset(BuildableModuleComponentMetaDataResolveResult.State.Failed);
        this.failure = failure;
        this.authoritative = true;
    }

    public BuildableModuleComponentMetaDataResolveResult.State getState() {
        return this.state;
    }

    public boolean hasResult() {
        return this.state != BuildableModuleComponentMetaDataResolveResult.State.Unknown;
    }

    public ModuleVersionResolveException getFailure() {
        this.assertHasResult();
        return this.failure;
    }

    public MutableModuleComponentResolveMetaData getMetaData() throws ModuleVersionResolveException {
        this.assertResolved();
        return this.metaData;
    }

    public boolean isAuthoritative() {
        this.assertHasResult();
        return this.authoritative;
    }

    public void setAuthoritative(boolean authoritative) {
        this.assertHasResult();
        this.authoritative = authoritative;
    }

    private void assertHasResult() {
        if (!this.hasResult()) {
            throw new IllegalStateException("No result has been specified.");
        }
    }

    private void assertResolved() {
        if (this.state == BuildableModuleComponentMetaDataResolveResult.State.Failed) {
            throw this.failure;
        }
        if (this.state != BuildableModuleComponentMetaDataResolveResult.State.Resolved) {
            throw new IllegalStateException("This module has not been resolved.");
        }
    }
}

