/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.AbstractIterator;
import java.util.Collections;
import java.util.Iterator;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.rules.ChangeType;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.util.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractFileSnapshotTaskStateChanges
implements TaskStateChanges {
    private final String taskName;

    protected AbstractFileSnapshotTaskStateChanges(String taskName) {
        this.taskName = taskName;
    }

    protected abstract String getInputFileType();

    protected abstract FileCollectionSnapshot getPrevious();

    protected abstract FileCollectionSnapshot getCurrent();

    protected abstract void saveCurrent();

    protected FileCollectionSnapshot createSnapshot(FileCollectionSnapshotter snapshotter, FileCollection fileCollection) {
        try {
            return snapshotter.snapshot(fileCollection);
        }
        catch (UncheckedIOException e) {
            throw new UncheckedIOException(String.format("Failed to capture snapshot of %s files for task '%s' during up-to-date check.", this.getInputFileType().toLowerCase(), this.taskName), (Throwable)e);
        }
    }

    @Override
    public Iterator<TaskStateChange> iterator() {
        if (this.getPrevious() == null) {
            return Collections.singleton(new DescriptiveChange(this.getInputFileType() + " file history is not available.", new Object[0])).iterator();
        }
        return new AbstractIterator<TaskStateChange>(){
            final FileCollectionSnapshot.ChangeIterator<String> changeIterator;
            final ChangeListenerAdapter listenerAdapter;
            {
                this.changeIterator = AbstractFileSnapshotTaskStateChanges.this.getCurrent().iterateChangesSince(AbstractFileSnapshotTaskStateChanges.this.getPrevious());
                this.listenerAdapter = new ChangeListenerAdapter(AbstractFileSnapshotTaskStateChanges.this.getInputFileType());
            }

            protected TaskStateChange computeNext() {
                if (this.changeIterator.next(this.listenerAdapter)) {
                    return this.listenerAdapter.lastChange;
                }
                return (TaskStateChange)this.endOfData();
            }
        };
    }

    @Override
    public void snapshotAfterTask() {
        this.saveCurrent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeListenerAdapter
    implements ChangeListener<String> {
        public FileChange lastChange;
        private final String inputFileType;

        private ChangeListenerAdapter(String inputFileType) {
            this.inputFileType = inputFileType;
        }

        @Override
        public void added(String fileName) {
            this.lastChange = new FileChange(fileName, ChangeType.ADDED, this.inputFileType);
        }

        @Override
        public void removed(String fileName) {
            this.lastChange = new FileChange(fileName, ChangeType.REMOVED, this.inputFileType);
        }

        @Override
        public void changed(String fileName) {
            this.lastChange = new FileChange(fileName, ChangeType.MODIFIED, this.inputFileType);
        }
    }
}

