/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.util.GradleVersion;

public class DefaultCacheScopeMapping
implements CacheScopeMapping {
    private final File globalCacheDir;
    private final File buildCacheDir;
    private final GradleVersion version;

    public DefaultCacheScopeMapping(File userHomeDir, File buildCacheDir, GradleVersion version) {
        this.version = version;
        this.globalCacheDir = new File(userHomeDir, "caches");
        this.buildCacheDir = buildCacheDir;
    }

    public File getBaseDirectory(Object scope, String key, CacheBuilder.VersionStrategy versionStrategy) {
        if (key.equalsIgnoreCase("projects") || key.equalsIgnoreCase("tasks") || !key.matches("\\p{Alpha}+[-//.\\w]*")) {
            throw new IllegalArgumentException(String.format("Unsupported cache key '%s'.", key));
        }
        if (scope == null) {
            return this.getCacheDir(this.globalCacheDir, versionStrategy, key);
        }
        if (scope instanceof Gradle) {
            Gradle gradle = (Gradle)scope;
            return this.getCacheDir(this.getBuildCacheDir(gradle.getRootProject()), versionStrategy, key);
        }
        if (scope instanceof Project) {
            Project project = (Project)scope;
            return this.getCacheDir(this.getBuildCacheDir(project.getRootProject()), versionStrategy, String.format("projects/%s/%s", project.getPath().replace(':', '_'), key));
        }
        if (scope instanceof Task) {
            Task task = (Task)scope;
            return this.getCacheDir(this.getBuildCacheDir(task.getProject().getRootProject()), versionStrategy, String.format("tasks/%s/%s", task.getPath().replace(':', '_'), key));
        }
        throw new IllegalArgumentException(String.format("Don't know how to determine the cache directory for scope of type %s.", scope.getClass().getSimpleName()));
    }

    private File getCacheDir(File rootDir, CacheBuilder.VersionStrategy versionStrategy, String subDir) {
        switch (versionStrategy) {
            case CachePerVersion: {
                return new File(rootDir, this.version.getVersion() + "/" + subDir);
            }
            case SharedCache: {
                return new File(rootDir, subDir);
            }
        }
        throw new IllegalArgumentException();
    }

    private File getBuildCacheDir(Project rootProject) {
        if (this.buildCacheDir != null) {
            return this.buildCacheDir;
        }
        return new File(rootProject.getProjectDir(), ".gradle");
    }
}

