/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.initialization.ProjectDescriptorRegistry;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.util.GFileUtils;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectDescriptor
implements ProjectDescriptor,
ProjectIdentifier {
    private String name;
    private final PathToFileResolver fileResolver;
    private File dir;
    private DefaultProjectDescriptor parent;
    private Set<ProjectDescriptor> children = new LinkedHashSet<ProjectDescriptor>();
    private ProjectDescriptorRegistry projectDescriptorRegistry;
    private Path path;
    private String buildFileName = "build.gradle";

    public DefaultProjectDescriptor(DefaultProjectDescriptor parent, String name, File dir, ProjectDescriptorRegistry projectDescriptorRegistry, PathToFileResolver fileResolver) {
        this.parent = parent;
        this.name = name;
        this.fileResolver = fileResolver;
        this.dir = GFileUtils.canonicalise(dir);
        this.projectDescriptorRegistry = projectDescriptorRegistry;
        this.path = this.path(name);
        projectDescriptorRegistry.addProject(this);
        if (parent != null) {
            parent.getChildren().add(this);
        }
    }

    private Path path(String name) {
        if (this.isRootDescriptor()) {
            this.path = Path.ROOT;
            return this.path;
        }
        return this.parent.absolutePath(name);
    }

    private Path absolutePath(String path) {
        return this.path.resolve(path);
    }

    private boolean isRootDescriptor() {
        return this.parent == null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.projectDescriptorRegistry.changeDescriptorPath(this.path, this.path(name));
        this.name = name;
    }

    @Override
    public File getProjectDir() {
        return this.dir;
    }

    @Override
    public void setProjectDir(File dir) {
        this.dir = this.fileResolver.resolve((Object)dir);
    }

    @Override
    public DefaultProjectDescriptor getParent() {
        return this.parent;
    }

    @Override
    public ProjectIdentifier getParentIdentifier() {
        return this.parent;
    }

    @Override
    public Set<ProjectDescriptor> getChildren() {
        return this.children;
    }

    @Override
    public String getPath() {
        return this.path.toString();
    }

    void setPath(Path path) {
        this.path = path;
    }

    @Override
    public String getBuildFileName() {
        return this.buildFileName;
    }

    @Override
    public void setBuildFileName(String name) {
        this.buildFileName = name;
    }

    @Override
    public File getBuildFile() {
        return GFileUtils.canonicalise(new File(this.dir, this.buildFileName));
    }

    public ProjectDescriptorRegistry getProjectDescriptorRegistry() {
        return this.projectDescriptorRegistry;
    }

    public void setProjectDescriptorRegistry(ProjectDescriptorRegistry projectDescriptorRegistry) {
        this.projectDescriptorRegistry = projectDescriptorRegistry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectDescriptor that = (DefaultProjectDescriptor)o;
        return this.getPath().equals(that.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public String toString() {
        return this.getPath();
    }
}

