#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: cryptonite
version: 0.13
id: cryptonite-0.13-349d06636b05d6ecd7f57ca79abfe077
key: crypt_8tOVQjMArS579icds1NXMc
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: vincent@snarc.org
stability: experimental
homepage: https://github.com/haskell-crypto/cryptonite
synopsis: Cryptography Primitives sink
description:
    A repository of cryptographic primitives.
    .
    * Symmetric ciphers: AES, DES, 3DES, Blowfish, Camellia, RC4, Salsa, ChaCha.
    .
    * Hash: SHA1, SHA2, SHA3, MD2, MD4, MD5, Keccak, Skein, Ripemd, Tiger, Whirlpool, Blake2
    .
    * MAC: HMAC, Poly1305
    .
    * Assymmetric crypto: DSA, RSA, DH, ECDH, ECDSA, ECC, Curve25519, Ed25519
    .
    * Key Derivation Function: PBKDF2, Scrypt, HKDF
    .
    * Cryptographic Random generation: System Entropy, Deterministic Random Generator
    .
    * Data related: Anti-Forensic Information Splitter (AFIS)
    .
    If anything cryptographic related is missing from here, submit
    a pull request to have it added. This package strive to be a
    cryptographic kitchen sink that provides cryptography for everyone.
    .
    Evaluate the security related to your requirements before using.
category: Cryptography
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
exposed-modules:
    Crypto.Cipher.AES Crypto.Cipher.Blowfish Crypto.Cipher.Camellia
    Crypto.Cipher.ChaCha Crypto.Cipher.ChaChaPoly1305 Crypto.Cipher.DES
    Crypto.Cipher.RC4 Crypto.Cipher.Salsa Crypto.Cipher.TripleDES
    Crypto.Cipher.Types Crypto.Data.AFIS Crypto.Data.Padding
    Crypto.Error Crypto.MAC.Poly1305 Crypto.MAC.HMAC
    Crypto.Number.Basic Crypto.Number.F2m Crypto.Number.Generate
    Crypto.Number.ModArithmetic Crypto.Number.Prime
    Crypto.Number.Serialize Crypto.Number.Serialize.Internal
    Crypto.KDF.PBKDF2 Crypto.KDF.Scrypt Crypto.KDF.BCrypt
    Crypto.KDF.HKDF Crypto.Hash Crypto.Hash.IO Crypto.Hash.Algorithms
    Crypto.PubKey.Curve25519 Crypto.PubKey.MaskGenFunction
    Crypto.PubKey.DH Crypto.PubKey.DSA Crypto.PubKey.ECC.Generate
    Crypto.PubKey.ECC.Prim Crypto.PubKey.ECC.DH Crypto.PubKey.ECC.ECDSA
    Crypto.PubKey.ECC.P256 Crypto.PubKey.ECC.Types
    Crypto.PubKey.Ed25519 Crypto.PubKey.Ed448 Crypto.PubKey.RSA
    Crypto.PubKey.RSA.PKCS15 Crypto.PubKey.RSA.Prim
    Crypto.PubKey.RSA.PSS Crypto.PubKey.RSA.OAEP
    Crypto.PubKey.RSA.Types Crypto.Random Crypto.Random.Types
    Crypto.Random.Entropy Crypto.Random.EntropyPool
    Crypto.Random.Entropy.Unsafe
hidden-modules: Crypto.Cipher.AES.Primitive
                Crypto.Cipher.Blowfish.Box Crypto.Cipher.Blowfish.Primitive
                Crypto.Cipher.Camellia.Primitive Crypto.Cipher.DES.Primitive
                Crypto.Cipher.Types.AEAD Crypto.Cipher.Types.Base
                Crypto.Cipher.Types.Block Crypto.Cipher.Types.GF
                Crypto.Cipher.Types.Stream Crypto.Cipher.Types.Utils
                Crypto.Error.Types Crypto.Number.Compat Crypto.Hash.Types
                Crypto.Hash.Blake2s Crypto.Hash.Blake2sp Crypto.Hash.Blake2b
                Crypto.Hash.Blake2bp Crypto.Hash.SHA1 Crypto.Hash.SHA224
                Crypto.Hash.SHA256 Crypto.Hash.SHA384 Crypto.Hash.SHA512
                Crypto.Hash.SHA512t Crypto.Hash.SHA3 Crypto.Hash.Keccak
                Crypto.Hash.MD2 Crypto.Hash.MD4 Crypto.Hash.MD5
                Crypto.Hash.RIPEMD160 Crypto.Hash.Skein256 Crypto.Hash.Skein512
                Crypto.Hash.Tiger Crypto.Hash.Whirlpool
                Crypto.Random.Entropy.Source Crypto.Random.Entropy.Backend
                Crypto.Random.ChaChaDRG Crypto.Random.SystemDRG
                Crypto.Random.Probabilistic Crypto.PubKey.Internal
                Crypto.PubKey.ElGamal Crypto.Internal.ByteArray
                Crypto.Internal.Compat Crypto.Internal.CompatPrim
                Crypto.Internal.DeepSeq Crypto.Internal.Imports
                Crypto.Internal.Words Crypto.Internal.WordArray
                Crypto.Random.Entropy.Unix
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/cryptonite-0.13
library-dirs: /usr/lib/ghc-7.10.3/site-local/cryptonite-0.13
data-dir: /usr/share/arm-linux-ghc-7.10.3/cryptonite-0.13
hs-libraries: HScryptonite-0.13-8tOVQjMArS579icds1NXMc
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    bytestring-0.10.6.0-3b51e35daa3fe2a56ecd3687fb389cdc
    deepseq-1.4.1.1-3975618f889b45239daa47b7443eaeee
    ghc-prim-0.4.0.0-bf246eb9fdda7435f0c147a313ce59fb
    integer-gmp-1.0.0.0-4ff98693d6e5d6065e60052264067c09
    memory-0.11-3a745e41fe78387f608c420e9b455d25
haddock-interfaces: /usr/share/doc/haskell-cryptonite/html/cryptonite.haddock
haddock-html: /usr/share/doc/haskell-cryptonite/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
