#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: scientific
version: 0.3.4.6
id: scientific-0.3.4.6-7ee193f22b0f4a7e2e484deeaee5cd03
key: scien_5s26qRhE5w04kI4pP1Rtwm
license: BSD3
maintainer: Bas van Dijk <v.dijk.bas@gmail.com>
homepage: https://github.com/basvandijk/scientific
synopsis: Numbers represented using scientific notation
description:
    @Data.Scientific@ provides the number type '\''Scientific'\''. Scientific numbers are
    arbitrary precision and space efficient. They are represented using
    <http://en.wikipedia.org/wiki/Scientific_notation scientific notation>.
    The implementation uses a coefficient @c :: '\''Integer'\''@ and a base-10 exponent
    @e :: '\''Int'\''@. A scientific number corresponds to the
    '\''Fractional'\'' number: @'\''fromInteger'\'' c * 10 '\''^^'\'' e@.
    .
    Note that since we'\''re using an '\''Int'\'' to represent the exponent these numbers
    aren'\''t truly arbitrary precision. I intend to change the type of the exponent
    to '\''Integer'\'' in a future release.
    .
    The main application of '\''Scientific'\'' is to be used as the target of parsing
    arbitrary precision numbers coming from an untrusted source. The advantages
    over using '\''Rational'\'' for this are that:
    .
    * A '\''Scientific'\'' is more efficient to construct. Rational numbers need to be
    constructed using '\''%'\'' which has to compute the '\''gcd'\'' of the '\''numerator'\'' and
    '\''denominator'\''.
    .
    * '\''Scientific'\'' is safe against numbers with huge exponents. For example:
    @1e1000000000 :: '\''Rational'\''@ will fill up all space and crash your
    program. Scientific works as expected:
    .
    > > read "1e1000000000" :: Scientific
    > 1.0e1000000000
    .
    * Also, the space usage of converting scientific numbers with huge exponents to
    @'\''Integral'\''s@ (like: '\''Int'\'') or @'\''RealFloat'\''s@ (like: '\''Double'\'' or '\''Float'\'')
    will always be bounded by the target type.
category: Data
author: Bas van Dijk
exposed: True
exposed-modules:
    Data.Scientific Data.Text.Lazy.Builder.Scientific
    Data.ByteString.Builder.Scientific
hidden-modules: Math.NumberTheory.Logarithms
                GHC.Integer.Logarithms.Compat GHC.Integer.Compat Utils
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/scientific-0.3.4.6
library-dirs: /usr/lib/ghc-7.10.3/site-local/scientific-0.3.4.6
data-dir: /usr/share/arm-linux-ghc-7.10.3/scientific-0.3.4.6
hs-libraries: HSscientific-0.3.4.6-5s26qRhE5w04kI4pP1Rtwm
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    binary-0.7.5.0-29f7044fa0b12dc5c2dcec897db5c464
    bytestring-0.10.6.0-3b51e35daa3fe2a56ecd3687fb389cdc
    containers-0.5.6.2-169e53288f333dd2f0207994fd53822f
    deepseq-1.4.1.1-3975618f889b45239daa47b7443eaeee
    ghc-prim-0.4.0.0-bf246eb9fdda7435f0c147a313ce59fb
    hashable-1.2.4.0-165ac1864c8f5bd906b25f6a12db4f18
    integer-gmp-1.0.0.0-4ff98693d6e5d6065e60052264067c09
    text-1.2.2.1-18afbfeccf88d72c4b6e468c86d2b77d
    vector-0.11.0.0-711d35c4a6ac1ea2e529dc3ee3328963
haddock-interfaces: /usr/share/doc/haskell-scientific/html/scientific.haddock
haddock-html: /usr/share/doc/haskell-scientific/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
