/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.lang.reflect.Method;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.engine.MessageAndPath;
import org.hibernate.validator.engine.MessageInterpolatorContext;
import org.hibernate.validator.engine.MethodConstraintViolationImpl;
import org.hibernate.validator.engine.ValidationContext;
import org.hibernate.validator.engine.ValueContext;
import org.hibernate.validator.method.MethodConstraintViolation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodValidationContext<T>
extends ValidationContext<T, MethodConstraintViolation<T>> {
    private final Method method;
    private final Integer parameterIndex;

    protected MethodValidationContext(Class<T> rootBeanClass, T rootBean, Method method, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        this(rootBeanClass, rootBean, method, null, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
    }

    protected MethodValidationContext(Class<T> rootBeanClass, T rootBean, Method method, Integer parameterIndex, MessageInterpolator messageInterpolator, ConstraintValidatorFactory constraintValidatorFactory, TraversableResolver traversableResolver, boolean failFast) {
        super(rootBeanClass, rootBean, messageInterpolator, constraintValidatorFactory, traversableResolver, failFast);
        this.method = method;
        this.parameterIndex = parameterIndex;
    }

    public Method getMethod() {
        return this.method;
    }

    public Integer getParameterIndex() {
        return this.parameterIndex;
    }

    @Override
    public <U, V> MethodConstraintViolation<T> createConstraintViolation(ValueContext<U, V> localContext, MessageAndPath messageAndPath, ConstraintDescriptor<?> descriptor) {
        String messageTemplate = messageAndPath.getMessage();
        String interpolatedMessage = this.messageInterpolator.interpolate(messageTemplate, new MessageInterpolatorContext(descriptor, localContext.getCurrentValidatedValue()));
        return new MethodConstraintViolationImpl(messageTemplate, interpolatedMessage, this.method, localContext.getParameterIndex(), localContext.getParameterName(), this.getRootBeanClass(), this.getRootBean(), localContext.getCurrentBean(), localContext.getCurrentValidatedValue(), messageAndPath.getPath(), descriptor, localContext.getElementType());
    }
}

