/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.validator.metadata.MethodMetaConstraint;
import org.hibernate.validator.metadata.ParameterMetaData;
import org.hibernate.validator.util.CollectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodMetaData
implements Iterable<MethodMetaConstraint<?>> {
    private final Method method;
    private final List<ParameterMetaData> parameterMetaData;
    private final List<MethodMetaConstraint<?>> returnValueConstraints;
    private final boolean isCascading;
    private final boolean hasParameterConstraints;

    public MethodMetaData(Method method, List<MethodMetaConstraint<?>> constraints, boolean isCascading) {
        this(method, Collections.emptyList(), constraints, isCascading);
    }

    public MethodMetaData(Method method, List<ParameterMetaData> parameterMetaData, List<MethodMetaConstraint<?>> returnValueConstraints, boolean isCascading) {
        if (parameterMetaData.size() != method.getParameterTypes().length) {
            throw new IllegalArgumentException(String.format("Method %s has %s parameters, but the passed list of parameter meta data has a size of %s.", method, method.getParameterTypes().length, parameterMetaData.size()));
        }
        this.method = method;
        this.parameterMetaData = Collections.unmodifiableList(parameterMetaData);
        this.returnValueConstraints = Collections.unmodifiableList(returnValueConstraints);
        this.isCascading = isCascading;
        this.hasParameterConstraints = this.hasParameterConstraints(parameterMetaData);
    }

    private boolean hasParameterConstraints(List<ParameterMetaData> parameterMetaData) {
        for (ParameterMetaData oneParameter : parameterMetaData) {
            if (!oneParameter.isConstrained()) continue;
            return true;
        }
        return false;
    }

    public Method getMethod() {
        return this.method;
    }

    public ParameterMetaData getParameterMetaData(int parameterIndex) {
        if (parameterIndex < 0 || parameterIndex > this.parameterMetaData.size() - 1) {
            throw new IllegalArgumentException("Method " + this.method + " doesn't have a parameter with index " + parameterIndex);
        }
        return this.parameterMetaData.get(parameterIndex);
    }

    public List<ParameterMetaData> getAllParameterMetaData() {
        return this.parameterMetaData;
    }

    @Override
    public Iterator<MethodMetaConstraint<?>> iterator() {
        return this.returnValueConstraints.iterator();
    }

    public boolean isCascading() {
        return this.isCascading;
    }

    public boolean isConstrained() {
        return this.isCascading || !this.returnValueConstraints.isEmpty() || this.hasParameterConstraints;
    }

    public boolean hasParameterConstraints() {
        return this.hasParameterConstraints;
    }

    public MethodMetaData merge(MethodMetaData otherMetaData) {
        boolean isCascading = this.isCascading() || otherMetaData.isCascading();
        ArrayList<MethodMetaConstraint<?>> mergedReturnValueConstraints = CollectionHelper.newArrayList(this, otherMetaData);
        ArrayList<ParameterMetaData> mergedParameterMetaData = CollectionHelper.newArrayList();
        for (ParameterMetaData oneParameterMetaData : this.getAllParameterMetaData()) {
            mergedParameterMetaData.add(oneParameterMetaData.merge(otherMetaData.getParameterMetaData(oneParameterMetaData.getIndex())));
        }
        return new MethodMetaData(this.method, mergedParameterMetaData, mergedReturnValueConstraints, isCascading);
    }

    public String toString() {
        return "MethodMetaData [method=" + this.method + ", parameterMetaData=" + this.parameterMetaData + ", constraints=" + this.returnValueConstraints + ", isCascading=" + this.isCascading + ", hasParameterConstraints=" + this.hasParameterConstraints + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodMetaData other = (MethodMetaData)obj;
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }
}

