/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.splitbysize;

import org.pdfsam.i18n.DefaultI18nContext;

public enum SizeUnit {
    MEGABYTE(DefaultI18nContext.getInstance().i18n("Megabytes"), DefaultI18nContext.getInstance().i18n("MB")){

        @Override
        public long toBytes(int raw) {
            return KILOBYTE.toBytes(raw) * 1024L;
        }
    }
    ,
    KILOBYTE(DefaultI18nContext.getInstance().i18n("Kilobytes"), DefaultI18nContext.getInstance().i18n("KB")){

        @Override
        public long toBytes(int raw) {
            return raw * 1024;
        }
    };

    private String name;
    private String symbol;

    private SizeUnit(String name, String symbol) {
        this.name = name;
        this.symbol = symbol;
    }

    public String friendlyName() {
        return this.name;
    }

    public String symbol() {
        return this.symbol;
    }

    public abstract long toBytes(int var1);
}

