/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.conversion.AbstractPdfInputFilesSource;

class FolderFileSourceListParser
extends AbstractPdfInputFilesSource {
    protected static final String PDF_EXTENSION = "pdf";
    private Pattern pattern;

    FolderFileSourceListParser(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    protected List<String> parseFileNames(File file) {
        List<File> files = Arrays.asList(file.listFiles((dir, filename) -> StringUtils.equalsIgnoreCase(FilenameUtils.getExtension(filename), PDF_EXTENSION) && this.pattern.matcher(filename).matches()));
        ArrayList<String> filenames = new ArrayList<String>();
        for (File current : files) {
            filenames.add(current.getAbsolutePath());
        }
        Collections.sort(filenames);
        return filenames;
    }
}

