/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sejda.conversion.AdapterUtils;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.exception.SejdaRuntimeException;

public class PageNumbersListAdapter {
    private static final String SEPARATOR = ",";
    private List<Integer> pageNumbers;

    public PageNumbersListAdapter(String rawString) {
        try {
            this.pageNumbers = this.doParsePageNumbers(rawString);
        }
        catch (SejdaRuntimeException e) {
            throw new ConversionException("Unparsable page numbers '" + rawString + "'. " + e.getMessage(), e);
        }
    }

    public List<Integer> getPageNumbers() {
        return this.pageNumbers;
    }

    private List<Integer> doParsePageNumbers(String rawString) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String s : AdapterUtils.splitAndTrim(rawString, SEPARATOR)) {
            result.add(this.parsePageNumber(s));
        }
        return result;
    }

    private int parsePageNumber(String s) {
        return AdapterUtils.parseInt(StringUtils.trim(s), "page number");
    }
}

