/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.util;

import java.util.Set;
import org.sejda.model.parameter.EncryptParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.pdf.encryption.PdfEncryption;
import org.sejda.sambox.encryption.StandardSecurity;
import org.sejda.sambox.encryption.StandardSecurityEncryption;
import org.sejda.sambox.pdmodel.encryption.AccessPermission;

public final class EncryptionUtils {
    private EncryptionUtils() {
    }

    public static StandardSecurity securityFromParams(EncryptParameters params) {
        return new StandardSecurity(params.getOwnerPassword(), params.getUserPassword(), EncryptionUtils.getEncryptionFrom(params.getEncryptionAlgorithm()), EncryptionUtils.getPermissionsFrom(params.getPermissions()), true);
    }

    private static AccessPermission getPermissionsFrom(Set<PdfAccessPermission> permissions) {
        int perm = -3584;
        for (PdfAccessPermission permission : permissions) {
            perm |= permission.bits;
        }
        return new AccessPermission(perm);
    }

    private static StandardSecurityEncryption getEncryptionFrom(PdfEncryption encryptionAlgorithm) {
        switch (encryptionAlgorithm) {
            case STANDARD_ENC_40: 
            case STANDARD_ENC_128: {
                return StandardSecurityEncryption.ARC4_128;
            }
            case AES_ENC_128: {
                return StandardSecurityEncryption.AES_128;
            }
        }
        return StandardSecurityEncryption.AES_256;
    }
}

