/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.encryption;

import java.util.Objects;
import org.bouncycastle.util.Arrays;
import org.sejda.sambox.encryption.AESEngineNoPadding;
import org.sejda.sambox.encryption.Algorithm2AHash;
import org.sejda.sambox.encryption.EncryptUtils;
import org.sejda.sambox.encryption.EncryptionContext;
import org.sejda.sambox.encryption.PasswordAlgorithm;
import org.sejda.sambox.encryption.StandardSecurityHandlerRevision;
import org.sejda.util.RequireUtils;

public class Algorithm9
implements PasswordAlgorithm {
    private byte[] ownerValidationSalt;
    private byte[] ownerKeySalt;
    private byte[] u;
    private Algorithm2AHash hashAlgo;
    private AESEngineNoPadding engine = AESEngineNoPadding.cbc();

    Algorithm9(Algorithm2AHash hashAlgo, byte[] u, byte[] ownerValidationSalt, byte[] ownerKeySalt) {
        Objects.requireNonNull(hashAlgo);
        Objects.requireNonNull(u);
        RequireUtils.requireArg(u.length == 48, "Generated U string must be 48 bytes long");
        this.hashAlgo = hashAlgo;
        this.u = u;
        this.ownerValidationSalt = ownerValidationSalt;
        this.ownerKeySalt = ownerKeySalt;
    }

    Algorithm9(Algorithm2AHash hashAlgo, byte[] u) {
        this(hashAlgo, u, EncryptUtils.rnd(8), EncryptUtils.rnd(8));
    }

    @Override
    public byte[] computePassword(EncryptionContext context) {
        context.security.encryption.revision.requireAtLeast(StandardSecurityHandlerRevision.R5, "Algorithm 9 requires a security handler of revision 5 or greater");
        byte[] ownerBytes = context.security.getOwnerPasswordUTF();
        return Arrays.concatenate(this.hashAlgo.computeHash(Arrays.concatenate(ownerBytes, this.ownerValidationSalt, this.u), ownerBytes), this.ownerValidationSalt, this.ownerKeySalt);
    }

    public byte[] computeOE(EncryptionContext context) {
        context.security.encryption.revision.requireAtLeast(StandardSecurityHandlerRevision.R5, "Algorithm 8 requires a security handler of revision 5 or greater");
        byte[] ownerBytes = context.security.getOwnerPasswordUTF();
        byte[] key = this.hashAlgo.computeHash(Arrays.concatenate(ownerBytes, this.ownerKeySalt, this.u), ownerBytes);
        return Arrays.copyOf(this.engine.encryptBytes(context.key(), key), 32);
    }
}

