/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.util;

import java.io.IOException;

public final class RequireUtils {
    private RequireUtils() {
    }

    public static void requireNotNullArg(Object arg, String exceptionMessage) {
        if (arg == null) {
            throw new IllegalArgumentException(exceptionMessage);
        }
    }

    public static void requireArg(boolean condition, String exceptionMessage) {
        if (!condition) {
            throw new IllegalArgumentException(exceptionMessage);
        }
    }

    public static void requireNotBlank(String value, String exceptionMessage) {
        RequireUtils.requireArg(value != null && value.trim().length() > 0, exceptionMessage);
    }

    public static void requireIOCondition(boolean condition, String exceptionMessage) throws IOException {
        if (!condition) {
            throw new IOException(exceptionMessage);
        }
    }

    public static void requireState(boolean condition, String exceptionMessage) {
        if (!condition) {
            throw new IllegalStateException(exceptionMessage);
        }
    }
}

