/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.LinkedList;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.VRowAtom;

public class ArrayOfAtoms
extends TeXFormula {
    public LinkedList<LinkedList<Atom>> array = new LinkedList();
    public int col;
    public int row;

    public ArrayOfAtoms() {
        this.array.add(new LinkedList());
        this.row = 0;
    }

    public void addCol() {
        this.array.get(this.row).add(this.root);
        this.root = null;
    }

    public void addCol(int n) {
        this.array.get(this.row).add(this.root);
        for (int i = 1; i < n - 1; ++i) {
            this.array.get(this.row).add(null);
        }
        this.root = null;
    }

    public void addRow() {
        this.addCol();
        this.array.add(new LinkedList());
        ++this.row;
    }

    public int getRows() {
        return this.row;
    }

    public int getCols() {
        return this.col;
    }

    public VRowAtom getAsVRow() {
        VRowAtom vRowAtom = new VRowAtom();
        vRowAtom.setAddInterline(true);
        for (LinkedList linkedList : this.array) {
            for (Atom atom : linkedList) {
                vRowAtom.append(atom);
            }
        }
        return vRowAtom;
    }

    public void checkDimensions() {
        int n;
        if (this.array.getLast().size() != 0) {
            this.addRow();
        } else if (this.root != null) {
            this.addRow();
        }
        this.row = this.array.size() - 1;
        this.col = this.array.get(0).size();
        for (n = 1; n < this.row; ++n) {
            if (this.array.get(n).size() <= this.col) continue;
            this.col = this.array.get(n).size();
        }
        for (n = 0; n < this.row; ++n) {
            int n2 = this.array.get(n).size();
            if (n2 == this.col || this.array.get(n).get(0) == null || this.array.get((int)n).get((int)0).type == 11) continue;
            LinkedList<Atom> linkedList = this.array.get(n);
            while (n2 < this.col) {
                linkedList.add(null);
                ++n2;
            }
        }
    }
}

