/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Map;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharBox;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.CharSymbol;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.InvalidSymbolTypeException;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.ScaleBox;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.SymbolMappingNotFoundException;
import org.scilab.forge.jlatexmath.SymbolNotFoundException;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXSymbolParser;

public class SymbolAtom
extends CharSymbol {
    private final boolean delimiter;
    private final String name;
    public static Map<String, SymbolAtom> symbols = new TeXSymbolParser().readSymbols();
    private static BitSet validSymbolTypes = new BitSet(16);
    private char unicode;

    public SymbolAtom(SymbolAtom symbolAtom, int n) throws InvalidSymbolTypeException {
        if (!validSymbolTypes.get(n)) {
            throw new InvalidSymbolTypeException("The symbol type was not valid! Use one of the symbol type constants from the class 'TeXConstants'.");
        }
        this.name = symbolAtom.name;
        this.type = n;
        if (n == 1) {
            this.type_limits = 0;
        }
        this.delimiter = symbolAtom.delimiter;
    }

    public SymbolAtom(String string, int n, boolean bl) {
        this.name = string;
        this.type = n;
        if (n == 1) {
            this.type_limits = 0;
        }
        this.delimiter = bl;
    }

    public SymbolAtom setUnicode(char c) {
        this.unicode = c;
        return this;
    }

    public char getUnicode() {
        return this.unicode;
    }

    public static void addSymbolAtom(String string) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ResourceParseException(string, fileNotFoundException);
        }
        SymbolAtom.addSymbolAtom(fileInputStream, string);
    }

    public static void addSymbolAtom(InputStream inputStream, String string) {
        TeXSymbolParser teXSymbolParser = new TeXSymbolParser(inputStream, string);
        symbols.putAll(teXSymbolParser.readSymbols());
    }

    public static void addSymbolAtom(SymbolAtom symbolAtom) {
        symbols.put(symbolAtom.name, symbolAtom);
    }

    public static SymbolAtom get(String string) throws SymbolNotFoundException {
        SymbolAtom symbolAtom = symbols.get(string);
        if (symbolAtom == null) {
            throw new SymbolNotFoundException(string);
        }
        return symbolAtom;
    }

    public boolean isDelimiter() {
        return this.delimiter;
    }

    public String getName() {
        return this.name;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        TeXFont teXFont = teXEnvironment.getTeXFont();
        int n = teXEnvironment.getStyle();
        Char char_ = teXFont.getChar(this.name, n);
        Box box = new CharBox(char_);
        if (teXEnvironment.getSmallCap() && this.unicode != '\u0000' && Character.isLowerCase(this.unicode)) {
            try {
                box = new ScaleBox(new CharBox(teXFont.getChar(TeXFormula.symbolTextMappings[Character.toUpperCase(this.unicode)], n)), 0.8, 0.8);
            }
            catch (SymbolMappingNotFoundException symbolMappingNotFoundException) {
                // empty catch block
            }
        }
        if (this.type == 1) {
            if (n < 2 && teXFont.hasNextLarger(char_)) {
                char_ = teXFont.getNextLarger(char_, n);
            }
            box = new CharBox(char_);
            box.setShift(-(box.getHeight() + box.getDepth()) / 2.0f - teXEnvironment.getTeXFont().getAxisHeight(teXEnvironment.getStyle()));
            float f = char_.getItalic();
            HorizontalBox horizontalBox = new HorizontalBox(box);
            if (f > 1.0E-7f) {
                horizontalBox.add(new StrutBox(f, 0.0f, 0.0f, 0.0f));
            }
            return horizontalBox;
        }
        return box;
    }

    public CharFont getCharFont(TeXFont teXFont) {
        return teXFont.getChar(this.name, 0).getCharFont();
    }

    static {
        validSymbolTypes.set(0);
        validSymbolTypes.set(1);
        validSymbolTypes.set(2);
        validSymbolTypes.set(3);
        validSymbolTypes.set(4);
        validSymbolTypes.set(5);
        validSymbolTypes.set(6);
        validSymbolTypes.set(10);
    }
}

