/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.VerticalBox;

public class TeXIcon
implements Icon {
    private static final Color defaultColor = new Color(0, 0, 0);
    public static float defaultSize = -1.0f;
    public static float magFactor = 0.0f;
    private Box box;
    private final float size;
    private Insets insets = new Insets(0, 0, 0, 0);
    private Color fg = null;
    public boolean isColored = false;

    protected TeXIcon(Box box, float f) {
        this(box, f, false);
    }

    protected TeXIcon(Box box, float f, boolean bl) {
        this.box = box;
        if (defaultSize != -1.0f) {
            f = defaultSize;
        }
        this.size = magFactor != 0.0f ? f * Math.abs(magFactor) : f;
        if (!bl) {
            this.insets.top += (int)(0.18f * f);
            this.insets.bottom += (int)(0.18f * f);
            this.insets.left += (int)(0.18f * f);
            this.insets.right += (int)(0.18f * f);
        }
    }

    public void setForeground(Color color) {
        this.fg = color;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets, boolean bl) {
        this.insets = insets;
        if (!bl) {
            this.insets.top += (int)(0.18f * this.size);
            this.insets.bottom += (int)(0.18f * this.size);
            this.insets.left += (int)(0.18f * this.size);
            this.insets.right += (int)(0.18f * this.size);
        }
    }

    public void setInsets(Insets insets) {
        this.setInsets(insets, false);
    }

    public void setIconWidth(int n, int n2) {
        float f = n - this.getIconWidth();
        if (f > 0.0f) {
            this.box = new HorizontalBox(this.box, this.box.getWidth() + f, n2);
        }
    }

    public void setIconHeight(int n, int n2) {
        float f = n - this.getIconHeight();
        if (f > 0.0f) {
            this.box = new VerticalBox(this.box, f, n2);
        }
    }

    public int getIconHeight() {
        return (int)((double)(this.box.getHeight() * this.size) + 0.99 + (double)this.insets.top) + (int)((double)(this.box.getDepth() * this.size) + 0.99 + (double)this.insets.bottom);
    }

    public int getIconDepth() {
        return (int)((double)(this.box.getDepth() * this.size) + 0.99 + (double)this.insets.bottom);
    }

    public int getIconWidth() {
        return (int)((double)(this.box.getWidth() * this.size) + 0.99 + (double)this.insets.left + (double)this.insets.right);
    }

    public float getTrueIconHeight() {
        return (this.box.getHeight() + this.box.getDepth()) * this.size;
    }

    public float getTrueIconDepth() {
        return this.box.getDepth() * this.size;
    }

    public float getTrueIconWidth() {
        return this.box.getWidth() * this.size;
    }

    public float getBaseLine() {
        return (float)(((double)(this.box.getHeight() * this.size) + 0.99 + (double)this.insets.top) / ((double)((this.box.getHeight() + this.box.getDepth()) * this.size) + 0.99 + (double)this.insets.top + (double)this.insets.bottom));
    }

    public Box getBox() {
        return this.box;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        AffineTransform affineTransform = graphics2D.getTransform();
        Color color = graphics2D.getColor();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.scale(this.size, this.size);
        if (this.fg != null) {
            graphics2D.setColor(this.fg);
        } else if (component != null) {
            graphics2D.setColor(component.getForeground());
        } else {
            graphics2D.setColor(defaultColor);
        }
        this.box.draw(graphics2D, (float)(n + this.insets.left) / this.size, (float)(n2 + this.insets.top) / this.size + this.box.getHeight());
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.setTransform(affineTransform);
        graphics2D.setColor(color);
    }
}

