/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math;

import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.VectorUtil;

public class Quaternion {
    protected float x;
    protected float y;
    protected float z;
    protected float w;

    public Quaternion() {
        this.setIdentity();
    }

    public Quaternion(Quaternion quaternion) {
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
        this.w = quaternion.w;
    }

    public Quaternion(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
    }

    public Quaternion(float[] fArray, float[] fArray2) {
        float f = FloatUtil.acos(VectorUtil.dot(fArray, fArray2));
        float[] fArray3 = VectorUtil.cross(fArray, fArray2);
        this.fromAxis(fArray3, f);
    }

    public Quaternion(float[] fArray, float f) {
        this.fromAxis(fArray, f);
    }

    public void fromAxis(float[] fArray, float f) {
        float f2 = f * 0.5f;
        float f3 = FloatUtil.sin(f2);
        float[] fArray2 = VectorUtil.normalize(fArray);
        this.x = fArray2[0] * f3;
        this.y = fArray2[1] * f3;
        this.z = fArray2[2] * f3;
        this.w = FloatUtil.cos(f2);
    }

    public float[] toAxis() {
        float[] fArray = new float[4];
        float f = FloatUtil.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        fArray[0] = FloatUtil.acos(this.w) * 2.0f;
        fArray[1] = this.x / f;
        fArray[2] = this.y / f;
        fArray[3] = this.z / f;
        return fArray;
    }

    public float getW() {
        return this.w;
    }

    public void setW(float f) {
        this.w = f;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public float getZ() {
        return this.z;
    }

    public void setZ(float f) {
        this.z = f;
    }

    public void add(Quaternion quaternion) {
        this.x += quaternion.x;
        this.y += quaternion.y;
        this.z += quaternion.z;
    }

    public void subtract(Quaternion quaternion) {
        this.x -= quaternion.x;
        this.y -= quaternion.y;
        this.z -= quaternion.z;
    }

    public void divide(float f) {
        this.x /= f;
        this.y /= f;
        this.z /= f;
    }

    public void mult(Quaternion quaternion) {
        float f = this.w * quaternion.w - this.x * quaternion.x - this.y * quaternion.y - this.z * quaternion.z;
        float f2 = this.w * quaternion.x + this.x * quaternion.w + this.y * quaternion.z - this.z * quaternion.y;
        float f3 = this.w * quaternion.y - this.x * quaternion.z + this.y * quaternion.w + this.z * quaternion.x;
        float f4 = this.w * quaternion.z + this.x * quaternion.y - this.y * quaternion.x + this.z * quaternion.w;
        this.w = f;
        this.x = f2;
        this.y = f3;
        this.z = f4;
    }

    public void mult(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
    }

    public float[] mult(float[] fArray) {
        float[] fArray2 = new float[3];
        Quaternion quaternion = new Quaternion(fArray[0], fArray[1], fArray[2], 0.0f);
        Quaternion quaternion2 = new Quaternion(this);
        Quaternion quaternion3 = new Quaternion(this);
        quaternion2.inverse();
        quaternion.mult(quaternion2);
        quaternion3.mult(quaternion);
        fArray2[0] = quaternion3.x;
        fArray2[1] = quaternion3.y;
        fArray2[2] = quaternion3.z;
        return fArray2;
    }

    public void normalize() {
        float f = FloatUtil.sqrt(this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z);
        if (f == 0.0f) {
            this.setIdentity();
        } else {
            float f2 = 1.0f / f;
            this.w *= f2;
            this.x *= f2;
            this.y *= f2;
            this.z *= f2;
        }
    }

    public void inverse() {
        float f = this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
        float f2 = 1.0f / f;
        this.w *= f2;
        this.x = -1.0f * this.x * f2;
        this.y = -1.0f * this.y * f2;
        this.z = -1.0f * this.z * f2;
    }

    public float[] toMatrix() {
        float[] fArray = new float[]{1.0f - 2.0f * this.y * this.y - 2.0f * this.z * this.z, 2.0f * this.x * this.y + 2.0f * this.w * this.z, 2.0f * this.x * this.z - 2.0f * this.w * this.y, 0.0f, 2.0f * this.x * this.y - 2.0f * this.w * this.z, 1.0f - 2.0f * this.x * this.x - 2.0f * this.z * this.z, 2.0f * this.y * this.z + 2.0f * this.w * this.x, 0.0f, 2.0f * this.x * this.z + 2.0f * this.w * this.y, 2.0f * this.y * this.z - 2.0f * this.w * this.x, 1.0f - 2.0f * this.x * this.x - 2.0f * this.y * this.y, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        return fArray;
    }

    public void slerp(Quaternion quaternion, Quaternion quaternion2, float f) {
        float f2 = quaternion.x * quaternion2.x + quaternion.y * quaternion2.y + quaternion.z * quaternion2.z + quaternion.w * quaternion2.w;
        float f3 = 1.0f - f;
        if (f2 >= 0.95f) {
            this.x = quaternion.x * f3 + quaternion2.x * f;
            this.y = quaternion.y * f3 + quaternion2.y * f;
            this.z = quaternion.z * f3 + quaternion2.z * f;
            this.w = quaternion.w * f3 + quaternion2.w * f;
            return;
        }
        if (f2 <= -0.99f) {
            this.x = 0.5f * (quaternion.x + quaternion2.x);
            this.y = 0.5f * (quaternion.y + quaternion2.y);
            this.z = 0.5f * (quaternion.z + quaternion2.z);
            this.w = 0.5f * (quaternion.w + quaternion2.w);
            return;
        }
        float f4 = FloatUtil.sqrt(1.0f - f2 * f2);
        float f5 = FloatUtil.acos(f2);
        float f6 = FloatUtil.sin(f3 * f5) / f4;
        float f7 = FloatUtil.sin(f * f5) / f4;
        this.x = quaternion.x * f6 + quaternion2.x * f7;
        this.y = quaternion.y * f6 + quaternion2.y * f7;
        this.z = quaternion.z * f6 + quaternion2.z * f7;
        this.w = quaternion.w * f6 + quaternion2.w * f7;
    }

    public boolean isIdentity() {
        return this.w == 1.0f && this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }

    public void setIdentity() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.w = 1.0f;
    }

    public void setFromMatrix(float[] fArray) {
        float f = fArray[0] + fArray[4] + fArray[8] + 1.0f;
        if (f > 0.0f) {
            float f2 = 0.5f / FloatUtil.sqrt(f);
            this.w = 0.25f / f2;
            this.x = (fArray[5] - fArray[7]) * f2;
            this.y = (fArray[6] - fArray[2]) * f2;
            this.z = (fArray[1] - fArray[3]) * f2;
        } else if (fArray[0] > fArray[4] && fArray[0] > fArray[8]) {
            float f3 = FloatUtil.sqrt(1.0f + fArray[0] - fArray[4] - fArray[8]) * 2.0f;
            this.w = (fArray[7] - fArray[5]) / f3;
            this.x = 0.25f * f3;
            this.y = (fArray[3] + fArray[1]) / f3;
            this.z = (fArray[6] + fArray[2]) / f3;
        } else if (fArray[4] > fArray[8]) {
            float f4 = FloatUtil.sqrt(1.0f + fArray[4] - fArray[0] - fArray[8]) * 2.0f;
            this.w = (fArray[6] - fArray[2]) / f4;
            this.x = (fArray[3] + fArray[1]) / f4;
            this.y = 0.25f * f4;
            this.z = (fArray[7] + fArray[5]) / f4;
        } else {
            float f5 = FloatUtil.sqrt(1.0f + fArray[8] - fArray[0] - fArray[4]) * 2.0f;
            this.w = (fArray[3] - fArray[1]) / f5;
            this.x = (fArray[6] + fArray[2]) / f5;
            this.y = (fArray[7] + fArray[5]) / f5;
            this.z = 0.25f * f5;
        }
    }

    public boolean isRotationMatrix(float[] fArray) {
        if (FloatUtil.abs(fArray[0] * fArray[3] + fArray[3] * fArray[4] + fArray[6] * fArray[7]) > 0.01f) {
            return false;
        }
        if (FloatUtil.abs(fArray[0] * fArray[2] + fArray[3] * fArray[5] + fArray[6] * fArray[8]) > 0.01f) {
            return false;
        }
        if (FloatUtil.abs(fArray[1] * fArray[2] + fArray[4] * fArray[5] + fArray[7] * fArray[8]) > 0.01f) {
            return false;
        }
        if (FloatUtil.abs(fArray[0] * fArray[0] + fArray[3] * fArray[3] + fArray[6] * fArray[6] - 1.0f) > 0.01f) {
            return false;
        }
        if (FloatUtil.abs(fArray[1] * fArray[1] + fArray[4] * fArray[4] + fArray[7] * fArray[7] - 1.0f) > 0.01f) {
            return false;
        }
        if (FloatUtil.abs(fArray[2] * fArray[2] + fArray[5] * fArray[5] + fArray[8] * fArray[8] - 1.0f) > 0.01f) {
            return false;
        }
        return FloatUtil.abs(this.determinant(fArray) - 1.0f) < 0.01f;
    }

    private float determinant(float[] fArray) {
        return fArray[0] * fArray[4] * fArray[8] + fArray[3] * fArray[7] * fArray[2] + fArray[6] * fArray[1] * fArray[5] - fArray[0] * fArray[7] * fArray[5] - fArray[3] * fArray[1] * fArray[8] - fArray[6] * fArray[4] * fArray[2];
    }
}

