/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.api.internal.classpath;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gradle.testkit.jarjar.org.gradle.api.UncheckedIOException;
import org.gradle.testkit.jarjar.org.gradle.api.internal.classpath.ManifestUtil;
import org.gradle.testkit.jarjar.org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.testkit.jarjar.org.gradle.internal.classpath.DefaultClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EffectiveClassPath
extends DefaultClassPath {
    public EffectiveClassPath(ClassLoader classLoader) {
        super(EffectiveClassPath.findAvailableClasspathFiles(classLoader));
    }

    private static List<File> findAvailableClasspathFiles(ClassLoader classLoader) {
        List<URL> rawClasspath = ClasspathUtil.getClasspath(classLoader);
        ArrayList<File> classpathFiles = new ArrayList<File>();
        for (URL url : rawClasspath) {
            if (!url.getProtocol().equals("file")) continue;
            try {
                File classpathFile = new File(url.toURI());
                EffectiveClassPath.addClasspathFile(classpathFile, classpathFiles);
            }
            catch (URISyntaxException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (classLoader == ClassLoader.getSystemClassLoader()) {
            for (String value : System.getProperty("java.class.path").split(File.pathSeparator)) {
                EffectiveClassPath.addClasspathFile(new File(value), classpathFiles);
            }
        }
        return classpathFiles;
    }

    private static void addClasspathFile(File classpathFile, List<File> classpathFiles) {
        if (classpathFile.exists() && !classpathFiles.contains(classpathFile)) {
            classpathFiles.add(classpathFile);
            EffectiveClassPath.addManifestClasspathFiles(classpathFile, classpathFiles);
        }
    }

    private static void addManifestClasspathFiles(File classpathFile, List<File> classpathFiles) {
        List<URI> classpathUris = ManifestUtil.parseManifestClasspath(classpathFile);
        for (URI classpathUri : classpathUris) {
            EffectiveClassPath.addClasspathFile(new File(classpathUri), classpathFiles);
        }
    }
}

