/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.util.List;
import org.gradle.api.internal.tasks.testing.TestSuiteExecutionException;
import org.gradle.api.internal.tasks.testing.junit.AllExceptIgnoredTestRunnerBuilder;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoredTestDescriptorProvider {
    List<Description> getAllDescriptions(Description description, String className) {
        AllExceptIgnoredTestRunnerBuilder allExceptIgnoredTestRunnerBuilder = new AllExceptIgnoredTestRunnerBuilder();
        try {
            Class<?> testClass = description.getClass().getClassLoader().loadClass(className);
            Runner runner = allExceptIgnoredTestRunnerBuilder.runnerForClass(testClass);
            if (runner == null) {
                runner = Request.aClass(testClass).getRunner();
            }
            Description runnerDescription = runner.getDescription();
            return runnerDescription.getChildren();
        }
        catch (Throwable throwable) {
            throw new TestSuiteExecutionException(String.format("Unable to process Ignored class %s.", className), throwable);
        }
    }
}

