/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.logging;

import grails.compiler.ast.AllArtefactClassInjector;
import grails.compiler.ast.AstTransformer;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.SourceUnit;
import org.grails.io.support.GrailsResourceUtils;

@AstTransformer
public class LoggingTransformer
implements AllArtefactClassInjector {
    public static final String LOG_PROPERTY = "log";
    private static final String FILTERS_ARTEFACT_TYPE_SUFFIX = "Filters";
    public static final String CONF_DIR = "conf";
    public static final String FILTERS_ARTEFACT_TYPE = "filters";

    public void performInjection(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        FieldNode existingField = classNode.getDeclaredField(LOG_PROPERTY);
        if (existingField == null && !classNode.isInterface()) {
            String artefactType;
            String path = source.getName();
            String string = artefactType = path != null ? GrailsResourceUtils.getArtefactDirectory((String)path) : null;
            if (artefactType != null && CONF_DIR.equals(artefactType) && classNode.getName().endsWith(FILTERS_ARTEFACT_TYPE_SUFFIX)) {
                artefactType = FILTERS_ARTEFACT_TYPE;
            }
            String logName = artefactType == null ? classNode.getName() : "grails.app." + artefactType + "." + classNode.getName();
            LoggingTransformer.addLogField(classNode, logName);
        }
    }

    public static void addLogField(ClassNode classNode, String logName) {
        FieldNode logVariable = new FieldNode(LOG_PROPERTY, 10, new ClassNode(Log.class), classNode, (Expression)new MethodCallExpression((Expression)new ClassExpression(new ClassNode(LogFactory.class)), "getLog", (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)logName))));
        classNode.addField(logVariable);
    }

    public void performInjection(SourceUnit source, ClassNode classNode) {
        this.performInjection(source, null, classNode);
    }

    public void performInjectionOnAnnotatedClass(SourceUnit source, ClassNode classNode) {
        this.performInjection(source, null, classNode);
    }

    public boolean shouldInject(URL url) {
        return true;
    }
}

