/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.geodesic;

import javajs.util.AU;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.JmolEnvCalc;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.atomdata.RadiusData;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Geodesic;
import org.jmol.util.Normix;

public final class EnvelopeCalculation
implements JmolEnvCalc {
    private BS geodesicMap;
    private BS mapT;
    private short[] mads;
    private AtomData atomData = new AtomData();
    private AtomDataServer vwr;
    private int ac;
    private static BS EMPTY_SET;
    private float maxRadius = 0.0f;
    private boolean modelZeroBased;
    private boolean disregardNeighbors = false;
    private BS bsMySelected;
    private BS[] dotsConvexMaps;
    private int dotsConvexMax;
    private int geodesicCount;
    private BS bsSurface;
    private float radiusP;
    private float diameterP;
    private BS bsTemp;
    private BS bsIgnore;
    private boolean onlySelectedDots;
    private boolean isSurface;
    private boolean multiModel;
    private P3[] currentPoints;
    private int indexI;
    private P3 centerI;
    private float radiusI;
    private float radiiIP2;
    private final P3 pointT = new P3();
    private P3 centerT;
    private final P3[] vertexTest = new P3[12];
    private static int[] power4;
    private int neighborCount;
    private int[] neighborIndices;
    private P3[] neighborCenters;
    private float[] neighborPlusProbeRadii2;
    private float[] neighborRadii2;

    public EnvelopeCalculation() {
        for (int i = 0; i < 12; ++i) {
            this.vertexTest[i] = new P3();
        }
        this.neighborIndices = new int[16];
        this.neighborCenters = new P3[16];
        this.neighborPlusProbeRadii2 = new float[16];
        this.neighborRadii2 = new float[16];
    }

    @Override
    public EnvelopeCalculation set(AtomDataServer atomDataServer, int n, short[] sArray) {
        this.vwr = atomDataServer;
        this.ac = n;
        this.mads = sArray;
        this.geodesicCount = Geodesic.getVertexCount(3);
        this.geodesicMap = BS.newN(this.geodesicCount);
        this.mapT = BS.newN(this.geodesicCount);
        EMPTY_SET = BSUtil.emptySet;
        return this;
    }

    public BS[] getDotsConvexMaps() {
        return this.dotsConvexMaps;
    }

    public int getDotsConvexMax() {
        return this.dotsConvexMax;
    }

    public void allocDotsConvexMaps(int n) {
        if (this.dotsConvexMax >= n) {
            return;
        }
        this.dotsConvexMax = n;
        this.dotsConvexMaps = new BS[n];
    }

    @Override
    public BS getBsSurfaceClone() {
        return BSUtil.copy(this.bsSurface);
    }

    public void setMads(short[] sArray) {
        this.mads = sArray;
    }

    public void setFromBits(int n, BS bS) {
        this.geodesicMap.setBits(0, this.geodesicCount);
        int n2 = this.geodesicCount;
        while (--n2 >= 0) {
            if (bS.get(n2)) continue;
            this.geodesicMap.clear(n2);
        }
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMaps = new BS[this.ac];
        }
        BS bS2 = this.geodesicMap.isEmpty() ? EMPTY_SET : BSUtil.copy(this.geodesicMap);
        if (n >= this.dotsConvexMaps.length) {
            return;
        }
        this.dotsConvexMaps[n] = bS2;
        this.dotsConvexMax = Math.max(this.dotsConvexMax, n);
    }

    public void newSet() {
        this.dotsConvexMax = 0;
        this.dotsConvexMaps = null;
        this.diameterP = 0.0f;
        this.radiusP = 0.0f;
        this.mads = null;
    }

    public void reCalculate(BS bS, M3 m3) {
        if (this.atomData.radiusData != null) {
            this.calculate(null, this.maxRadius, bS, this.bsIgnore, this.disregardNeighbors, this.onlySelectedDots, this.isSurface, this.multiModel);
            return;
        }
        if (this.dotsConvexMaps == null || this.dotsConvexMax == 0) {
            return;
        }
        V3 v3 = new V3();
        if (this.bsTemp == null) {
            this.bsTemp = Normix.newVertexBitSet();
        }
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (n >= this.dotsConvexMax) {
                return;
            }
            BS bS2 = this.dotsConvexMaps[n];
            if (bS2 != null && !bS2.isEmpty()) {
                BS bS3 = new BS();
                int n2 = bS2.nextSetBit(0);
                while (n2 >= 0) {
                    v3.setT(Geodesic.getVertexVector(n2));
                    m3.rotate(v3);
                    bS3.set(Normix.getNormixV(v3, this.bsTemp));
                    n2 = bS2.nextSetBit(n2 + 1);
                }
                this.dotsConvexMaps[n] = bS3;
            }
            n = bS.nextSetBit(n + 1);
        }
    }

    @Override
    public void calculate(RadiusData radiusData, float f, BS bS, BS bS2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n;
        int n2;
        if (radiusData == null) {
            radiusData = this.atomData.radiusData;
            if (radiusData == null) {
                return;
            }
        } else {
            this.atomData.radiusData = radiusData;
            this.bsIgnore = bS2;
            this.onlySelectedDots = bl2;
            this.multiModel = bl4;
            this.isSurface = bl3;
        }
        if (radiusData.value == Float.MAX_VALUE) {
            radiusData.value = 3.0f;
        }
        this.atomData.modelIndex = bl4 ? -1 : 0;
        this.modelZeroBased = !bl4;
        this.vwr.fillAtomData(this.atomData, 1 | (this.mads == null ? 2 : 0));
        this.ac = this.atomData.ac;
        if (this.mads != null) {
            for (n2 = 0; n2 < this.ac; ++n2) {
                this.atomData.atomRadius[n2] = (float)this.mads[n2] / 1000.0f;
            }
        }
        this.bsMySelected = bl2 && bS != null ? BSUtil.copy(bS) : (bS2 != null ? BSUtil.setAll(this.ac) : null);
        BSUtil.andNot(this.bsMySelected, bS2);
        this.disregardNeighbors = bl;
        this.maxRadius = f;
        this.bsSurface = new BS();
        n2 = bS == null ? 1 : 0;
        AtomIndexIterator atomIndexIterator = this.vwr.getSelectedAtomIterator(this.bsMySelected, false, this.modelZeroBased, false);
        this.checkNewDotsArray();
        int n3 = n = n2 != 0 ? this.ac - 1 : bS.nextSetBit(0);
        while (n3 >= 0) {
            if (bS2 == null || !bS2.get(n3)) {
                this.setAtomI(n3);
                this.getNeighbors(atomIndexIterator);
                this.calcConvexMap(bl3);
            }
            n3 = n2 != 0 ? n3 - 1 : bS.nextSetBit(n3 + 1);
        }
        atomIndexIterator.release();
        this.currentPoints = null;
        this.setDotsConvexMax();
    }

    public float getRadius(int n) {
        return this.atomData.atomRadius[n];
    }

    @Override
    public P3[] getPoints() {
        if (this.dotsConvexMaps == null) {
            this.calculate(new RadiusData(null, 3.0f, RadiusData.EnumType.ABSOLUTE, null), Float.MAX_VALUE, this.bsMySelected, null, false, false, false, false);
        }
        if (this.currentPoints != null) {
            return this.currentPoints;
        }
        int n = 0;
        int n2 = 42;
        int n3 = this.dotsConvexMax;
        while (--n3 >= 0) {
            if (this.dotsConvexMaps[n3] == null) continue;
            n += this.dotsConvexMaps[n3].cardinalityN(n2);
        }
        P3[] p3Array = new P3[n];
        if (n == 0) {
            return p3Array;
        }
        n = 0;
        int n4 = this.dotsConvexMax;
        while (--n4 >= 0) {
            if (this.dotsConvexMaps[n4] == null) continue;
            int n5 = this.dotsConvexMaps[n4].size();
            if (n5 > n2) {
                n5 = n2;
            }
            while (--n5 >= 0) {
                if (!this.dotsConvexMaps[n4].get(n5)) continue;
                P3 p3 = new P3();
                p3.scaleAdd2(this.atomData.atomRadius[n4], Geodesic.getVertexVector(n5), this.atomData.xyz[n4]);
                p3Array[n++] = p3;
            }
        }
        this.currentPoints = p3Array;
        return p3Array;
    }

    private void setDotsConvexMax() {
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMax = 0;
        } else {
            int n = this.ac;
            while (--n >= 0 && this.dotsConvexMaps[n] == null) {
            }
            this.dotsConvexMax = n + 1;
        }
    }

    public float getAppropriateRadius(int n) {
        return this.mads != null ? (n >= this.mads.length ? 0.0f : (float)this.mads[n] / 1000.0f) : this.atomData.atomRadius[n];
    }

    private void setAtomI(int n) {
        this.indexI = n;
        this.centerI = this.atomData.xyz[n];
        this.radiusI = this.atomData.atomRadius[n];
        this.radiiIP2 = this.radiusI + this.radiusP;
        this.radiiIP2 *= this.radiiIP2;
    }

    private void calcConvexMap(boolean bl) {
        BS bS;
        this.calcConvexBits();
        if (this.geodesicMap.isEmpty()) {
            bS = EMPTY_SET;
        } else {
            this.bsSurface.set(this.indexI);
            if (bl) {
                this.addIncompleteFaces(this.geodesicMap);
                this.addIncompleteFaces(this.geodesicMap);
            }
            bS = BSUtil.copy(this.geodesicMap);
        }
        this.dotsConvexMaps[this.indexI] = bS;
    }

    private void addIncompleteFaces(BS bS) {
        this.mapT.clearAll();
        short[] sArray = Geodesic.getFaceVertexes(3);
        int n = sArray.length;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            int n4 = sArray[n3++];
            int n5 = sArray[n3++];
            int n6 = sArray[n3++];
            boolean bl = bS.get(n4);
            boolean bl2 = bS.get(n5);
            boolean bl3 = bS.get(n6);
            if (!bl && !bl2 && !bl3 || bl && bl2 && bl3) continue;
            if (!bl) {
                this.mapT.set(n4);
                if (n2 < n4) {
                    n2 = n4;
                }
            }
            if (!bl2) {
                this.mapT.set(n5);
                if (n2 < n5) {
                    n2 = n5;
                }
            }
            if (bl3) continue;
            this.mapT.set(n6);
            if (n2 >= n6) continue;
            n2 = n6;
        }
        for (n3 = 0; n3 <= n2; ++n3) {
            if (!this.mapT.get(n3)) continue;
            bS.set(n3);
        }
    }

    private void calcConvexBits() {
        int n;
        this.geodesicMap.setBits(0, this.geodesicCount);
        float f = this.radiusI + this.radiusP;
        if (this.neighborCount == 0) {
            return;
        }
        short[] sArray = Geodesic.getFaceVertexes(3);
        int n2 = power4[2];
        this.mapT.clearAll();
        for (n = 0; n < 12; ++n) {
            this.vertexTest[n].scaleAdd2(f, Geodesic.getVertexVector(n), this.centerI);
        }
        for (n = 0; n < 20; ++n) {
            int n3;
            int n4 = 0;
            short s = sArray[3 * n2 * (4 * n + 0)];
            short s2 = sArray[3 * n2 * (4 * n + 1)];
            short s3 = sArray[3 * n2 * (4 * n + 2)];
            for (n3 = 0; n3 < this.neighborCount; ++n3) {
                boolean bl;
                float f2 = this.neighborPlusProbeRadii2[n3];
                this.centerT = this.neighborCenters[n3];
                boolean bl2 = this.vertexTest[s].distanceSquared(this.centerT) >= f2;
                boolean bl3 = this.vertexTest[s2].distanceSquared(this.centerT) >= f2;
                boolean bl4 = bl = this.vertexTest[s3].distanceSquared(this.centerT) >= f2;
                if (!bl2) {
                    this.geodesicMap.clear(s);
                }
                if (!bl3) {
                    this.geodesicMap.clear(s2);
                }
                if (!bl) {
                    this.geodesicMap.clear(s3);
                }
                if (bl2 || bl3 || bl) continue;
                n4 = -1;
                break;
            }
            n3 = n * 12 * n2;
            int n5 = n3 + 12 * n2;
            for (int i = n3; i < n5; ++i) {
                short s4 = sArray[i];
                if (this.mapT.get(s4) || !this.geodesicMap.get(s4)) continue;
                switch (n4) {
                    case -1: {
                        this.geodesicMap.clear(s4);
                        break;
                    }
                    case 0: {
                        for (int j = 0; j < this.neighborCount; ++j) {
                            float f3 = this.neighborPlusProbeRadii2[j];
                            this.centerT = this.neighborCenters[j];
                            this.pointT.scaleAdd2(f, Geodesic.getVertexVector(s4), this.centerI);
                            if (!(this.pointT.distanceSquared(this.centerT) < f3)) continue;
                            this.geodesicMap.clear(s4);
                        }
                        break;
                    }
                }
                this.mapT.set(s4);
            }
        }
    }

    private void checkNewDotsArray() {
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMaps = new BS[this.ac];
        } else if (this.dotsConvexMaps.length != this.ac) {
            BS[] bSArray = new BS[this.ac];
            for (int i = 0; i < this.ac && i < this.dotsConvexMaps.length; ++i) {
                bSArray[i] = this.dotsConvexMaps[i];
            }
            this.dotsConvexMaps = bSArray;
        }
    }

    private AtomIndexIterator getNeighbors(AtomIndexIterator atomIndexIterator) {
        this.neighborCount = 0;
        if (this.disregardNeighbors) {
            return null;
        }
        this.vwr.setIteratorForAtom(atomIndexIterator, this.indexI, this.radiusI + this.diameterP + this.maxRadius);
        while (atomIndexIterator.hasNext()) {
            int n = atomIndexIterator.next();
            float f = this.atomData.atomRadius[n];
            if (this.centerI.distance(this.atomData.xyz[n]) > this.radiusI + this.radiusP + this.radiusP + f) continue;
            if (this.neighborCount == this.neighborIndices.length) {
                this.neighborIndices = AU.doubleLengthI(this.neighborIndices);
                this.neighborCenters = (P3[])AU.doubleLength(this.neighborCenters);
                this.neighborPlusProbeRadii2 = AU.doubleLengthF(this.neighborPlusProbeRadii2);
                this.neighborRadii2 = AU.doubleLengthF(this.neighborRadii2);
            }
            this.neighborCenters[this.neighborCount] = this.atomData.xyz[n];
            this.neighborIndices[this.neighborCount] = n;
            float f2 = f + this.radiusP;
            this.neighborPlusProbeRadii2[this.neighborCount] = f2 * f2;
            this.neighborRadii2[this.neighborCount] = f * f;
            ++this.neighborCount;
        }
        return atomIndexIterator;
    }

    public void deleteAtoms(int n, int n2) {
        this.dotsConvexMaps = (BS[])AU.deleteElements(this.dotsConvexMaps, n, n2);
        this.dotsConvexMax = this.dotsConvexMaps.length;
        if (this.mads != null) {
            this.mads = (short[])AU.deleteElements(this.mads, n, n2);
        }
        this.atomData.atomRadius = (float[])AU.deleteElements(this.atomData.atomRadius, n, n2);
        this.atomData.xyz = (P3[])AU.deleteElements(this.atomData.xyz, n, n2);
        this.atomData.ac -= n2;
        this.ac = this.atomData.ac;
    }

    static {
        power4 = new int[]{1, 4, 16, 64, 256};
    }
}

