/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Hashtable;
import java.util.Map;
import javajs.awt.Font;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.JmolMeasurementClient;
import org.jmol.atomdata.RadiusData;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.MeasurementPending;
import org.jmol.modelset.TickInfo;
import org.jmol.shape.AtomShape;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.Point3fi;

public class Measures
extends AtomShape
implements JmolMeasurementClient {
    private BS bsSelected;
    private String strFormat;
    private boolean mustBeConnected = false;
    private boolean mustNotBeConnected = false;
    private RadiusData radiusData;
    private Boolean intramolecular;
    private boolean measureAllModels;
    public int measurementCount = 0;
    public final Lst<Measurement> measurements = new Lst();
    public MeasurementPending mPending;
    public short colix;
    TickInfo tickInfo;
    TickInfo defaultTickInfo;
    public Font font3d;
    private Map<String, Integer> htMin;
    private int tokAction;

    @Override
    protected void initModelSet() {
        int n = this.measurements.size();
        while (--n >= 0) {
            Measurement measurement = (Measurement)this.measurements.get(n);
            if (measurement == null) continue;
            measurement.ms = this.ms;
        }
        this.atoms = this.ms.at;
    }

    @Override
    public void initShape() {
        this.font3d = this.vwr.gdata.getFont3D(15.0f);
    }

    @Override
    protected void setSize(int n, BS bS) {
        this.mad = (short)n;
    }

    @Override
    public void setProperty(String string, Object object, BS bS) {
        int n;
        int n2;
        if ("clearModelIndex" == string) {
            for (int i = 0; i < this.measurementCount; ++i) {
                ((Measurement)this.measurements.get(i)).setModelIndex((short)0);
            }
            return;
        }
        if ("color" == string) {
            this.setColor(C.getColixO(object));
            return;
        }
        if ("font" == string) {
            this.font3d = (Font)object;
            return;
        }
        if ("hideAll" == string) {
            this.showHide((Boolean)object);
            return;
        }
        if ("pending" == string) {
            this.mPending = (MeasurementPending)object;
            if (this.mPending == null) {
                return;
            }
            if (this.mPending.count > 1) {
                this.vwr.setStatusMeasuring("measurePending", this.mPending.count, Measures.getMessage(this.mPending, false), this.mPending.value);
            }
            return;
        }
        boolean bl = "refresh" == string;
        if (bl || "refreshTrajectories" == string) {
            int n3 = this.measurements.size();
            while (--n3 >= 0) {
                Measurement measurement = (Measurement)this.measurements.get(n3);
                if (measurement == null || !bl && !measurement.isTrajectory) continue;
                measurement.refresh(null);
            }
            return;
        }
        if ("select" == string) {
            BS bS2 = (BS)object;
            if (bS2 == null || BSUtil.cardinalityOf(bS2) == 0) {
                this.bsSelected = null;
            } else {
                this.bsSelected = new BS();
                this.bsSelected.or(bS2);
            }
            return;
        }
        if ("setFormats" == string) {
            this.setFormats((String)object);
            return;
        }
        this.measureAllModels = this.vwr.getBoolean(603979878);
        if ("delete" == string) {
            this.deleteO(object);
            this.setIndices();
            return;
        }
        this.bsSelected = null;
        if ("maps" == string) {
            int[][] nArray = (int[][])object;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n = nArray[n2].length;
                if (n < 2 || n > 4) continue;
                int[] nArray2 = new int[n + 1];
                nArray2[0] = n;
                System.arraycopy(nArray[n2], 0, nArray2, 1, n);
                this.toggleOn(nArray2);
            }
        } else if ("measure" == string) {
            MeasurementData measurementData = (MeasurementData)object;
            this.tickInfo = measurementData.tickInfo;
            if (measurementData.tickInfo != null && measurementData.tickInfo.id.equals("default")) {
                this.defaultTickInfo = measurementData.tickInfo;
                return;
            }
            if (measurementData.isAll && measurementData.points.size() == 2 && measurementData.points.get(0) instanceof BS) {
                int n4 = Measurement.nmrType(this.vwr.getDistanceUnits(measurementData.strFormat));
                switch (n4) {
                    case 2: {
                        measurementData.htMin = this.vwr.getNMRCalculation().getMinDistances(measurementData);
                    }
                }
            }
            this.tickInfo = measurementData.tickInfo;
            this.radiusData = measurementData.radiusData;
            this.htMin = measurementData.htMin;
            this.mustBeConnected = measurementData.mustBeConnected;
            this.mustNotBeConnected = measurementData.mustNotBeConnected;
            this.intramolecular = measurementData.intramolecular;
            this.strFormat = measurementData.strFormat;
            if (measurementData.isAll) {
                if (this.tickInfo != null) {
                    this.define(measurementData, 12291);
                }
                this.define(measurementData, measurementData.tokAction);
                this.setIndices();
                return;
            }
            Measurement measurement = this.setSingleItem(measurementData.points);
            if (measurementData.thisID != null) {
                measurement.thisID = measurementData.thisID;
                measurement.mad = measurementData.mad;
                if (measurementData.colix != 0) {
                    measurement.colix = measurementData.colix;
                }
                measurement.strFormat = measurementData.strFormat;
                measurement.text = measurementData.text;
            }
            switch (measurementData.tokAction) {
                case 12291: {
                    this.defineAll(Integer.MIN_VALUE, measurement, true, false, false);
                    this.setIndices();
                    break;
                }
                case 1073742335: {
                    this.showHideM(measurement, false);
                    break;
                }
                case 1073742334: {
                    this.showHideM(measurement, true);
                    break;
                }
                case 1665140738: {
                    if (measurementData.thisID == null) break;
                    this.doAction(measurementData, measurementData.thisID, 1665140738);
                    break;
                }
                case 12290: {
                    if (measurementData.thisID == null) {
                        this.deleteM(measurement);
                    } else {
                        this.deleteO(measurementData.thisID);
                    }
                    this.toggle(measurement);
                    break;
                }
                case 268435538: {
                    this.toggle(measurement);
                }
            }
            return;
        }
        if ("clear" == string) {
            this.clear();
            return;
        }
        if ("deleteModelAtoms" == string) {
            this.atoms = (Atom[])((Object[])object)[1];
            int n5 = ((int[])((Object[])object)[2])[0];
            n2 = ((int[])((Object[])object)[2])[1];
            n = ((int[])((Object[])object)[2])[2];
            int n6 = n2 + n;
            int n7 = this.measurementCount;
            block14: while (--n7 >= 0) {
                Measurement measurement = (Measurement)this.measurements.get(n7);
                int[] nArray = measurement.countPlusIndices;
                for (int i = 1; i <= nArray[0]; ++i) {
                    int n8 = nArray[i];
                    if (n8 >= n2) {
                        if (n8 < n6) {
                            this.deleteI(n7);
                            continue block14;
                        }
                        int n9 = i;
                        nArray[n9] = nArray[n9] - n;
                        continue;
                    }
                    if (n8 >= 0) continue;
                    Point3fi point3fi = measurement.getAtom(i);
                    if (point3fi.mi > n5) {
                        point3fi.mi = (short)(point3fi.mi - 1);
                        continue;
                    }
                    if (point3fi.mi != n5) continue;
                    this.deleteI(n7);
                    continue block14;
                }
            }
            return;
        }
        if ("reformatDistances" == string) {
            this.reformatDistances();
            return;
        }
        if ("hide" == string) {
            if (object instanceof String) {
                this.doAction(null, (String)object, 12294);
            } else {
                this.showHideM(new Measurement().setPoints(this.ms, (int[])object, null, null), true);
            }
            return;
        }
        if ("show" == string) {
            if (object instanceof String) {
                this.doAction(null, (String)object, 134222350);
            } else {
                this.showHideM(new Measurement().setPoints(this.ms, (int[])object, null, null), false);
            }
            return;
        }
        if ("toggle" == string) {
            if (object instanceof String) {
                this.doAction(null, (String)object, 268435538);
            } else {
                this.toggle(new Measurement().setPoints(this.ms, (int[])object, null, null));
            }
            return;
        }
        if ("toggleOn" == string) {
            if (object instanceof String) {
                this.doAction(null, (String)object, 1073742335);
            } else {
                this.toggleOn((int[])object);
            }
            return;
        }
    }

    private Measurement setSingleItem(Lst<Object> lst) {
        Point3fi[] point3fiArray = new Point3fi[4];
        int[] nArray = new int[5];
        nArray[0] = lst.size();
        int n = lst.size();
        while (--n >= 0) {
            Object e = lst.get(n);
            if (e instanceof BS) {
                int n2 = ((BS)e).nextSetBit(0);
                if (n2 < 0) {
                    return null;
                }
                nArray[n + 1] = n2;
                continue;
            }
            point3fiArray[n] = (Point3fi)e;
            nArray[n + 1] = -2 - n;
        }
        return new Measurement().setPoints(this.ms, nArray, point3fiArray, this.tickInfo == null ? this.defaultTickInfo : this.tickInfo);
    }

    @Override
    public Object getProperty(String string, int n) {
        if ("pending".equals(string)) {
            return this.mPending;
        }
        if ("count".equals(string)) {
            return this.measurementCount;
        }
        if ("countPlusIndices".equals(string)) {
            return n < this.measurementCount ? ((Measurement)this.measurements.get((int)n)).countPlusIndices : null;
        }
        if ("stringValue".equals(string)) {
            return n < this.measurementCount ? ((Measurement)this.measurements.get(n)).getString() : null;
        }
        if ("pointInfo".equals(string)) {
            return ((Measurement)this.measurements.get(n / 10)).getLabel(n % 10, false, false);
        }
        if ("info".equals(string)) {
            return this.getAllInfo();
        }
        if ("infostring".equals(string)) {
            return this.getAllInfoAsString();
        }
        return null;
    }

    public void clear() {
        if (this.measurementCount == 0) {
            return;
        }
        this.measurementCount = 0;
        this.measurements.clear();
        this.mPending = null;
        this.vwr.setStatusMeasuring("measureDeleted", -1, "all", 0.0f);
    }

    private void setColor(short s) {
        if (this.bsColixSet == null) {
            this.bsColixSet = new BS();
        }
        if (this.bsSelected == null) {
            this.colix = s;
        }
        int n = this.measurements.size();
        while (--n >= 0) {
            Measurement measurement = (Measurement)this.measurements.get(n);
            if (measurement == null || (this.bsSelected == null || !this.bsSelected.get(n)) && (this.bsSelected != null || s != 0 && measurement.colix != 0)) continue;
            measurement.colix = s;
            this.bsColixSet.set(n);
        }
    }

    private void setFormats(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        int n = this.measurements.size();
        while (--n >= 0) {
            if (this.bsSelected != null && !this.bsSelected.get(n)) continue;
            ((Measurement)this.measurements.get(n)).formatMeasurementAs(string, null, false);
        }
    }

    private void showHide(boolean bl) {
        int n = this.measurements.size();
        while (--n >= 0) {
            if (this.bsSelected != null && !this.bsSelected.get(n)) continue;
            ((Measurement)this.measurements.get((int)n)).isHidden = bl;
        }
    }

    private void showHideM(Measurement measurement, boolean bl) {
        int n = this.find(measurement);
        if (n >= 0) {
            ((Measurement)this.measurements.get((int)n)).isHidden = bl;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void toggle(Measurement var1_1) {
        this.radiusData = null;
        this.htMin = null;
        var2_2 = this.find(var1_1);
        if (var2_2 < 0) ** GOTO lbl-1000
        var3_3 = (Measurement)this.measurements.get(var2_2);
        if (!var3_3.isHidden) {
            this.defineAll(var2_2, var3_3, true, false, false);
        } else lbl-1000:
        // 2 sources

        {
            this.defineAll(-1, var1_1, false, true, false);
        }
        this.setIndices();
    }

    private void toggleOn(int[] nArray) {
        this.radiusData = null;
        this.htMin = null;
        this.bsSelected = new BS();
        this.defineAll(Integer.MIN_VALUE, new Measurement().setPoints(this.ms, nArray, null, this.defaultTickInfo), false, true, true);
        this.setIndices();
        this.reformatDistances();
    }

    private void deleteM(Measurement measurement) {
        this.radiusData = null;
        this.htMin = null;
        int n = this.find(measurement);
        if (n >= 0) {
            this.defineAll(n, (Measurement)this.measurements.get(n), true, false, false);
        }
        this.setIndices();
    }

    private void deleteO(Object object) {
        if (object instanceof Integer) {
            this.deleteI((Integer)object);
        } else if (object instanceof String) {
            this.doAction(null, (String)object, 12291);
        } else if (AU.isAI(object)) {
            this.defineAll(Integer.MIN_VALUE, new Measurement().setPoints(this.ms, (int[])object, null, null), true, false, false);
        }
    }

    private void defineAll(int n, Measurement measurement, boolean bl, boolean bl2, boolean bl3) {
        if (!this.measureAllModels) {
            if (bl) {
                if (n == Integer.MIN_VALUE) {
                    n = this.find(measurement);
                }
                if (n >= 0) {
                    this.deleteI(n);
                }
                return;
            }
            this.defineMeasurement(n, measurement, bl3);
            return;
        }
        if (bl2) {
            this.defineAll(n, measurement, true, false, false);
            if (bl) {
                return;
            }
        }
        Lst<Object> lst = new Lst<Object>();
        int n2 = measurement.count;
        for (int i = 1; i <= n2; ++i) {
            int n3 = measurement.getAtomIndex(i);
            lst.addLast(n3 >= 0 ? this.vwr.ms.getAtoms(1094715393, this.atoms[n3].getAtomNumber()) : measurement.getAtom(i));
        }
        this.define(new MeasurementData().init(null, this.vwr, lst).set(this.tokAction, this.htMin, this.radiusData, this.strFormat, null, this.tickInfo, this.mustBeConnected, this.mustNotBeConnected, this.intramolecular, true, 0, (short)0, null), bl ? 12291 : 12290);
    }

    private int find(Measurement measurement) {
        return measurement.thisID == null ? Measurement.find(this.measurements, measurement) : -1;
    }

    private void setIndices() {
        for (int i = 0; i < this.measurementCount; ++i) {
            ((Measurement)this.measurements.get((int)i)).index = i;
        }
    }

    private void define(MeasurementData measurementData, int n) {
        this.tokAction = n;
        measurementData.define(this, this.ms);
    }

    @Override
    public void processNextMeasure(Measurement measurement) {
        int n = this.find(measurement);
        if (n >= 0) {
            if (this.tokAction == 12291) {
                this.deleteI(n);
            } else if (this.strFormat != null) {
                ((Measurement)this.measurements.get(n)).formatMeasurementAs(this.strFormat, null, true);
            } else {
                ((Measurement)this.measurements.get((int)n)).isHidden = this.tokAction == 1073742334;
            }
        } else if (this.tokAction == 12290 || this.tokAction == 268435538) {
            measurement.tickInfo = this.tickInfo == null ? this.defaultTickInfo : this.tickInfo;
            this.defineMeasurement(-1, measurement, true);
        }
    }

    private void defineMeasurement(int n, Measurement measurement, boolean bl) {
        float f = measurement.getMeasurement(null);
        if (this.htMin != null && !measurement.isMin(this.htMin) || this.radiusData != null && !measurement.isInRange(this.radiusData, f)) {
            return;
        }
        if (n == Integer.MIN_VALUE) {
            n = this.find(measurement);
        }
        if (n >= 0) {
            ((Measurement)this.measurements.get((int)n)).isHidden = false;
            if (bl) {
                this.bsSelected.set(n);
            }
            return;
        }
        Measurement measurement2 = new Measurement().setM(this.ms, measurement, f, measurement.colix == 0 ? this.colix : measurement.colix, this.strFormat, this.measurementCount);
        if (!measurement2.isValid) {
            return;
        }
        this.measurements.addLast(measurement2);
        this.vwr.setStatusMeasuring("measureCompleted", this.measurementCount++, Measures.getMessage(measurement2, false), measurement2.value);
    }

    private static String getMessage(Measurement measurement, boolean bl) {
        SB sB = new SB();
        sB.append("[");
        for (int i = 1; i <= measurement.count; ++i) {
            if (i > 1) {
                sB.append(", ");
            }
            sB.append(measurement.getLabel(i, bl, false));
        }
        sB.append("]");
        return sB.toString();
    }

    private void deleteI(int n) {
        if (n >= this.measurements.size() || n < 0) {
            return;
        }
        String string = Measures.getMessage((Measurement)this.measurements.get(n), true);
        this.measurements.remove(n);
        --this.measurementCount;
        this.vwr.setStatusMeasuring("measureDeleted", n, string, 0.0f);
    }

    private void doAction(MeasurementData measurementData, String string, int n) {
        string = string.toUpperCase().replace('?', '*');
        boolean bl = PT.isWild(string);
        int n2 = this.measurements.size();
        while (--n2 >= 0) {
            Measurement measurement = (Measurement)this.measurements.get(n2);
            if (measurement.thisID == null || !measurement.thisID.equalsIgnoreCase(string) && (!bl || !PT.isMatch(measurement.thisID.toUpperCase(), string, true, true))) continue;
            switch (n) {
                case 1665140738: {
                    measurement.mad = measurementData.mad;
                    break;
                }
                case 12291: {
                    String string2 = Measures.getMessage((Measurement)this.measurements.get(n2), true);
                    this.measurements.remove(n2);
                    --this.measurementCount;
                    this.vwr.setStatusMeasuring("measureDeleted", n2, string2, 0.0f);
                    break;
                }
                case 134222350: {
                    measurement.isHidden = false;
                    break;
                }
                case 12294: {
                    measurement.isHidden = true;
                    break;
                }
                case 268435538: {
                    measurement.isHidden = !measurement.isHidden;
                    break;
                }
                case 1073742335: {
                    measurement.isHidden = false;
                }
            }
        }
    }

    private void reformatDistances() {
        int n = this.measurementCount;
        while (--n >= 0) {
            ((Measurement)this.measurements.get(n)).reformatDistanceIfSelected();
        }
    }

    private Lst<Map<String, Object>> getAllInfo() {
        Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
        for (int i = 0; i < this.measurementCount; ++i) {
            lst.addLast(this.getInfo(i));
        }
        return lst;
    }

    private String getAllInfoAsString() {
        String string = "Measurement Information";
        for (int i = 0; i < this.measurementCount; ++i) {
            string = string + "\n" + this.getInfoAsString(i);
        }
        return string;
    }

    private Map<String, Object> getInfo(int n) {
        Measurement measurement = (Measurement)this.measurements.get(n);
        int n2 = measurement.count;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("index", n);
        hashtable.put("type", n2 == 2 ? "distance" : (n2 == 3 ? "angle" : "dihedral"));
        hashtable.put("strMeasurement", measurement.getString());
        hashtable.put("count", n2);
        hashtable.put("value", Float.valueOf(measurement.value));
        TickInfo tickInfo = measurement.tickInfo;
        if (tickInfo != null) {
            hashtable.put("ticks", tickInfo.ticks);
            if (tickInfo.scale != null) {
                hashtable.put("tickScale", tickInfo.scale);
            }
            if (tickInfo.tickLabelFormats != null) {
                hashtable.put("tickLabelFormats", tickInfo.tickLabelFormats);
            }
            if (!Float.isNaN(tickInfo.first)) {
                hashtable.put("tickStart", Float.valueOf(tickInfo.first));
            }
        }
        Lst lst = new Lst();
        for (int i = 1; i <= n2; ++i) {
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            int n3 = measurement.getAtomIndex(i);
            hashtable2.put("_ipt", n3);
            hashtable2.put("coord", Escape.eP(measurement.getAtom(i)));
            hashtable2.put("atomno", n3 < 0 ? -1 : this.atoms[n3].getAtomNumber());
            hashtable2.put("info", n3 < 0 ? "<point>" : this.atoms[n3].getInfo());
            lst.addLast(hashtable2);
        }
        hashtable.put("atoms", lst);
        return hashtable;
    }

    @Override
    public String getInfoAsString(int n) {
        return ((Measurement)this.measurements.get(n)).getInfoAsString(null);
    }

    public void setVisibilityInfo() {
        BS bS = this.vwr.getVisibleFramesBitSet();
        int n = this.measurementCount;
        block0: while (--n >= 0) {
            Measurement measurement = (Measurement)this.measurements.get(n);
            measurement.isVisible = false;
            if (this.mad == 0 || measurement.isHidden) continue;
            for (int i = measurement.count; i > 0; --i) {
                short s;
                int n2 = measurement.getAtomIndex(i);
                if (n2 >= 0 ? !this.ms.at[n2].isClickable() : (s = measurement.getAtom((int)i).mi) >= 0 && !bS.get(s)) continue block0;
            }
            measurement.isVisible = true;
        }
    }

    @Override
    public String getShapeState() {
        return this.vwr.getMeasurementState(this, this.measurements, this.measurementCount, this.font3d, this.defaultTickInfo);
    }
}

