/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jmol.awt.JmolFrame;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.jmolpanel.MeasurementTable;
import org.openscience.jmol.app.jmolpanel.StatusBar;

public class DisplayPanel
extends JPanel
implements JmolFrame,
ComponentListener,
Printable {
    StatusBar status;
    Viewer vwr;
    private String displaySpeed;
    private Dimension startupDimension;
    boolean haveDisplay;
    Point border;
    boolean haveBorder;
    MeasurementTable measurementTable;
    JmolPanel jmolPanel;
    private JFrame frame;
    private boolean showPaintTime = true;
    final Dimension dimSize = new Dimension();
    private final Rectangle rectClip = new Rectangle();
    AbstractButton buttonRotate;
    AbstractButton buttonModelkit;
    ButtonGroup toolbarButtonGroup = new ButtonGroup();
    private HomeAction homeAction = new HomeAction();
    private DefineCenterAction defineCenterAction = new DefineCenterAction();
    private Action frontAction = new MoveToAction("front", "moveto 2.0 front");
    private Action topAction = new MoveToAction("top", "moveto 1.0 front;moveto 2.0 top");
    private Action bottomAction = new MoveToAction("bottom", "moveto 1.0 front;moveto 2.0 bottom");
    private Action rightAction = new MoveToAction("right", "moveto 1.0 front;moveto 2.0 right");
    private Action leftAction = new MoveToAction("left", "moveto 1.0 front;moveto 2.0 left");
    private Action hydrogensAction = new CheckBoxMenuItemAction("hydrogensCheck", "set showHydrogens");
    private Action measurementsAction = new CheckBoxMenuItemAction("measurementsCheck", "set showMeasurements");
    private Action perspectiveAction = new CheckBoxMenuItemAction("perspectiveCheck", "set PerspectiveDepth");
    private Action axesAction = new CheckBoxMenuItemAction("axesCheck", "set showAxes");
    private Action boundboxAction = new CheckBoxMenuItemAction("boundboxCheck", "set showBoundBox");
    private Action deleteAction = new SetStatusAction("delete", GT._("Delete atoms"));
    private Action zoomAction = new SetStatusAction("zoom", null);
    private Action xlateAction = new SetStatusAction("xlate", null);
    private static int timeLast = 0;
    private static int timeCount;
    private static int timeTotal;
    private long timeBegin;
    private int lastMotionEventNumber;

    @Override
    public JFrame getFrame() {
        return this.frame;
    }

    DisplayPanel(JmolPanel jmolPanel) {
        this.jmolPanel = jmolPanel;
        this.frame = jmolPanel.frame;
        this.status = jmolPanel.status;
        this.border = jmolPanel.jmolApp.border;
        this.haveDisplay = jmolPanel.jmolApp.haveDisplay;
        this.startupDimension = new Dimension(jmolPanel.startupWidth, jmolPanel.startupHeight);
        this.setFocusable(true);
        if (System.getProperty("painttime", "false").equals("true")) {
            this.showPaintTime = true;
        }
        this.displaySpeed = System.getProperty("display.speed");
        if (this.displaySpeed == null) {
            this.displaySpeed = "ms";
        }
        this.setDoubleBuffered(false);
    }

    void setViewer(Viewer viewer) {
        this.vwr = viewer;
        this.updateSize(false);
    }

    public void start() {
        this.addComponentListener(this);
    }

    boolean isRotateMode() {
        return this.buttonRotate != null && this.buttonRotate.isSelected();
    }

    void setRotateMode() {
        if (this.buttonRotate != null && !this.isRotateMode()) {
            this.buttonRotate.setSelected(true);
            this.vwr.setSelectionHalosEnabled(false);
        }
    }

    void setModelkitMode() {
        if (this.buttonModelkit != null) {
            this.buttonModelkit.setSelected(true);
        }
        this.vwr.setSelectionHalosEnabled(false);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.updateSize(true);
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.updateSize(true);
    }

    private void updateSize(boolean bl) {
        if (this.haveDisplay) {
            this.getSize(this.dimSize);
            this.vwr.setScreenDimension(this.dimSize.width, this.dimSize.height);
        } else {
            this.vwr.setScreenDimension(this.startupDimension.width, this.startupDimension.height);
        }
        if (!bl) {
            return;
        }
        this.setRotateMode();
        if (this.haveDisplay) {
            this.status.setStatus(2, this.dimSize.width + " x " + this.dimSize.height);
        }
        this.vwr.refresh(3, "updateSize");
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.showPaintTime) {
            this.startPaintClock();
        }
        if (this.dimSize.width == 0) {
            return;
        }
        this.vwr.renderScreenImage((Object)graphics, this.dimSize.width, this.dimSize.height);
        if (this.border == null) {
            this.border = new Point();
        }
        if (!this.haveBorder) {
            this.setBorder();
        }
        if (this.showPaintTime) {
            this.stopPaintClock();
        }
    }

    void setBorder() {
        if (this.dimSize.width < 50) {
            return;
        }
        this.border.x = this.startupDimension.width - this.dimSize.width;
        this.border.y = this.startupDimension.height - this.dimSize.height;
        this.haveBorder = true;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        float f;
        float f2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (n > 0) {
            return 1;
        }
        this.rectClip.y = 0;
        this.rectClip.x = 0;
        int n3 = this.rectClip.width = this.vwr.getScreenWidth();
        int n4 = this.rectClip.height = this.vwr.getScreenHeight();
        Object object = this.vwr.getScreenImageBuffer(null, true);
        int n5 = (int)pageFormat.getImageableX();
        int n6 = (int)pageFormat.getImageableY();
        int n7 = (int)pageFormat.getImageableWidth();
        float f3 = (float)n7 / (float)n3;
        float f4 = f2 = f3 < (f = (float)(n2 = (int)pageFormat.getImageableHeight()) / (float)n4) ? f3 : f;
        if (f2 < 1.0f) {
            int n8 = (int)((float)n3 * f2);
            int n9 = (int)((float)n4 * f2);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage((Image)object, n5, n6, n8, n9, null);
        } else {
            graphics2D.drawImage((Image)object, n5, n6, null);
        }
        this.vwr.releaseScreenImage();
        return 0;
    }

    public Action[] getActions() {
        return new Action[]{this.deleteAction, this.zoomAction, this.xlateAction, this.frontAction, this.topAction, this.bottomAction, this.rightAction, this.leftAction, this.defineCenterAction, this.hydrogensAction, this.measurementsAction, this.homeAction, this.perspectiveAction, this.axesAction, this.boundboxAction};
    }

    private void resetTimes() {
        timeTotal = 0;
        timeCount = 0;
        timeLast = -1;
    }

    private void recordTime(int n) {
        if (timeLast != -1) {
            timeTotal += timeLast;
            ++timeCount;
        }
        timeLast = n;
    }

    private void startPaintClock() {
        this.timeBegin = System.currentTimeMillis();
        int n = this.vwr.getMotionEventNumber();
        if (this.lastMotionEventNumber != n) {
            this.lastMotionEventNumber = n;
            this.resetTimes();
        }
    }

    private void stopPaintClock() {
        int n = (int)(System.currentTimeMillis() - this.timeBegin);
        this.recordTime(n);
        this.showTimes();
    }

    private String fmt(int n) {
        if (n < 0) {
            return "---";
        }
        if (n < 10) {
            return "  " + n;
        }
        if (n < 100) {
            return " " + n;
        }
        return "" + n;
    }

    private void showTimes() {
        int n;
        int n2 = n = timeCount == 0 ? -1 : (timeTotal + timeCount / 2) / timeCount;
        if (this.displaySpeed.equalsIgnoreCase("fps")) {
            this.status.setStatus(3, this.fmt(1000 / timeLast) + "FPS : " + this.fmt(1000 / n) + "FPS");
        } else {
            this.status.setStatus(3, this.vwr.getP("_memory") + " Mb; " + this.fmt(timeLast) + "/" + n + " ms");
        }
    }

    public void setJmolSize(Dimension dimension) {
        this.dimSize.width = dimension.width;
        this.dimSize.height = dimension.height;
        this.setPreferredSize(dimension);
    }

    private class CheckBoxMenuItemAction
    extends AbstractAction {
        private final String action;

        public CheckBoxMenuItemAction(String string, String string2) {
            super(string);
            this.action = string2;
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            DisplayPanel.this.vwr.evalStringQuiet(this.action + " " + jCheckBoxMenuItem.isSelected());
        }
    }

    class HomeAction
    extends AbstractAction {
        public HomeAction() {
            super("home");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DisplayPanel.this.vwr.homePosition();
            DisplayPanel.this.setRotateMode();
        }
    }

    class DefineCenterAction
    extends AbstractAction {
        public DefineCenterAction() {
            super("definecenter");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DisplayPanel.this.vwr.evalStringQuiet("center (selected)");
            DisplayPanel.this.setRotateMode();
        }
    }

    private class MoveToAction
    extends AbstractAction {
        private final String action;

        public MoveToAction(String string, String string2) {
            super(string);
            this.action = string2;
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DisplayPanel.this.vwr.getShowBbcage() || DisplayPanel.this.vwr.getBooleanProperty("showUnitCell")) {
                DisplayPanel.this.vwr.evalStringQuiet(this.action);
            } else {
                DisplayPanel.this.vwr.evalStringQuiet("boundbox on;" + this.action + ";delay 1;boundbox off");
            }
        }
    }

    private class SetStatusAction
    extends AbstractAction {
        private final String statusText;

        public SetStatusAction(String string, String string2) {
            super(string);
            this.statusText = string2;
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DisplayPanel.this.vwr.setSelectionHalosEnabled(false);
            if (this.statusText != null) {
                DisplayPanel.this.status.setStatus(1, this.statusText);
            } else {
                DisplayPanel.this.status.setStatus(1, ((JComponent)actionEvent.getSource()).getToolTipText());
            }
        }
    }
}

