/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.jcs.access.exception.CacheException;
import org.apache.commons.jcs.access.exception.ObjectNotFoundException;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.behavior.ICache;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheType;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs.engine.control.event.ElementEvent;
import org.apache.commons.jcs.engine.control.event.behavior.ElementEventType;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventHandler;
import org.apache.commons.jcs.engine.control.event.behavior.IElementEventQueue;
import org.apache.commons.jcs.engine.control.group.GroupId;
import org.apache.commons.jcs.engine.match.KeyMatcherPatternImpl;
import org.apache.commons.jcs.engine.match.behavior.IKeyMatcher;
import org.apache.commons.jcs.engine.memory.behavior.IMemoryCache;
import org.apache.commons.jcs.engine.memory.lru.LRUMemoryCache;
import org.apache.commons.jcs.engine.memory.shrinking.ShrinkerThread;
import org.apache.commons.jcs.engine.stats.CacheStats;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.behavior.ICacheStats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeCache<K, V>
implements ICache<K, V>,
IRequireScheduler {
    private static final Log log = LogFactory.getLog(CompositeCache.class);
    private IElementEventQueue elementEventQ;
    private AuxiliaryCache<K, V>[] auxCaches = new AuxiliaryCache[0];
    private AtomicBoolean alive;
    private IElementAttributes attr;
    private ICompositeCacheAttributes cacheAttr;
    private AtomicInteger updateCount;
    private AtomicInteger removeCount;
    private AtomicInteger hitCountRam;
    private AtomicInteger hitCountAux;
    private AtomicInteger missCountNotFound;
    private AtomicInteger missCountExpired;
    private IMemoryCache<K, V> memCache;
    private IKeyMatcher<K> keyMatcher = new KeyMatcherPatternImpl();

    public CompositeCache(ICompositeCacheAttributes iCompositeCacheAttributes, IElementAttributes iElementAttributes) {
        this.attr = iElementAttributes;
        this.cacheAttr = iCompositeCacheAttributes;
        this.alive = new AtomicBoolean(true);
        this.updateCount = new AtomicInteger(0);
        this.removeCount = new AtomicInteger(0);
        this.hitCountRam = new AtomicInteger(0);
        this.hitCountAux = new AtomicInteger(0);
        this.missCountNotFound = new AtomicInteger(0);
        this.missCountExpired = new AtomicInteger(0);
        this.createMemoryCache(iCompositeCacheAttributes);
        if (log.isInfoEnabled()) {
            log.info("Constructed cache with name [" + this.cacheAttr.getCacheName() + "] and cache attributes " + iCompositeCacheAttributes);
        }
    }

    public void setElementEventQueue(IElementEventQueue iElementEventQueue) {
        this.elementEventQ = iElementEventQueue;
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        if (this.cacheAttr.isUseMemoryShrinker()) {
            scheduledExecutorService.scheduleAtFixedRate(new ShrinkerThread(this), 0L, this.cacheAttr.getShrinkerIntervalSeconds(), TimeUnit.SECONDS);
        }
    }

    public void setAuxCaches(AuxiliaryCache<K, V>[] auxiliaryCacheArray) {
        this.auxCaches = auxiliaryCacheArray;
    }

    public AuxiliaryCache<K, V>[] getAuxCaches() {
        return this.auxCaches;
    }

    @Override
    public void update(ICacheElement<K, V> iCacheElement) throws IOException {
        this.update(iCacheElement, false);
    }

    public void localUpdate(ICacheElement<K, V> iCacheElement) throws IOException {
        this.update(iCacheElement, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(ICacheElement<K, V> iCacheElement, boolean bl) throws IOException {
        if (iCacheElement.getKey() instanceof String && iCacheElement.getKey().toString().endsWith(":")) {
            throw new IllegalArgumentException("key must not end with : for a put operation");
        }
        if (iCacheElement.getKey() instanceof GroupId) {
            throw new IllegalArgumentException("key cannot be a GroupId  for a put operation");
        }
        if (log.isDebugEnabled()) {
            log.debug("Updating memory cache " + iCacheElement.getKey());
        }
        this.updateCount.incrementAndGet();
        CompositeCache compositeCache = this;
        synchronized (compositeCache) {
            this.memCache.update(iCacheElement);
            this.updateAuxiliaries(iCacheElement, bl);
        }
        iCacheElement.getElementAttributes().setLastAccessTimeNow();
    }

    protected void updateAuxiliaries(ICacheElement<K, V> iCacheElement, boolean bl) throws IOException {
        if (log.isDebugEnabled()) {
            if (this.auxCaches.length > 0) {
                log.debug("Updating auxiliary caches");
            } else {
                log.debug("No auxiliary cache to update");
            }
        }
        block7: for (AuxiliaryCache<K, V> auxiliaryCache : this.auxCaches) {
            if (auxiliaryCache == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("Auxiliary cache type: " + (Object)((Object)auxiliaryCache.getCacheType()));
            }
            switch (auxiliaryCache.getCacheType()) {
                case REMOTE_CACHE: {
                    if (log.isDebugEnabled()) {
                        log.debug("ce.getElementAttributes().getIsRemote() = " + iCacheElement.getElementAttributes().getIsRemote());
                    }
                    if (!iCacheElement.getElementAttributes().getIsRemote() || bl) continue block7;
                    try {
                        auxiliaryCache.update(iCacheElement);
                        if (!log.isDebugEnabled()) continue block7;
                        log.debug("Updated remote store for " + iCacheElement.getKey() + iCacheElement);
                    }
                    catch (IOException iOException) {
                        log.error("Failure in updateExclude", iOException);
                    }
                    continue block7;
                }
                case LATERAL_CACHE: {
                    if (log.isDebugEnabled()) {
                        log.debug("lateralcache in aux list: cattr " + this.cacheAttr.isUseLateral());
                    }
                    if (!this.cacheAttr.isUseLateral() || !iCacheElement.getElementAttributes().getIsLateral() || bl) continue block7;
                    auxiliaryCache.update(iCacheElement);
                    if (!log.isDebugEnabled()) continue block7;
                    log.debug("updated lateral cache for " + iCacheElement.getKey());
                    continue block7;
                }
                case DISK_CACHE: {
                    if (log.isDebugEnabled()) {
                        log.debug("diskcache in aux list: cattr " + this.cacheAttr.isUseDisk());
                    }
                    if (!this.cacheAttr.isUseDisk() || this.cacheAttr.getDiskUsagePattern() != ICompositeCacheAttributes.DiskUsagePattern.UPDATE || !iCacheElement.getElementAttributes().getIsSpool()) continue block7;
                    auxiliaryCache.update(iCacheElement);
                    if (!log.isDebugEnabled()) continue block7;
                    log.debug("updated disk cache for " + iCacheElement.getKey());
                    continue block7;
                }
            }
        }
    }

    public void spoolToDisk(ICacheElement<K, V> iCacheElement) {
        if (!iCacheElement.getElementAttributes().getIsSpool()) {
            this.handleElementEvent(iCacheElement, ElementEventType.SPOOLED_NOT_ALLOWED);
            return;
        }
        boolean bl = false;
        for (AuxiliaryCache<K, V> auxiliaryCache : this.auxCaches) {
            if (auxiliaryCache == null || auxiliaryCache.getCacheType() != ICacheType.CacheType.DISK_CACHE) continue;
            bl = true;
            if (this.cacheAttr.getDiskUsagePattern() == ICompositeCacheAttributes.DiskUsagePattern.SWAP) {
                try {
                    this.handleElementEvent(iCacheElement, ElementEventType.SPOOLED_DISK_AVAILABLE);
                    auxiliaryCache.update(iCacheElement);
                }
                catch (IOException iOException) {
                    log.error("Problem spooling item to disk cache.", iOException);
                    throw new IllegalStateException(iOException.getMessage());
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("spoolToDisk done for: " + iCacheElement.getKey() + " on disk cache[" + auxiliaryCache.getCacheName() + "]");
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("DiskCache available, but JCS is not configured to use the DiskCache as a swap.");
        }
        if (!bl) {
            try {
                this.handleElementEvent(iCacheElement, ElementEventType.SPOOLED_DISK_NOT_AVAILABLE);
            }
            catch (Exception exception) {
                log.error("Trouble handling the ELEMENT_EVENT_SPOOLED_DISK_NOT_AVAILABLE  element event", exception);
            }
        }
    }

    @Override
    public ICacheElement<K, V> get(K k) {
        return this.get(k, false);
    }

    public ICacheElement<K, V> localGet(K k) {
        return this.get(k, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICacheElement<K, V> get(K k, boolean bl) {
        ICacheElement<K, V> iCacheElement = null;
        boolean bl2 = false;
        if (log.isDebugEnabled()) {
            log.debug("get: key = " + k + ", localOnly = " + bl);
        }
        CompositeCache compositeCache = this;
        synchronized (compositeCache) {
            block24: {
                try {
                    iCacheElement = this.memCache.get(k);
                    if (iCacheElement != null) {
                        if (this.isExpired(iCacheElement)) {
                            if (log.isDebugEnabled()) {
                                log.debug(this.cacheAttr.getCacheName() + " - Memory cache hit, but element expired");
                            }
                            this.missCountExpired.incrementAndGet();
                            this.remove(k);
                            iCacheElement = null;
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug(this.cacheAttr.getCacheName() + " - Memory cache hit");
                            }
                            this.hitCountRam.incrementAndGet();
                        }
                        bl2 = true;
                        break block24;
                    }
                    for (AuxiliaryCache<K, V> auxiliaryCache : this.auxCaches) {
                        if (auxiliaryCache == null) continue;
                        ICacheType.CacheType cacheType = auxiliaryCache.getCacheType();
                        if (!bl || cacheType == ICacheType.CacheType.DISK_CACHE) {
                            if (log.isDebugEnabled()) {
                                log.debug("Attempting to get from aux [" + auxiliaryCache.getCacheName() + "] which is of type: " + (Object)((Object)cacheType));
                            }
                            try {
                                iCacheElement = auxiliaryCache.get(k);
                            }
                            catch (IOException iOException) {
                                log.error("Error getting from aux", iOException);
                            }
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Got CacheElement: " + iCacheElement);
                        }
                        if (iCacheElement == null) continue;
                        if (this.isExpired(iCacheElement)) {
                            if (log.isDebugEnabled()) {
                                log.debug(this.cacheAttr.getCacheName() + " - Aux cache[" + auxiliaryCache.getCacheName() + "] hit, but element expired.");
                            }
                            this.missCountExpired.incrementAndGet();
                            this.remove(k);
                            iCacheElement = null;
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug(this.cacheAttr.getCacheName() + " - Aux cache[" + auxiliaryCache.getCacheName() + "] hit");
                            }
                            this.hitCountAux.incrementAndGet();
                            this.copyAuxiliaryRetrievedItemToMemory(iCacheElement);
                        }
                        bl2 = true;
                        break;
                    }
                }
                catch (IOException iOException) {
                    log.error("Problem encountered getting element.", iOException);
                }
            }
        }
        if (!bl2) {
            this.missCountNotFound.incrementAndGet();
            if (log.isDebugEnabled()) {
                log.debug(this.cacheAttr.getCacheName() + " - Miss");
            }
        }
        if (iCacheElement != null) {
            iCacheElement.getElementAttributes().setLastAccessTimeNow();
        }
        return iCacheElement;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> set) {
        return this.getMultiple(set, false);
    }

    public Map<K, ICacheElement<K, V>> localGetMultiple(Set<K> set) {
        return this.getMultiple(set, true);
    }

    protected Map<K, ICacheElement<K, V>> getMultiple(Set<K> set, boolean bl) {
        HashMap<K, ICacheElement<K, V>> hashMap = new HashMap<K, ICacheElement<K, V>>();
        if (log.isDebugEnabled()) {
            log.debug("get: key = " + set + ", localOnly = " + bl);
        }
        try {
            hashMap.putAll(this.getMultipleFromMemory(set));
            if (hashMap.size() != set.size()) {
                Set<K> set2 = this.pruneKeysFound(set, hashMap);
                hashMap.putAll(this.getMultipleFromAuxiliaryCaches(set2, bl));
            }
        }
        catch (IOException iOException) {
            log.error("Problem encountered getting elements.", iOException);
        }
        if (hashMap.size() != set.size()) {
            this.missCountNotFound.addAndGet(set.size() - hashMap.size());
            if (log.isDebugEnabled()) {
                log.debug(this.cacheAttr.getCacheName() + " - " + (set.size() - hashMap.size()) + " Misses");
            }
        }
        return hashMap;
    }

    private Map<K, ICacheElement<K, V>> getMultipleFromMemory(Set<K> set) throws IOException {
        Map<K, ICacheElement<K, V>> map = this.memCache.getMultiple(set);
        for (ICacheElement<K, V> iCacheElement : new HashMap<K, ICacheElement<K, V>>(map).values()) {
            if (iCacheElement == null) continue;
            if (this.isExpired(iCacheElement)) {
                if (log.isDebugEnabled()) {
                    log.debug(this.cacheAttr.getCacheName() + " - Memory cache hit, but element expired");
                }
                this.missCountExpired.incrementAndGet();
                this.remove(iCacheElement.getKey());
                map.remove(iCacheElement.getKey());
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug(this.cacheAttr.getCacheName() + " - Memory cache hit");
            }
            this.hitCountRam.incrementAndGet();
        }
        return map;
    }

    private Map<K, ICacheElement<K, V>> getMultipleFromAuxiliaryCaches(Set<K> set, boolean bl) throws IOException {
        HashMap hashMap = new HashMap();
        Set<K> set2 = new HashSet<K>(set);
        for (AuxiliaryCache<K, V> auxiliaryCache : this.auxCaches) {
            if (auxiliaryCache == null) continue;
            HashMap hashMap2 = new HashMap();
            ICacheType.CacheType cacheType = auxiliaryCache.getCacheType();
            if (!bl || cacheType == ICacheType.CacheType.DISK_CACHE) {
                if (log.isDebugEnabled()) {
                    log.debug("Attempting to get from aux [" + auxiliaryCache.getCacheName() + "] which is of type: " + (Object)((Object)cacheType));
                }
                try {
                    hashMap2.putAll(auxiliaryCache.getMultiple(set2));
                }
                catch (IOException iOException) {
                    log.error("Error getting from aux", iOException);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Got CacheElements: " + hashMap2);
            }
            this.processRetrievedElements(auxiliaryCache, hashMap2);
            hashMap.putAll(hashMap2);
            if (hashMap.size() == set.size()) break;
            set2 = this.pruneKeysFound(set, hashMap);
        }
        return hashMap;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String string) {
        return this.getMatching(string, false);
    }

    public Map<K, ICacheElement<K, V>> localGetMatching(String string) {
        return this.getMatching(string, true);
    }

    protected Map<K, ICacheElement<K, V>> getMatching(String string, boolean bl) {
        HashMap<K, ICacheElement<K, V>> hashMap = new HashMap<K, ICacheElement<K, V>>();
        if (log.isDebugEnabled()) {
            log.debug("get: pattern [" + string + "], localOnly = " + bl);
        }
        try {
            hashMap.putAll(this.getMatchingFromAuxiliaryCaches(string, bl));
            hashMap.putAll(this.getMatchingFromMemory(string));
        }
        catch (Exception exception) {
            log.error("Problem encountered getting elements.", exception);
        }
        return hashMap;
    }

    protected Map<K, ICacheElement<K, V>> getMatchingFromMemory(String string) throws IOException {
        Set<K> set = this.memCache.getKeySet();
        Set<K> set2 = this.getKeyMatcher().getMatchingKeysFromArray(string, set);
        return this.getMultipleFromMemory(set2);
    }

    private Map<K, ICacheElement<K, V>> getMatchingFromAuxiliaryCaches(String string, boolean bl) throws IOException {
        HashMap hashMap = new HashMap();
        for (int i = this.auxCaches.length - 1; i >= 0; --i) {
            AuxiliaryCache<K, V> auxiliaryCache = this.auxCaches[i];
            if (auxiliaryCache == null) continue;
            HashMap hashMap2 = new HashMap();
            ICacheType.CacheType cacheType = auxiliaryCache.getCacheType();
            if (bl && cacheType != ICacheType.CacheType.DISK_CACHE) continue;
            if (log.isDebugEnabled()) {
                log.debug("Attempting to get from aux [" + auxiliaryCache.getCacheName() + "] which is of type: " + (Object)((Object)cacheType));
            }
            try {
                hashMap2.putAll(auxiliaryCache.getMatching(string));
            }
            catch (IOException iOException) {
                log.error("Error getting from aux", iOException);
            }
            if (log.isDebugEnabled()) {
                log.debug("Got CacheElements: " + hashMap2);
            }
            this.processRetrievedElements(auxiliaryCache, hashMap2);
            hashMap.putAll(hashMap2);
        }
        return hashMap;
    }

    private void processRetrievedElements(AuxiliaryCache<K, V> auxiliaryCache, Map<K, ICacheElement<K, V>> map) throws IOException {
        for (ICacheElement<K, V> iCacheElement : new HashMap<K, ICacheElement<K, V>>(map).values()) {
            if (iCacheElement == null) continue;
            if (this.isExpired(iCacheElement)) {
                if (log.isDebugEnabled()) {
                    log.debug(this.cacheAttr.getCacheName() + " - Aux cache[" + auxiliaryCache.getCacheName() + "] hit, but element expired.");
                }
                this.missCountExpired.incrementAndGet();
                this.remove(iCacheElement.getKey());
                map.remove(iCacheElement.getKey());
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug(this.cacheAttr.getCacheName() + " - Aux cache[" + auxiliaryCache.getCacheName() + "] hit");
            }
            this.hitCountAux.incrementAndGet();
            this.copyAuxiliaryRetrievedItemToMemory(iCacheElement);
        }
    }

    private void copyAuxiliaryRetrievedItemToMemory(ICacheElement<K, V> iCacheElement) throws IOException {
        if (this.memCache.getCacheAttributes().getMaxObjects() > 0) {
            this.memCache.update(iCacheElement);
        } else if (log.isDebugEnabled()) {
            log.debug("Skipping memory update since no items are allowed in memory");
        }
    }

    private Set<K> pruneKeysFound(Set<K> set, Map<K, ICacheElement<K, V>> map) {
        HashSet<K> hashSet = new HashSet<K>(set);
        for (K k : map.keySet()) {
            hashSet.remove(k);
        }
        return hashSet;
    }

    public Set<K> getKeySet() {
        return this.getKeySet(false);
    }

    public Set<K> getKeySet(boolean bl) {
        HashSet<K> hashSet = new HashSet<K>();
        hashSet.addAll(this.memCache.getKeySet());
        for (AuxiliaryCache<K, V> auxiliaryCache : this.auxCaches) {
            if (auxiliaryCache == null || bl && auxiliaryCache.getCacheType() != ICacheType.CacheType.DISK_CACHE) continue;
            try {
                hashSet.addAll(auxiliaryCache.getKeySet());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return hashSet;
    }

    @Override
    public boolean remove(K k) {
        return this.remove(k, false);
    }

    public boolean localRemove(K k) {
        return this.remove(k, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(K k, boolean bl) {
        this.removeCount.incrementAndGet();
        boolean bl2 = false;
        CompositeCache compositeCache = this;
        synchronized (compositeCache) {
            try {
                bl2 = this.memCache.remove(k);
            }
            catch (IOException iOException) {
                log.error(iOException);
            }
            for (AuxiliaryCache<K, V> auxiliaryCache : this.auxCaches) {
                if (auxiliaryCache == null) continue;
                ICacheType.CacheType cacheType = auxiliaryCache.getCacheType();
                if (bl && (cacheType == ICacheType.CacheType.REMOTE_CACHE || cacheType == ICacheType.CacheType.LATERAL_CACHE)) continue;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Removing " + k + " from cacheType" + (Object)((Object)cacheType));
                    }
                    boolean bl3 = auxiliaryCache.remove(k);
                    if (bl2 || cacheType == ICacheType.CacheType.REMOTE_CACHE) continue;
                    bl2 = bl3;
                }
                catch (IOException iOException) {
                    log.error("Failure removing from aux", iOException);
                }
            }
        }
        return bl2;
    }

    @Override
    public void removeAll() throws IOException {
        this.removeAll(false);
    }

    public void localRemoveAll() throws IOException {
        this.removeAll(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAll(boolean bl) throws IOException {
        CompositeCache compositeCache = this;
        synchronized (compositeCache) {
            try {
                this.memCache.removeAll();
                if (log.isDebugEnabled()) {
                    log.debug("Removed All keys from the memory cache.");
                }
            }
            catch (IOException iOException) {
                log.error("Trouble updating memory cache.", iOException);
            }
            for (AuxiliaryCache<K, V> auxiliaryCache : this.auxCaches) {
                if (auxiliaryCache == null || auxiliaryCache.getCacheType() != ICacheType.CacheType.DISK_CACHE && bl) continue;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Removing All keys from cacheType" + (Object)((Object)auxiliaryCache.getCacheType()));
                    }
                    auxiliaryCache.removeAll();
                }
                catch (IOException iOException) {
                    log.error("Failure removing all from aux", iOException);
                }
            }
        }
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(boolean bl) {
        if (log.isInfoEnabled()) {
            log.info("In DISPOSE, [" + this.cacheAttr.getCacheName() + "] fromRemote [" + bl + "]");
        }
        if (!this.alive.compareAndSet(true, false)) {
            return;
        }
        CompositeCache compositeCache = this;
        synchronized (compositeCache) {
            if (this.elementEventQ != null) {
                this.elementEventQ.dispose();
                this.elementEventQ = null;
            }
            for (AuxiliaryCache<K, V> auxiliaryCache : this.auxCaches) {
                try {
                    if (auxiliaryCache == null || auxiliaryCache.getStatus() != CacheStatus.ALIVE || bl && auxiliaryCache.getCacheType() == ICacheType.CacheType.REMOTE_CACHE) {
                        if (!log.isInfoEnabled()) continue;
                        log.info("In DISPOSE, [" + this.cacheAttr.getCacheName() + "] SKIPPING auxiliary [" + auxiliaryCache.getCacheName() + "] fromRemote [" + bl + "]");
                        continue;
                    }
                    if (log.isInfoEnabled()) {
                        log.info("In DISPOSE, [" + this.cacheAttr.getCacheName() + "] auxiliary [" + auxiliaryCache.getCacheName() + "]");
                    }
                    if (auxiliaryCache.getCacheType() == ICacheType.CacheType.DISK_CACHE) {
                        int n = this.memCache.getSize();
                        this.memCache.freeElements(n);
                        if (log.isInfoEnabled()) {
                            log.info("In DISPOSE, [" + this.cacheAttr.getCacheName() + "] put " + n + " into auxiliary " + auxiliaryCache.getCacheName());
                        }
                    }
                    auxiliaryCache.dispose();
                }
                catch (IOException iOException) {
                    log.error("Failure disposing of aux.", iOException);
                }
            }
            if (log.isInfoEnabled()) {
                log.info("In DISPOSE, [" + this.cacheAttr.getCacheName() + "] disposing of memory cache.");
            }
            try {
                this.memCache.dispose();
            }
            catch (IOException iOException) {
                log.error("Failure disposing of memCache", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (!this.alive.compareAndSet(true, false)) {
            return;
        }
        CompositeCache compositeCache = this;
        synchronized (compositeCache) {
            for (AuxiliaryCache<K, V> auxiliaryCache : this.auxCaches) {
                try {
                    if (auxiliaryCache.getStatus() != CacheStatus.ALIVE) continue;
                    for (K k : this.memCache.getKeySet()) {
                        ICacheElement<K, V> iCacheElement = this.memCache.get(k);
                        if (iCacheElement == null) continue;
                        auxiliaryCache.update(iCacheElement);
                    }
                }
                catch (IOException iOException) {
                    log.error("Failure saving aux caches.", iOException);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Called save for [" + this.cacheAttr.getCacheName() + "]");
        }
    }

    @Override
    public int getSize() {
        return this.memCache.getSize();
    }

    @Override
    public ICacheType.CacheType getCacheType() {
        return ICacheType.CacheType.CACHE_HUB;
    }

    @Override
    public CacheStatus getStatus() {
        return this.alive.get() ? CacheStatus.ALIVE : CacheStatus.DISPOSED;
    }

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    public ICacheStats getStatistics() {
        CacheStats cacheStats = new CacheStats();
        cacheStats.setRegionName(this.getCacheName());
        ArrayList arrayList = new ArrayList();
        arrayList.add(new StatElement<Integer>("HitCountRam", this.getHitCountRam()));
        arrayList.add(new StatElement<Integer>("HitCountAux", this.getHitCountAux()));
        cacheStats.setStatElements(arrayList);
        int n = this.auxCaches.length + 1;
        ArrayList<IStats> arrayList2 = new ArrayList<IStats>(n);
        arrayList2.add(this.getMemoryCache().getStatistics());
        for (AuxiliaryCache<K, V> auxiliaryCache : this.auxCaches) {
            arrayList2.add(auxiliaryCache.getStatistics());
        }
        cacheStats.setAuxiliaryCacheStats(arrayList2);
        return cacheStats;
    }

    @Override
    public String getCacheName() {
        return this.cacheAttr.getCacheName();
    }

    public IElementAttributes getElementAttributes() {
        if (this.attr != null) {
            return this.attr.clone();
        }
        return null;
    }

    public void setElementAttributes(IElementAttributes iElementAttributes) {
        this.attr = iElementAttributes;
    }

    public ICompositeCacheAttributes getCacheAttributes() {
        return this.cacheAttr;
    }

    public void setCacheAttributes(ICompositeCacheAttributes iCompositeCacheAttributes) {
        this.cacheAttr = iCompositeCacheAttributes;
        this.memCache.initialize(this);
    }

    public IElementAttributes getElementAttributes(K k) throws CacheException, IOException {
        ICacheElement<K, V> iCacheElement = this.get(k);
        if (iCacheElement == null) {
            throw new ObjectNotFoundException("key " + k + " is not found");
        }
        return iCacheElement.getElementAttributes();
    }

    public boolean isExpired(ICacheElement<K, V> iCacheElement) {
        return this.isExpired(iCacheElement, System.currentTimeMillis(), ElementEventType.EXCEEDED_MAXLIFE_ONREQUEST, ElementEventType.EXCEEDED_IDLETIME_ONREQUEST);
    }

    public boolean isExpired(ICacheElement<K, V> iCacheElement, long l, ElementEventType elementEventType, ElementEventType elementEventType2) {
        try {
            IElementAttributes iElementAttributes = iCacheElement.getElementAttributes();
            if (!iElementAttributes.getIsEternal()) {
                long l2 = iElementAttributes.getMaxLife();
                long l3 = iElementAttributes.getCreateTime();
                long l4 = iElementAttributes.getTimeFactorForMilliseconds();
                if (l2 != -1L && l - l3 > l2 * l4) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exceeded maxLife: " + iCacheElement.getKey());
                    }
                    this.handleElementEvent(iCacheElement, elementEventType);
                    return true;
                }
                long l5 = iElementAttributes.getIdleTime();
                long l6 = iElementAttributes.getLastAccessTime();
                if (l5 != -1L && l - l6 > l5 * l4) {
                    if (log.isDebugEnabled()) {
                        log.info("Exceeded maxIdle: " + iCacheElement.getKey());
                    }
                    this.handleElementEvent(iCacheElement, elementEventType2);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            log.error("Error determining expiration period, expiring", exception);
            return true;
        }
        return false;
    }

    public void handleElementEvent(ICacheElement<K, V> iCacheElement, ElementEventType elementEventType) {
        ArrayList<IElementEventHandler> arrayList = iCacheElement.getElementAttributes().getElementEventHandlers();
        if (arrayList != null) {
            if (log.isDebugEnabled()) {
                log.debug("Element Handlers are registered.  Create event type " + (Object)((Object)elementEventType));
            }
            if (this.elementEventQ == null) {
                log.warn("No element event queue available for cache " + this.getCacheName());
                return;
            }
            ElementEvent<ICacheElement<K, V>> elementEvent = new ElementEvent<ICacheElement<K, V>>(iCacheElement, elementEventType);
            for (IElementEventHandler iElementEventHandler : arrayList) {
                try {
                    this.elementEventQ.addElementEvent(iElementEventHandler, elementEvent);
                }
                catch (IOException iOException) {
                    log.error("Trouble adding element event to queue", iOException);
                }
            }
        }
    }

    private void createMemoryCache(ICompositeCacheAttributes iCompositeCacheAttributes) {
        if (this.memCache == null) {
            try {
                IMemoryCache iMemoryCache;
                Class<?> clazz = Class.forName(iCompositeCacheAttributes.getMemoryCacheName());
                this.memCache = iMemoryCache = (IMemoryCache)clazz.newInstance();
                this.memCache.initialize(this);
            }
            catch (Exception exception) {
                log.warn("Failed to init mem cache, using: LRUMemoryCache", exception);
                this.memCache = new LRUMemoryCache();
                this.memCache.initialize(this);
            }
        } else {
            log.warn("Refusing to create memory cache -- already exists.");
        }
    }

    public IMemoryCache<K, V> getMemoryCache() {
        return this.memCache;
    }

    public int getHitCountRam() {
        return this.hitCountRam.get();
    }

    public int getHitCountAux() {
        return this.hitCountAux.get();
    }

    public int getMissCountNotFound() {
        return this.missCountNotFound.get();
    }

    public int getMissCountExpired() {
        return this.missCountExpired.get();
    }

    public int getUpdateCount() {
        return this.updateCount.get();
    }

    @Override
    public void setKeyMatcher(IKeyMatcher<K> iKeyMatcher) {
        if (iKeyMatcher != null) {
            this.keyMatcher = iKeyMatcher;
        }
    }

    public IKeyMatcher<K> getKeyMatcher() {
        return this.keyMatcher;
    }

    public String toString() {
        return this.getStats();
    }
}

