/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.NoteInputDialog;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.NotesDialog;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AddNoteAction
extends MapMode
implements KeyPressReleaseListener {
    private final transient NoteData noteData;

    public AddNoteAction(MapFrame mapFrame, NoteData noteData) {
        super(I18n.tr("Add a new Note", new Object[0]), "addnote", I18n.tr("Add note mode", new Object[0]), mapFrame, ImageProvider.getCursor("crosshair", "create_note"));
        CheckParameterUtil.ensureParameterNotNull(noteData, "data");
        this.noteData = noteData;
    }

    @Override
    public String getModeHelpText() {
        return I18n.tr("Click the location where you wish to create a new note", new Object[0]);
    }

    @Override
    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
        Main.map.keyDetector.addKeyListener(this);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.keyDetector.removeKeyListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        Main.map.selectMapMode(Main.map.mapModeSelect);
        NoteInputDialog noteInputDialog = new NoteInputDialog(Main.parent, I18n.tr("Create new note", new Object[0]), I18n.tr("Create note", new Object[0]));
        noteInputDialog.showNoteDialog(I18n.tr("Enter a detailed comment to create a note", new Object[0]), NotesDialog.ICON_NEW);
        if (noteInputDialog.getValue() != 1) {
            Main.debug("User aborted note creation");
            return;
        }
        String string = noteInputDialog.getInputText();
        if (string != null && !string.isEmpty()) {
            LatLon latLon = Main.map.mapView.getLatLon(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            this.noteData.createNote(latLon, string);
        } else {
            new Notification(I18n.tr("You must enter a comment to create a new note", new Object[0])).setIcon(2).show();
        }
    }

    @Override
    public void doKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            Main.map.selectMapMode(Main.map.mapModeSelect);
        }
    }

    @Override
    public void doKeyReleased(KeyEvent keyEvent) {
    }
}

