/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;

public class DoubleStereographic
extends AbstractProj {
    private Ellipsoid ellps;
    private double n;
    private double c;
    private double chi0;
    private double r;
    private static final double EPSILON = 1.0E-12;

    @Override
    public String getName() {
        return I18n.tr("Double Stereographic", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "sterea";
    }

    @Override
    public void initialize(ProjParameters projParameters) throws ProjectionConfigurationException {
        super.initialize(projParameters);
        if (projParameters.lat0 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_0"));
        }
        this.ellps = projParameters.ellps;
        this.initialize(projParameters.lat0);
    }

    private void initialize(double d) {
        double d2 = Math.toRadians(d);
        double d3 = this.ellps.e2;
        this.r = Math.sqrt(1.0 - d3) / (1.0 - d3 * Math.pow(Math.sin(d2), 2.0));
        this.n = Math.sqrt(1.0 + this.ellps.eb2 * Math.pow(Math.cos(d2), 4.0));
        double d4 = (1.0 + Math.sin(d2)) / (1.0 - Math.sin(d2));
        double d5 = (1.0 - this.e * Math.sin(d2)) / (1.0 + this.e * Math.sin(d2));
        double d6 = Math.pow(d4 * Math.pow(d5, this.e), this.n);
        double d7 = (d6 - 1.0) / (d6 + 1.0);
        this.c = (this.n + Math.sin(d2)) * (1.0 - d7) / ((this.n - Math.sin(d2)) * (1.0 + d7));
        double d8 = this.c * d6;
        this.chi0 = Math.asin((d8 - 1.0) / (d8 + 1.0));
    }

    @Override
    public double[] project(double d, double d2) {
        double d3 = this.n * d2;
        double d4 = (1.0 + Math.sin(d)) / (1.0 - Math.sin(d));
        double d5 = (1.0 - this.e * Math.sin(d)) / (1.0 + this.e * Math.sin(d));
        double d6 = this.c * Math.pow(d4 * Math.pow(d5, this.e), this.n);
        double d7 = Math.asin((d6 - 1.0) / (d6 + 1.0));
        double d8 = 1.0 + Math.sin(d7) * Math.sin(this.chi0) + Math.cos(d7) * Math.cos(this.chi0) * Math.cos(d3);
        double d9 = 2.0 * this.r * Math.cos(d7) * Math.sin(d3) / d8;
        double d10 = 2.0 * this.r * (Math.sin(d7) * Math.cos(this.chi0) - Math.cos(d7) * Math.sin(this.chi0) * Math.cos(d3)) / d8;
        return new double[]{d9, d10};
    }

    @Override
    public double[] invproject(double d, double d2) {
        double d3 = this.ellps.e2;
        double d4 = 2.0 * this.r * Math.tan(0.7853981633974483 - this.chi0 / 2.0);
        double d5 = 4.0 * this.r * Math.tan(this.chi0) + d4;
        double d6 = Math.atan(d / (d5 + d2));
        double d7 = Math.atan(d / (d4 - d2)) - d6;
        double d8 = this.chi0 + 2.0 * Math.atan((d2 - d * Math.tan(d7 / 2.0)) / (2.0 * this.r));
        double d9 = d7 + 2.0 * d6;
        double d10 = d9 / this.n;
        double d11 = 0.5 * Math.log((1.0 + Math.sin(d8)) / (this.c * (1.0 - Math.sin(d8)))) / this.n;
        double d12 = -1000.0;
        int n = 0;
        double d13 = 2.0 * Math.atan(Math.exp(d11)) - 1.5707963267948966;
        while (Math.abs(d13 - d12) > 1.0E-12) {
            if (++n > 10) {
                throw new RuntimeException("Too many iterations");
            }
            d12 = d13;
            double d14 = Math.log(Math.tan(d13 / 2.0 + 0.7853981633974483) * Math.pow((1.0 - this.e * Math.sin(d13)) / (1.0 + this.e * Math.sin(d13)), this.e / 2.0));
            d13 -= (d14 - d11) * Math.cos(d13) * (1.0 - d3 * Math.pow(Math.sin(d13), 2.0)) / (1.0 - d3);
        }
        return new double[]{d13, d10};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-89.0, -87.0, 89.0, 87.0, false);
    }
}

