/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.preferences.Setting;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.AbstractUploadDialog;
import org.openstreetmap.josm.gui.io.BasicUploadSettingsPanel;
import org.openstreetmap.josm.gui.io.ChangesetCommentModel;
import org.openstreetmap.josm.gui.io.ChangesetManagementPanel;
import org.openstreetmap.josm.gui.io.ConfigurationParameterRequestHandler;
import org.openstreetmap.josm.gui.io.IUploadDialog;
import org.openstreetmap.josm.gui.io.TagSettingsPanel;
import org.openstreetmap.josm.gui.io.UploadParameterSummaryPanel;
import org.openstreetmap.josm.gui.io.UploadStrategy;
import org.openstreetmap.josm.gui.io.UploadStrategySelectionPanel;
import org.openstreetmap.josm.gui.io.UploadStrategySpecification;
import org.openstreetmap.josm.gui.io.UploadedObjectsSummaryPanel;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

public class UploadDialog
extends AbstractUploadDialog
implements PropertyChangeListener,
Preferences.PreferenceChangedListener {
    private static UploadDialog uploadDialog;
    private static final Collection<Component> customComponents;
    private static final String CREATED_BY = "created_by";
    private UploadedObjectsSummaryPanel pnlUploadedObjects;
    private ChangesetManagementPanel pnlChangesetManagement;
    private BasicUploadSettingsPanel pnlBasicUploadSettings;
    private UploadStrategySelectionPanel pnlUploadStrategySelectionPanel;
    private TagSettingsPanel pnlTagSettings;
    private JTabbedPane tpConfigPanels;
    private JButton btnUpload;
    private final transient ChangesetCommentModel changesetCommentModel = new ChangesetCommentModel();
    private final transient ChangesetCommentModel changesetSourceModel = new ChangesetCommentModel();
    private transient DataSet dataSet;

    public UploadDialog() {
        super((Window)JOptionPane.getFrameForComponent(Main.parent), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    public static synchronized UploadDialog getUploadDialog() {
        if (uploadDialog == null) {
            uploadDialog = new UploadDialog();
        }
        return uploadDialog;
    }

    protected JPanel buildContentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pnlUploadedObjects = new UploadedObjectsSummaryPanel();
        jPanel.add((Component)this.pnlUploadedObjects, GBC.eol().fill(1));
        for (Component component : customComponents) {
            jPanel.add(component, GBC.eol().fill(2));
        }
        this.tpConfigPanels = new JTabbedPane(){

            @Override
            public Dimension getPreferredSize() {
                return super.getMinimumSize();
            }
        };
        this.pnlBasicUploadSettings = new BasicUploadSettingsPanel(this.changesetCommentModel, this.changesetSourceModel);
        this.tpConfigPanels.add(this.pnlBasicUploadSettings);
        this.tpConfigPanels.setTitleAt(0, I18n.tr("Settings", new Object[0]));
        this.tpConfigPanels.setToolTipTextAt(0, I18n.tr("Decide how to upload the data and which changeset to use", new Object[0]));
        this.pnlTagSettings = new TagSettingsPanel(this.changesetCommentModel, this.changesetSourceModel);
        this.tpConfigPanels.add(this.pnlTagSettings);
        this.tpConfigPanels.setTitleAt(1, I18n.tr("Tags of new changeset", new Object[0]));
        this.tpConfigPanels.setToolTipTextAt(1, I18n.tr("Apply tags to the changeset data is uploaded to", new Object[0]));
        this.pnlChangesetManagement = new ChangesetManagementPanel(this.changesetCommentModel);
        this.tpConfigPanels.add(this.pnlChangesetManagement);
        this.tpConfigPanels.setTitleAt(2, I18n.tr("Changesets", new Object[0]));
        this.tpConfigPanels.setToolTipTextAt(2, I18n.tr("Manage open changesets and select a changeset to upload to", new Object[0]));
        this.pnlUploadStrategySelectionPanel = new UploadStrategySelectionPanel();
        this.tpConfigPanels.add(this.pnlUploadStrategySelectionPanel);
        this.tpConfigPanels.setTitleAt(3, I18n.tr("Advanced", new Object[0]));
        this.tpConfigPanels.setToolTipTextAt(3, I18n.tr("Configure advanced settings", new Object[0]));
        jPanel.add((Component)this.tpConfigPanels, GBC.eol().fill(2));
        return jPanel;
    }

    protected JPanel buildActionPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.btnUpload = new SideButton(new UploadAction(this));
        jPanel.add(this.btnUpload);
        this.btnUpload.setFocusable(true);
        InputMapUtils.enableEnter(this.btnUpload);
        CancelAction cancelAction = new CancelAction(this);
        jPanel.add(new SideButton(cancelAction));
        this.getRootPane().registerKeyboardAction(cancelAction, KeyStroke.getKeyStroke(27, 0), 2);
        jPanel.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/Upload"))));
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/Upload"));
        return jPanel;
    }

    protected void build() {
        this.setTitle(I18n.tr("Upload to ''{0}''", OsmApi.getOsmApi().getBaseUrl()));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildContentPanel(), "Center");
        this.getContentPane().add((Component)this.buildActionPanel(), "South");
        this.addWindowListener(new WindowEventHandler());
        this.pnlChangesetManagement.addPropertyChangeListener(this);
        this.pnlChangesetManagement.addPropertyChangeListener(this.pnlBasicUploadSettings.getUploadParameterSummaryPanel());
        this.pnlChangesetManagement.addPropertyChangeListener(this);
        this.pnlUploadedObjects.addPropertyChangeListener(this.pnlBasicUploadSettings.getUploadParameterSummaryPanel());
        this.pnlUploadedObjects.addPropertyChangeListener(this.pnlUploadStrategySelectionPanel);
        this.pnlUploadStrategySelectionPanel.addPropertyChangeListener(this.pnlBasicUploadSettings.getUploadParameterSummaryPanel());
        this.pnlBasicUploadSettings.getUploadParameterSummaryPanel().setConfigurationParameterRequestListener(new ConfigurationParameterRequestHandler(){

            @Override
            public void handleUploadStrategyConfigurationRequest() {
                UploadDialog.this.tpConfigPanels.setSelectedIndex(3);
            }

            @Override
            public void handleChangesetConfigurationRequest() {
                UploadDialog.this.tpConfigPanels.setSelectedIndex(2);
            }
        });
        this.pnlBasicUploadSettings.setUploadTagDownFocusTraversalHandlers(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UploadDialog.this.btnUpload.requestFocusInWindow();
            }
        });
        this.setMinimumSize(new Dimension(300, 350));
        Main.pref.addPreferenceChangeListener(this);
    }

    public void setUploadedPrimitives(APIDataSet aPIDataSet) {
        if (aPIDataSet == null) {
            List<OsmPrimitive> list = Collections.emptyList();
            this.pnlUploadedObjects.setUploadedPrimitives(list, list, list);
            return;
        }
        this.pnlUploadedObjects.setUploadedPrimitives(aPIDataSet.getPrimitivesToAdd(), aPIDataSet.getPrimitivesToUpdate(), aPIDataSet.getPrimitivesToDelete());
    }

    public void setChangesetTags(DataSet dataSet) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("source", this.getLastChangesetSourceFromHistory());
        hashMap.put("comment", this.getLastChangesetCommentFromHistory());
        if (dataSet != null) {
            hashMap.putAll(dataSet.getChangeSetTags());
        }
        this.dataSet = dataSet;
        if (this.pnlChangesetManagement.getSelectedChangeset() != null) {
            hashMap.putAll(this.pnlChangesetManagement.getSelectedChangeset().getKeys());
        }
        String string = Version.getInstance().getAgentString(false);
        String string2 = (String)hashMap.get(CREATED_BY);
        if (string2 == null || string2.isEmpty()) {
            hashMap.put(CREATED_BY, string);
        } else if (!string2.contains(string)) {
            hashMap.put(CREATED_BY, string2 + ';' + string);
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)hashMap.get(iterator.next());
            if (string3 != null && !string3.isEmpty()) continue;
            iterator.remove();
        }
        this.pnlTagSettings.initFromTags(hashMap);
        this.pnlTagSettings.tableChanged(null);
    }

    @Override
    public void rememberUserInput() {
        this.pnlBasicUploadSettings.rememberUserInput();
        this.pnlUploadStrategySelectionPanel.rememberUserInput();
    }

    public void startUserInput() {
        this.tpConfigPanels.setSelectedIndex(0);
        this.pnlBasicUploadSettings.startUserInput();
        this.pnlTagSettings.startUserInput();
        this.pnlUploadStrategySelectionPanel.initFromPreferences();
        UploadParameterSummaryPanel uploadParameterSummaryPanel = this.pnlBasicUploadSettings.getUploadParameterSummaryPanel();
        uploadParameterSummaryPanel.setUploadStrategySpecification(this.pnlUploadStrategySelectionPanel.getUploadStrategySpecification());
        uploadParameterSummaryPanel.setCloseChangesetAfterNextUpload(this.pnlChangesetManagement.isCloseChangesetAfterUpload());
        uploadParameterSummaryPanel.setNumObjects(this.pnlUploadedObjects.getNumObjectsToUpload());
    }

    public Changeset getChangeset() {
        Changeset changeset = this.pnlChangesetManagement.getSelectedChangeset();
        if (changeset == null) {
            changeset = new Changeset();
        }
        changeset.setKeys(this.pnlTagSettings.getTags(false));
        return changeset;
    }

    public void setSelectedChangesetForNextUpload(Changeset changeset) {
        this.pnlChangesetManagement.setSelectedChangesetForNextUpload(changeset);
    }

    @Override
    public UploadStrategySpecification getUploadStrategySpecification() {
        UploadStrategySpecification uploadStrategySpecification = this.pnlUploadStrategySelectionPanel.getUploadStrategySpecification();
        uploadStrategySpecification.setCloseChangesetAfterUpload(this.pnlChangesetManagement.isCloseChangesetAfterUpload());
        return uploadStrategySpecification;
    }

    @Override
    public String getUploadComment() {
        return this.changesetCommentModel.getComment();
    }

    @Override
    public String getUploadSource() {
        return this.changesetSourceModel.getComment();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(400, 600))).applySafe(this);
            this.startUserInput();
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    public static boolean addCustomComponent(Component component) {
        if (component != null) {
            return customComponents.add(component);
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(ChangesetManagementPanel.SELECTED_CHANGESET_PROP)) {
            Changeset changeset = (Changeset)propertyChangeEvent.getNewValue();
            this.setChangesetTags(this.dataSet);
            if (changeset == null) {
                this.tpConfigPanels.setTitleAt(1, I18n.tr("Tags of new changeset", new Object[0]));
            } else {
                this.tpConfigPanels.setTitleAt(1, I18n.tr("Tags of changeset {0}", changeset.getId()));
            }
        }
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey() == null || !"osm-server.url".equals(preferenceChangeEvent.getKey())) {
            return;
        }
        Setting<?> setting = preferenceChangeEvent.getNewValue();
        String string = setting == null || setting.getValue() == null ? OsmApi.getOsmApi().getBaseUrl() : setting.getValue().toString();
        this.setTitle(I18n.tr("Upload to ''{0}''", string));
    }

    private static String getLastChangesetTagFromHistory(String string, List<String> list) {
        Collection<String> collection = Main.pref.getCollection(string, list);
        int n = (int)(System.currentTimeMillis() / 1000L - (long)Main.pref.getInteger("upload.comment.last-used", 0));
        if (n < Main.pref.getInteger("upload.comment.max-age", 14400000) && collection != null && !collection.isEmpty()) {
            return collection.iterator().next();
        }
        return null;
    }

    public String getLastChangesetCommentFromHistory() {
        return UploadDialog.getLastChangesetTagFromHistory("upload.comment.history", new ArrayList<String>());
    }

    public String getLastChangesetSourceFromHistory() {
        return UploadDialog.getLastChangesetTagFromHistory("upload.source.history", BasicUploadSettingsPanel.getDefaultSources());
    }

    @Override
    public Map<String, String> getTags(boolean bl) {
        return this.pnlTagSettings.getTags(bl);
    }

    @Override
    public void handleMissingComment() {
        this.tpConfigPanels.setSelectedIndex(0);
        this.pnlBasicUploadSettings.initEditingOfUploadComment();
    }

    @Override
    public void handleMissingSource() {
        this.tpConfigPanels.setSelectedIndex(0);
        this.pnlBasicUploadSettings.initEditingOfUploadSource();
    }

    @Override
    public void handleIllegalChunkSize() {
        this.tpConfigPanels.setSelectedIndex(0);
    }

    static {
        customComponents = new ArrayList<Component>();
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            UploadDialog.this.setCanceled(true);
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            if (UploadDialog.this.tpConfigPanels.getSelectedIndex() == 0) {
                UploadDialog.this.pnlBasicUploadSettings.initEditingOfUploadComment();
            }
        }
    }

    static class CancelAction
    extends AbstractAction {
        private final transient IUploadDialog dialog;

        CancelAction(IUploadDialog iUploadDialog) {
            this.dialog = iUploadDialog;
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Cancel the upload and resume editing", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.dialog instanceof AbstractUploadDialog) {
                ((AbstractUploadDialog)this.dialog).setCanceled(true);
                ((AbstractUploadDialog)this.dialog).setVisible(false);
            }
        }
    }

    static class UploadAction
    extends AbstractAction {
        private final transient IUploadDialog dialog;

        UploadAction(IUploadDialog iUploadDialog) {
            this.dialog = iUploadDialog;
            this.putValue("Name", I18n.tr("Upload Changes", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("upload"));
            this.putValue("ShortDescription", I18n.tr("Upload the changed primitives", new Object[0]));
        }

        protected boolean warnUploadComment() {
            return this.warnUploadTag(I18n.tr("Please revise upload comment", new Object[0]), I18n.tr("Your upload comment is <i>empty</i>, or <i>very short</i>.<br /><br />This is technically allowed, but please consider that many users who are<br />watching changes in their area depend on meaningful changeset comments<br />to understand what is going on!<br /><br />If you spend a minute now to explain your change, you will make life<br />easier for many other mappers.", new Object[0]), "upload_comment_is_empty_or_very_short");
        }

        protected boolean warnUploadSource() {
            return this.warnUploadTag(I18n.tr("Please specify a changeset source", new Object[0]), I18n.tr("You did not specify a source for your changes.<br />It is technically allowed, but this information helps<br />other users to understand the origins of the data.<br /><br />If you spend a minute now to explain your change, you will make life<br />easier for many other mappers.", new Object[0]), "upload_source_is_empty");
        }

        protected boolean warnUploadTag(String string, String string2, String string3) {
            String[] stringArray = new String[]{I18n.tr("Revise", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Continue as is", new Object[0])};
            Icon[] iconArray = new Icon[]{new ImageProvider("ok").setMaxSize(ImageProvider.ImageSizes.LARGEICON).get(), new ImageProvider("cancel").setMaxSize(ImageProvider.ImageSizes.LARGEICON).get(), new ImageProvider("upload").setMaxSize(ImageProvider.ImageSizes.LARGEICON).addOverlay(new ImageOverlay(new ImageProvider("warning-small"), 0.5, 0.5, 1.0, 1.0)).get()};
            String[] stringArray2 = new String[]{I18n.tr("Return to the previous dialog to enter a more descriptive comment", new Object[0]), I18n.tr("Cancel and return to the previous dialog", new Object[0]), I18n.tr("Ignore this hint and upload anyway", new Object[0])};
            if (GraphicsEnvironment.isHeadless()) {
                return false;
            }
            ExtendedDialog extendedDialog = new ExtendedDialog((Component)((Object)this.dialog), string, stringArray);
            extendedDialog.setContent("<html>" + string2 + "</html>");
            extendedDialog.setButtonIcons(iconArray);
            extendedDialog.setToolTipTexts(stringArray2);
            extendedDialog.setIcon(2);
            extendedDialog.toggleEnable(string3);
            extendedDialog.setCancelButton(1, 2);
            return extendedDialog.showDialog().getValue() != 3;
        }

        protected void warnIllegalChunkSize() {
            HelpAwareOptionPane.showOptionDialog((Component)((Object)this.dialog), I18n.tr("Please enter a valid chunk size first", new Object[0]), I18n.tr("Illegal chunk size", new Object[0]), 0, HelpUtil.ht("/Dialog/Upload#IllegalChunkSize"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.dialog.getUploadComment().trim().length() < 10 && this.warnUploadComment()) {
                this.dialog.handleMissingComment();
                return;
            }
            if (this.dialog.getUploadSource().trim().isEmpty() && this.warnUploadSource()) {
                this.dialog.handleMissingSource();
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry<String, String> entry : this.dialog.getTags(true).entrySet()) {
                boolean bl;
                boolean bl2 = entry.getKey() == null || entry.getKey().trim().isEmpty();
                boolean bl3 = entry.getValue() == null || entry.getValue().trim().isEmpty();
                boolean bl4 = bl = "comment".equals(entry.getKey()) || "source".equals(entry.getKey());
                if (!(bl2 ^ bl3) || bl) continue;
                arrayList.add(I18n.tr("{0}={1}", entry.getKey(), entry.getValue()));
            }
            if (!arrayList.isEmpty() && 0 != JOptionPane.showConfirmDialog(Main.parent, I18n.trn("<html>The following changeset tag contains an empty key/value:<br>{0}<br>Continue?</html>", "<html>The following changeset tags contain an empty key/value:<br>{0}<br>Continue?</html>", arrayList.size(), Utils.joinAsHtmlUnorderedList(arrayList)), I18n.tr("Empty metadata", new Object[0]), 2, 2)) {
                this.dialog.handleMissingComment();
                return;
            }
            UploadStrategySpecification uploadStrategySpecification = this.dialog.getUploadStrategySpecification();
            if (uploadStrategySpecification.getStrategy().equals((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY) && uploadStrategySpecification.getChunkSize() == -1) {
                this.warnIllegalChunkSize();
                this.dialog.handleIllegalChunkSize();
                return;
            }
            if (this.dialog instanceof AbstractUploadDialog) {
                ((AbstractUploadDialog)this.dialog).setCanceled(false);
                ((AbstractUploadDialog)this.dialog).setVisible(false);
            }
        }
    }
}

