/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.source.Source;
import java.io.IOException;

public abstract class Breakpoint {
    private final boolean isOneShot;
    private int ignoreCount;
    private int hitCount;
    private State state;

    Breakpoint(State state, int ignoreCount, boolean isOneShot) {
        this.state = state;
        this.isOneShot = isOneShot;
        this.ignoreCount = ignoreCount;
    }

    public abstract void setEnabled(boolean var1);

    public abstract boolean isEnabled();

    public abstract void setCondition(String var1) throws IOException;

    public Source getCondition() {
        return null;
    }

    public final boolean isOneShot() {
        return this.isOneShot;
    }

    public final int getIgnoreCount() {
        return this.ignoreCount;
    }

    public final void setIgnoreCount(int ignoreCount) {
        this.ignoreCount = ignoreCount;
    }

    public final int getHitCount() {
        return this.hitCount;
    }

    public abstract void dispose();

    public abstract String getLocationDescription();

    public final State getState() {
        return this.state;
    }

    final void assertState(State s) {
        assert (this.state == s);
    }

    final void setState(State state) {
        this.state = state;
    }

    final boolean incrHitCountCheckIgnore() {
        return ++this.hitCount > this.ignoreCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" state=");
        sb.append(this.getState() == null ? "<none>" : this.getState().getName());
        if (this.isOneShot()) {
            sb.append(", One-Shot");
        }
        if (this.getCondition() != null) {
            sb.append(", condition=\"" + this.getCondition() + "\"");
        }
        return sb.toString();
    }

    public static enum State {
        ENABLED_UNRESOLVED("Enabled/Unresolved"),
        DISABLED_UNRESOLVED("Disabled/Unresolved"),
        ENABLED("Enabled"),
        DISABLED("Disabled"),
        DISPOSED("Disposed");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

