/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.nodes.write;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.nio.ByteOrder;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.util.ByteList;

@NodeChildren(value={@NodeChild(value="value", type=PackNode.class)})
public abstract class WriteHexStringNode
extends PackNode {
    private final ByteOrder byteOrder;
    private final int length;

    public WriteHexStringNode(RubyContext context, ByteOrder byteOrder, int length) {
        super(context);
        this.byteOrder = byteOrder;
        this.length = length;
    }

    @Specialization
    public Object write(VirtualFrame frame, ByteList bytes) {
        int currentByte = 0;
        int lengthToUse = this.length == -1 ? bytes.length() : this.length;
        for (int n = 0; n < lengthToUse; ++n) {
            int currentChar = n < bytes.length() ? (int)((byte)bytes.get(n)) : 0;
            currentByte = Character.isJavaIdentifierStart(currentChar) ? (this.byteOrder == ByteOrder.LITTLE_ENDIAN ? (currentByte |= ((currentChar & 0xF) + 9 & 0xF) << 4) : (currentByte |= (currentChar & 0xF) + 9 & 0xF)) : (this.byteOrder == ByteOrder.LITTLE_ENDIAN ? (currentByte |= (currentChar & 0xF) << 4) : (currentByte |= currentChar & 0xF));
            if ((n - 1 & 1) != 0) {
                if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    currentByte >>= 4;
                    continue;
                }
                currentByte <<= 4;
                continue;
            }
            this.writeByte(frame, (byte)currentByte);
            currentByte = 0;
        }
        if ((lengthToUse & 1) != 0) {
            this.writeByte(frame, (byte)(currentByte & 0xFF));
        }
        return null;
    }
}

