/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChild(value="object", type=RubyNode.class)
public abstract class MetaClassNode
extends RubyNode {
    public MetaClassNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract DynamicObject executeMetaClass(Object var1);

    @Specialization(guards={"value"})
    protected DynamicObject singletonClassTrue(boolean value) {
        return this.getContext().getCoreLibrary().getTrueClass();
    }

    @Specialization(guards={"!value"})
    protected DynamicObject singletonClassFalse(boolean value) {
        return this.getContext().getCoreLibrary().getFalseClass();
    }

    @Specialization
    protected DynamicObject singletonClass(int value) {
        return this.getContext().getCoreLibrary().getFixnumClass();
    }

    @Specialization
    protected DynamicObject singletonClass(long value) {
        return this.getContext().getCoreLibrary().getFixnumClass();
    }

    @Specialization
    protected DynamicObject singletonClass(double value) {
        return this.getContext().getCoreLibrary().getFloatClass();
    }

    @Specialization
    protected DynamicObject singletonClass(DynamicObject object) {
        return Layouts.BASIC_OBJECT.getMetaClass(object);
    }
}

