/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.sejda.io.SeekableSource;
import org.sejda.util.IOUtils;

class ThreadBoundCopiesSupplier<T extends SeekableSource>
implements Closeable {
    private ConcurrentMap<Long, T> copies = new ConcurrentHashMap<Long, T>();
    private final SeekableSourceSupplier<T> supplier;

    ThreadBoundCopiesSupplier(SeekableSourceSupplier<T> supplier) {
        Objects.requireNonNull(supplier);
        this.supplier = supplier;
    }

    T get() throws IOException {
        long id = Thread.currentThread().getId();
        SeekableSource copy = (SeekableSource)this.copies.get(id);
        if (Objects.isNull(copy)) {
            SeekableSource newCopy = (SeekableSource)this.supplier.supply();
            copy = this.copies.putIfAbsent(id, newCopy);
            if (Objects.isNull(copy)) {
                copy = newCopy;
            } else {
                IOUtils.closeQuietly(newCopy);
            }
        }
        return (T)copy;
    }

    @Override
    public void close() {
        this.copies.values().stream().forEach(IOUtils::closeQuietly);
    }

    static interface SeekableSourceSupplier<T> {
        public T supply() throws IOException;
    }
}

