/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.graphics.pattern;

import java.io.IOException;
import java.io.InputStream;
import org.sejda.sambox.contentstream.PDContentStream;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.common.PDStream;
import org.sejda.sambox.pdmodel.graphics.pattern.PDAbstractPattern;

public class PDTilingPattern
extends PDAbstractPattern
implements PDContentStream {
    public static final int PAINT_COLORED = 1;
    public static final int PAINT_UNCOLORED = 2;
    public static final int TILING_CONSTANT_SPACING = 1;
    public static final int TILING_NO_DISTORTION = 2;
    public static final int TILING_CONSTANT_SPACING_FASTER_TILING = 3;

    public PDTilingPattern() {
        this.getCOSObject().setInt(COSName.PATTERN_TYPE, 1);
    }

    public PDTilingPattern(COSDictionary resourceDictionary) {
        super(resourceDictionary);
    }

    @Override
    public int getPatternType() {
        return 1;
    }

    @Override
    public void setPaintType(int paintType) {
        this.getCOSObject().setInt(COSName.PAINT_TYPE, paintType);
    }

    public int getPaintType() {
        return this.getCOSObject().getInt(COSName.PAINT_TYPE, 0);
    }

    public void setTilingType(int tilingType) {
        this.getCOSObject().setInt(COSName.TILING_TYPE, tilingType);
    }

    public int getTilingType() {
        return this.getCOSObject().getInt(COSName.TILING_TYPE, 0);
    }

    public void setXStep(float xStep) {
        this.getCOSObject().setFloat(COSName.X_STEP, xStep);
    }

    public float getXStep() {
        float xStep = this.getCOSObject().getFloat(COSName.X_STEP, 0.0f);
        return xStep == 32767.0f ? 0.0f : xStep;
    }

    public void setYStep(float yStep) {
        this.getCOSObject().setFloat(COSName.Y_STEP, yStep);
    }

    public float getYStep() {
        float yStep = this.getCOSObject().getFloat(COSName.Y_STEP, 0.0f);
        return yStep == 32767.0f ? 0.0f : yStep;
    }

    public PDStream getContentStream() {
        return new PDStream((COSStream)this.getCOSObject());
    }

    @Override
    public InputStream getContents() throws IOException {
        return ((COSStream)this.getCOSObject()).getUnfilteredStream();
    }

    @Override
    public PDResources getResources() {
        PDResources retval = null;
        COSDictionary resources = (COSDictionary)this.getCOSObject().getDictionaryObject(COSName.RESOURCES);
        if (resources != null) {
            retval = new PDResources(resources);
        }
        return retval;
    }

    public void setResources(PDResources resources) {
        this.getCOSObject().setItem(COSName.RESOURCES, (COSObjectable)resources);
    }

    @Override
    public PDRectangle getBBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.getCOSObject().getDictionaryObject(COSName.BBOX);
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public void setBBox(PDRectangle bbox) {
        if (bbox == null) {
            this.getCOSObject().removeItem(COSName.BBOX);
        } else {
            this.getCOSObject().setItem(COSName.BBOX, (COSBase)bbox.getCOSArray());
        }
    }
}

