# Auto-generated by BabelAPI, do not modify.

from abc import ABCMeta, abstractmethod

from . import babel_validators as bv

from . import (
    async,
    files,
    sharing,
    team,
    users,
)

class DropboxBase(object):
    __metaclass__ = ABCMeta

    @abstractmethod
    def request(self):
        pass

    # ------------------------------------------
    # Routes in async namespace

    # ------------------------------------------
    # Routes in files namespace

    def files_get_metadata(self,
                           path,
                           include_media_info=False):
        """
        Returns the metadata for a file or folder.

        :param str path: The path of a file or folder on Dropbox
        :param bool include_media_info: If true,
            :field:'FileMetadata.media_info' is set for photo and video.
        :rtype: :class:`dropbox.files.Metadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.GetMetadataError`
        """
        o = files.GetMetadataArg(path,
                                 include_media_info)
        r = self.request(self.HOST_API,
                         'files/get_metadata',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(files.GetMetadataArg),
                         bv.StructTree(files.Metadata),
                         bv.Union(files.GetMetadataError),
                         o,
                         None)
        return r

    def files_list_folder_longpoll(self,
                                   cursor,
                                   timeout=30):
        """
        A longpoll endpoint to wait for changes on an account. In conjunction
        with :meth:`list_folder`, this call gives you a low-latency way to
        monitor an account for file changes. The connection will block until
        there are changes available or a timeout occurs. This endpoint is useful
        mostly for client-side apps. If you're looking for server-side
        notifications, check out our `webhooks documentation
        <https://www.dropbox.com/developers/reference/webhooks>`_.

        :param str cursor: A cursor as returned by :meth:`list_folder` or
            :meth:`list_folder_continue`
        :param long timeout: A timeout in seconds. The request will block for at
            most this length of time, plus up to 90 seconds of random jitter
            added to avoid the thundering herd problem. Care should be taken
            when using this parameter, as some network infrastructure does not
            support long timeouts.
        :rtype: :class:`dropbox.files.ListFolderLongpollResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.ListFolderLongpollError`
        """
        o = files.ListFolderLongpollArg(cursor,
                                        timeout)
        r = self.request(self.HOST_NOTIFY,
                         'files/list_folder/longpoll',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(files.ListFolderLongpollArg),
                         bv.Struct(files.ListFolderLongpollResult),
                         bv.Union(files.ListFolderLongpollError),
                         o,
                         None)
        return r

    def files_list_folder(self,
                          path,
                          recursive=False,
                          include_media_info=False,
                          include_deleted=False):
        """
        Returns the contents of a folder.

        :param str path: The path to the folder you want to see the contents of.
        :param bool recursive: If true, the list folder operation will be
            applied recursively to all subfolders and the response will contain
            contents of all subfolders.
        :param bool include_media_info: If true,
            :field:'FileMetadata.media_info' is set for photo and video.
        :param bool include_deleted: If true, the results will include entries
            for files and folders that used to exist but were deleted.
        :rtype: :class:`dropbox.files.ListFolderResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.ListFolderError`
        """
        o = files.ListFolderArg(path,
                                recursive,
                                include_media_info,
                                include_deleted)
        r = self.request(self.HOST_API,
                         'files/list_folder',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(files.ListFolderArg),
                         bv.Struct(files.ListFolderResult),
                         bv.Union(files.ListFolderError),
                         o,
                         None)
        return r

    def files_list_folder_continue(self,
                                   cursor):
        """
        Once a cursor has been retrieved from :meth:`list_folder`, use this to
        paginate through all files and retrieve updates to the folder.

        :param str cursor: The cursor returned by your last call to
            :meth:`list_folder` or :meth:`list_folder_continue`.
        :rtype: :class:`dropbox.files.ListFolderResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.ListFolderContinueError`
        """
        o = files.ListFolderContinueArg(cursor)
        r = self.request(self.HOST_API,
                         'files/list_folder/continue',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(files.ListFolderContinueArg),
                         bv.Struct(files.ListFolderResult),
                         bv.Union(files.ListFolderContinueError),
                         o,
                         None)
        return r

    def files_list_folder_get_latest_cursor(self,
                                            path,
                                            recursive=False,
                                            include_media_info=False,
                                            include_deleted=False):
        """
        A way to quickly get a cursor for the folder's state. Unlike
        :meth:`list_folder`, :meth:`list_folder_get_latest_cursor` doesn't
        return any entries. This endpoint is for app which only needs to know
        about new files and modifications and doesn't need to know about files
        that already exist in Dropbox.

        :param str path: The path to the folder you want to see the contents of.
        :param bool recursive: If true, the list folder operation will be
            applied recursively to all subfolders and the response will contain
            contents of all subfolders.
        :param bool include_media_info: If true,
            :field:'FileMetadata.media_info' is set for photo and video.
        :param bool include_deleted: If true, the results will include entries
            for files and folders that used to exist but were deleted.
        :rtype: :class:`dropbox.files.ListFolderGetLatestCursorResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.ListFolderError`
        """
        o = files.ListFolderArg(path,
                                recursive,
                                include_media_info,
                                include_deleted)
        r = self.request(self.HOST_API,
                         'files/list_folder/get_latest_cursor',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(files.ListFolderArg),
                         bv.Struct(files.ListFolderGetLatestCursorResult),
                         bv.Union(files.ListFolderError),
                         o,
                         None)
        return r

    def files_download(self,
                       path,
                       rev=None):
        """
        Download a file from a user's Dropbox.

        :param str path: The path of the file to download.
        :param Nullable rev: Deprecated. Please specify revision in
            :field:'path' instead
        :rtype: (:class:`dropbox.files.FileMetadata`,
                 :class:`requests.models.Response`)
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.DownloadError`

        If you do not consume the entire response body, then you must call close
        on the response object, otherwise you will max out your available
        connections. We recommend using the `contextlib.closing
        <https://docs.python.org/2/library/contextlib.html#contextlib.closing>`_
        context manager to ensure this.
        """
        o = files.DownloadArg(path,
                              rev)
        r = self.request(self.HOST_CONTENT,
                         'files/download',
                         self.ROUTE_STYLE_DOWNLOAD,
                         bv.Struct(files.DownloadArg),
                         bv.Struct(files.FileMetadata),
                         bv.Union(files.DownloadError),
                         o,
                         None)
        return r

    def files_download_to_file(self,
                               download_path,
                               path,
                               rev=None):
        """
        Download a file from a user's Dropbox.

        :param str download_path: Path on local machine to save file.
        :param str path: The path of the file to download.
        :param Nullable rev: Deprecated. Please specify revision in
            :field:'path' instead
        :rtype: (:class:`dropbox.files.FileMetadata`,
                 :class:`requests.models.Response`)
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.DownloadError`
        """
        o = files.DownloadArg(path,
                              rev)
        r = self.request(self.HOST_CONTENT,
                         'files/download',
                         self.ROUTE_STYLE_DOWNLOAD,
                         bv.Struct(files.DownloadArg),
                         bv.Struct(files.FileMetadata),
                         bv.Union(files.DownloadError),
                         o,
                         None)
        self._save_body_to_file(download_path, r[1])
        return r[0]

    def files_upload_session_start(self,
                                   f):
        """
        Upload sessions allow you to upload a single file using multiple
        requests. This call starts a new upload session with the given data.
        You can then use :meth:`upload_session_append` to add more data and
        :meth:`upload_session_finish` to save all the data to a file in Dropbox.
        A single request should not upload more than 150 MB of file contents.

        :param f: A string or file-like obj of data.
        :rtype: :class:`dropbox.files.UploadSessionStartResult`
        """
        o = None
        r = self.request(self.HOST_CONTENT,
                         'files/upload_session/start',
                         self.ROUTE_STYLE_UPLOAD,
                         bv.Void(),
                         bv.Struct(files.UploadSessionStartResult),
                         bv.Void(),
                         o,
                         f)
        return r

    def files_upload_session_append(self,
                                    f,
                                    session_id,
                                    offset):
        """
        Append more data to an upload session. A single request should not
        upload more than 150 MB of file contents.

        :param f: A string or file-like obj of data.
        :param str session_id: The upload session ID (returned by
            :meth:`upload_session_start`).
        :param long offset: The amount of data that has been uploaded so far. We
            use this to make sure upload data isn't lost or duplicated in the
            event of a network error.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.UploadSessionLookupError`
        """
        o = files.UploadSessionCursor(session_id,
                                      offset)
        r = self.request(self.HOST_CONTENT,
                         'files/upload_session/append',
                         self.ROUTE_STYLE_UPLOAD,
                         bv.Struct(files.UploadSessionCursor),
                         bv.Void(),
                         bv.Union(files.UploadSessionLookupError),
                         o,
                         f)
        return None

    def files_upload_session_finish(self,
                                    f,
                                    cursor,
                                    commit):
        """
        Finish an upload session and save the uploaded data to the given file
        path. A single request should not upload more than 150 MB of file
        contents.

        :param f: A string or file-like obj of data.
        :param cursor: Contains the upload session ID and the offset.
        :type cursor: :class:`dropbox.files.UploadSessionCursor`
        :param commit: Contains the path and other optional modifiers for the
            commit.
        :type commit: :class:`dropbox.files.CommitInfo`
        :rtype: :class:`dropbox.files.FileMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.UploadSessionFinishError`
        """
        o = files.UploadSessionFinishArg(cursor,
                                         commit)
        r = self.request(self.HOST_CONTENT,
                         'files/upload_session/finish',
                         self.ROUTE_STYLE_UPLOAD,
                         bv.Struct(files.UploadSessionFinishArg),
                         bv.Struct(files.FileMetadata),
                         bv.Union(files.UploadSessionFinishError),
                         o,
                         f)
        return r

    def files_upload(self,
                     f,
                     path,
                     mode=files.WriteMode.add,
                     autorename=False,
                     client_modified=None,
                     mute=False):
        """
        Create a new file with the contents provided in the request. Do not use
        this to upload a file larger than 150 MB. Instead, create an upload
        session with :meth:`upload_session_start`.

        :param f: A string or file-like obj of data.
        :param str path: Path in the user's Dropbox to save the file.
        :param mode: Selects what to do if the file already exists.
        :type mode: :class:`dropbox.files.WriteMode`
        :param bool autorename: If there's a conflict, as determined by
            ``mode``, have the Dropbox server try to autorename the file to
            avoid conflict.
        :param Nullable client_modified: The value to store as the
            ``client_modified`` timestamp. Dropbox automatically records the
            time at which the file was written to the Dropbox servers. It can
            also record an additional timestamp, provided by Dropbox desktop
            clients, mobile clients, and API apps of when the file was actually
            created or modified.
        :param bool mute: Normally, users are made aware of any file
            modifications in their Dropbox account via notifications in the
            client software. If ``True``, this tells the clients that this
            modification shouldn't result in a user notification.
        :rtype: :class:`dropbox.files.FileMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.UploadError`
        """
        o = files.CommitInfo(path,
                             mode,
                             autorename,
                             client_modified,
                             mute)
        r = self.request(self.HOST_CONTENT,
                         'files/upload',
                         self.ROUTE_STYLE_UPLOAD,
                         bv.Struct(files.CommitInfo),
                         bv.Struct(files.FileMetadata),
                         bv.Union(files.UploadError),
                         o,
                         f)
        return r

    def files_search(self,
                     path,
                     query,
                     start=0,
                     max_results=100,
                     mode=files.SearchMode.filename):
        """
        Searches for files and folders.

        :param str path: The path in the user's Dropbox to search. Should
            probably be a folder.
        :param str query: The string to search for. The search string is split
            on spaces into multiple tokens. For file name searching, the last
            token is used for prefix matching (i.e. "bat c" matches "bat cave"
            but not "batman car").
        :param long start: The starting index within the search results (used
            for paging).
        :param long max_results: The maximum number of search results to return.
        :param mode: The search mode (filename, filename_and_content, or
            deleted_filename). Note that searching file content is only
            available for Dropbox Business accounts.
        :type mode: :class:`dropbox.files.SearchMode`
        :rtype: :class:`dropbox.files.SearchResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.SearchError`
        """
        o = files.SearchArg(path,
                            query,
                            start,
                            max_results,
                            mode)
        r = self.request(self.HOST_API,
                         'files/search',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(files.SearchArg),
                         bv.Struct(files.SearchResult),
                         bv.Union(files.SearchError),
                         o,
                         None)
        return r

    def files_create_folder(self,
                            path):
        """
        Create a folder at a given path.

        :param str path: Path in the user's Dropbox to create.
        :rtype: :class:`dropbox.files.FolderMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.CreateFolderError`
        """
        o = files.CreateFolderArg(path)
        r = self.request(self.HOST_API,
                         'files/create_folder',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(files.CreateFolderArg),
                         bv.Struct(files.FolderMetadata),
                         bv.Union(files.CreateFolderError),
                         o,
                         None)
        return r

    def files_delete(self,
                     path):
        """
        Delete the file or folder at a given path. If the path is a folder, all
        its contents will be deleted too.

        :param str path: Path in the user's Dropbox to delete.
        :rtype: :class:`dropbox.files.Metadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.DeleteError`
        """
        o = files.DeleteArg(path)
        r = self.request(self.HOST_API,
                         'files/delete',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(files.DeleteArg),
                         bv.StructTree(files.Metadata),
                         bv.Union(files.DeleteError),
                         o,
                         None)
        return r

    def files_permanently_delete(self,
                                 path):
        """
        Permanently delete the file or folder at a given path (see
        https://www.dropbox.com/en/help/40). Note: This endpoint is only
        available for Dropbox Business apps.

        :param str path: Path in the user's Dropbox to delete.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.DeleteError`
        """
        o = files.DeleteArg(path)
        r = self.request(self.HOST_API,
                         'files/permanently_delete',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(files.DeleteArg),
                         bv.Void(),
                         bv.Union(files.DeleteError),
                         o,
                         None)
        return None

    def files_copy(self,
                   from_path,
                   to_path):
        """
        Copy a file or folder to a different location in the user's Dropbox. If
        the source path is a folder all its contents will be copied.

        :param str from_path: Path in the user's Dropbox to be copied or moved.
        :param str to_path: Path in the user's Dropbox that is the destination.
        :rtype: :class:`dropbox.files.Metadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.RelocationError`
        """
        o = files.RelocationArg(from_path,
                                to_path)
        r = self.request(self.HOST_API,
                         'files/copy',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(files.RelocationArg),
                         bv.StructTree(files.Metadata),
                         bv.Union(files.RelocationError),
                         o,
                         None)
        return r

    def files_move(self,
                   from_path,
                   to_path):
        """
        Move a file or folder to a different location in the user's Dropbox. If
        the source path is a folder all its contents will be moved.

        :param str from_path: Path in the user's Dropbox to be copied or moved.
        :param str to_path: Path in the user's Dropbox that is the destination.
        :rtype: :class:`dropbox.files.Metadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.RelocationError`
        """
        o = files.RelocationArg(from_path,
                                to_path)
        r = self.request(self.HOST_API,
                         'files/move',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(files.RelocationArg),
                         bv.StructTree(files.Metadata),
                         bv.Union(files.RelocationError),
                         o,
                         None)
        return r

    def files_get_thumbnail(self,
                            path,
                            format=files.ThumbnailFormat.jpeg,
                            size=files.ThumbnailSize.w64h64):
        """
        Get a thumbnail for an image. This method currently supports files with
        the following file extensions: jpg, jpeg, png, tiff, tif, gif and bmp.
        Photos that are larger than 20MB in size won't be converted to a
        thumbnail.

        :param str path: The path to the image file you want to thumbnail.
        :param format: The format for the thumbnail image, jpeg (default) or
            png. For  images that are photos, jpeg should be preferred, while
            png is  better for screenshots and digital arts.
        :type format: :class:`dropbox.files.ThumbnailFormat`
        :param size: The size for the thumbnail image.
        :type size: :class:`dropbox.files.ThumbnailSize`
        :rtype: (:class:`dropbox.files.FileMetadata`,
                 :class:`requests.models.Response`)
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.ThumbnailError`

        If you do not consume the entire response body, then you must call close
        on the response object, otherwise you will max out your available
        connections. We recommend using the `contextlib.closing
        <https://docs.python.org/2/library/contextlib.html#contextlib.closing>`_
        context manager to ensure this.
        """
        o = files.ThumbnailArg(path,
                               format,
                               size)
        r = self.request(self.HOST_CONTENT,
                         'files/get_thumbnail',
                         self.ROUTE_STYLE_DOWNLOAD,
                         bv.Struct(files.ThumbnailArg),
                         bv.Struct(files.FileMetadata),
                         bv.Union(files.ThumbnailError),
                         o,
                         None)
        return r

    def files_get_thumbnail_to_file(self,
                                    download_path,
                                    path,
                                    format=files.ThumbnailFormat.jpeg,
                                    size=files.ThumbnailSize.w64h64):
        """
        Get a thumbnail for an image. This method currently supports files with
        the following file extensions: jpg, jpeg, png, tiff, tif, gif and bmp.
        Photos that are larger than 20MB in size won't be converted to a
        thumbnail.

        :param str download_path: Path on local machine to save file.
        :param str path: The path to the image file you want to thumbnail.
        :param format: The format for the thumbnail image, jpeg (default) or
            png. For  images that are photos, jpeg should be preferred, while
            png is  better for screenshots and digital arts.
        :type format: :class:`dropbox.files.ThumbnailFormat`
        :param size: The size for the thumbnail image.
        :type size: :class:`dropbox.files.ThumbnailSize`
        :rtype: (:class:`dropbox.files.FileMetadata`,
                 :class:`requests.models.Response`)
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.ThumbnailError`
        """
        o = files.ThumbnailArg(path,
                               format,
                               size)
        r = self.request(self.HOST_CONTENT,
                         'files/get_thumbnail',
                         self.ROUTE_STYLE_DOWNLOAD,
                         bv.Struct(files.ThumbnailArg),
                         bv.Struct(files.FileMetadata),
                         bv.Union(files.ThumbnailError),
                         o,
                         None)
        self._save_body_to_file(download_path, r[1])
        return r[0]

    def files_get_preview(self,
                          path,
                          rev=None):
        """
        Get a preview for a file. Currently previews are only generated for the
        files with  the following extensions: .doc, .docx, .docm, .ppt, .pps,
        .ppsx, .ppsm, .pptx, .pptm,  .xls, .xlsx, .xlsm, .rtf

        :param str path: The path of the file to preview.
        :param Nullable rev: Deprecated. Please specify revision in
            :field:'path' instead
        :rtype: (:class:`dropbox.files.FileMetadata`,
                 :class:`requests.models.Response`)
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.PreviewError`

        If you do not consume the entire response body, then you must call close
        on the response object, otherwise you will max out your available
        connections. We recommend using the `contextlib.closing
        <https://docs.python.org/2/library/contextlib.html#contextlib.closing>`_
        context manager to ensure this.
        """
        o = files.PreviewArg(path,
                             rev)
        r = self.request(self.HOST_CONTENT,
                         'files/get_preview',
                         self.ROUTE_STYLE_DOWNLOAD,
                         bv.Struct(files.PreviewArg),
                         bv.Struct(files.FileMetadata),
                         bv.Union(files.PreviewError),
                         o,
                         None)
        return r

    def files_get_preview_to_file(self,
                                  download_path,
                                  path,
                                  rev=None):
        """
        Get a preview for a file. Currently previews are only generated for the
        files with  the following extensions: .doc, .docx, .docm, .ppt, .pps,
        .ppsx, .ppsm, .pptx, .pptm,  .xls, .xlsx, .xlsm, .rtf

        :param str download_path: Path on local machine to save file.
        :param str path: The path of the file to preview.
        :param Nullable rev: Deprecated. Please specify revision in
            :field:'path' instead
        :rtype: (:class:`dropbox.files.FileMetadata`,
                 :class:`requests.models.Response`)
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.PreviewError`
        """
        o = files.PreviewArg(path,
                             rev)
        r = self.request(self.HOST_CONTENT,
                         'files/get_preview',
                         self.ROUTE_STYLE_DOWNLOAD,
                         bv.Struct(files.PreviewArg),
                         bv.Struct(files.FileMetadata),
                         bv.Union(files.PreviewError),
                         o,
                         None)
        self._save_body_to_file(download_path, r[1])
        return r[0]

    def files_list_revisions(self,
                             path,
                             limit=10):
        """
        Return revisions of a file

        :param str path: The path to the file you want to see the revisions of.
        :param long limit: The maximum number of revision entries returned.
        :rtype: :class:`dropbox.files.ListRevisionsResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.ListRevisionsError`
        """
        o = files.ListRevisionsArg(path,
                                   limit)
        r = self.request(self.HOST_API,
                         'files/list_revisions',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(files.ListRevisionsArg),
                         bv.Struct(files.ListRevisionsResult),
                         bv.Union(files.ListRevisionsError),
                         o,
                         None)
        return r

    def files_restore(self,
                      path,
                      rev):
        """
        Restore a file to a specific revision

        :param str path: The path to the file you want to restore.
        :param str rev: The revision to restore for the file.
        :rtype: :class:`dropbox.files.FileMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.files.RestoreError`
        """
        o = files.RestoreArg(path,
                             rev)
        r = self.request(self.HOST_API,
                         'files/restore',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(files.RestoreArg),
                         bv.Struct(files.FileMetadata),
                         bv.Union(files.RestoreError),
                         o,
                         None)
        return r

    # ------------------------------------------
    # Routes in sharing namespace

    def sharing_get_shared_links(self,
                                 path=None):
        """
        Returns a list of :class:`LinkMetadata` objects for this user, including
        collection links. If no path is given or the path is empty, returns a
        list of all shared links for the current user, including collection
        links. If a non-empty path is given, returns a list of all shared links
        that allow access to the given path.  Collection links are never
        returned in this case. Note that the url field in the response is never
        the shortened URL.

        :param Nullable path: See :meth:`get_shared_links` description.
        :rtype: :class:`dropbox.sharing.GetSharedLinksResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.GetSharedLinksError`
        """
        o = sharing.GetSharedLinksArg(path)
        r = self.request(self.HOST_API,
                         'sharing/get_shared_links',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.GetSharedLinksArg),
                         bv.Struct(sharing.GetSharedLinksResult),
                         bv.Union(sharing.GetSharedLinksError),
                         o,
                         None)
        return r

    def sharing_create_shared_link(self,
                                   path,
                                   short_url=False,
                                   pending_upload=None):
        """
        Create a shared link. If a shared link already exists for the given
        path, that link is returned. Note that in the returned
        :class:`PathLinkMetadata`, the ``PathLinkMetadata.url`` field is the
        shortened URL if ``CreateSharedLinkArg.short_url`` argument is set to
        ``True``. Previously, it was technically possible to break a shared link
        by moving or renaming the corresponding file or folder. In the future,
        this will no longer be the case, so your app shouldn't rely on this
        behavior. Instead, if your app needs to revoke a shared link, use
        :meth:`revoke_shared_link`.

        :param str path: The path to share.
        :param bool short_url: Whether to return a shortened URL.
        :param Nullable pending_upload: If it's okay to share a path that does
            not yet exist, set this to either ``PendingUploadMode.file`` or
            ``PendingUploadMode.folder`` to indicate whether to assume it's a
            file or folder.
        :rtype: :class:`dropbox.sharing.PathLinkMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.CreateSharedLinkError`
        """
        o = sharing.CreateSharedLinkArg(path,
                                        short_url,
                                        pending_upload)
        r = self.request(self.HOST_API,
                         'sharing/create_shared_link',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.CreateSharedLinkArg),
                         bv.Struct(sharing.PathLinkMetadata),
                         bv.Union(sharing.CreateSharedLinkError),
                         o,
                         None)
        return r

    def sharing_revoke_shared_link(self,
                                   url):
        """
        Revoke a shared link. This API is only supported for full dropbox apps.

        :param str url: URL of the shared link.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.RevokeSharedLinkError`
        """
        o = sharing.RevokeSharedLinkArg(url)
        r = self.request(self.HOST_API,
                         'sharing/revoke_shared_link',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.RevokeSharedLinkArg),
                         bv.Void(),
                         bv.Union(sharing.RevokeSharedLinkError),
                         o,
                         None)
        return None

    def sharing_list_folders(self):
        """
        Return the list of all shared folders the current user has access to.
        Warning: This endpoint is in beta and is subject to minor but possibly
        backwards-incompatible changes.

        :rtype: :class:`dropbox.sharing.ListFoldersResult`
        """
        o = None
        r = self.request(self.HOST_API,
                         'sharing/list_folders',
                         self.ROUTE_STYLE_RPC,
                         bv.Void(),
                         bv.Struct(sharing.ListFoldersResult),
                         bv.Void(),
                         o,
                         None)
        return r

    def sharing_list_folders_continue(self,
                                      cursor):
        """
        Once a cursor has been retrieved from :meth:`list_folders`, use this to
        paginate through all shared folders. Warning: This endpoint is in beta
        and is subject to minor but possibly backwards-incompatible changes.

        :param str cursor: The cursor returned by your last call to
            :meth:`list_folders` or :meth:`list_folders_continue`.
        :rtype: :class:`dropbox.sharing.ListFoldersResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.ListFoldersContinueError`
        """
        o = sharing.ListFoldersContinueArg(cursor)
        r = self.request(self.HOST_API,
                         'sharing/list_folders/continue',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.ListFoldersContinueArg),
                         bv.Struct(sharing.ListFoldersResult),
                         bv.Union(sharing.ListFoldersContinueError),
                         o,
                         None)
        return r

    def sharing_get_folder_metadata(self,
                                    shared_folder_id):
        """
        Returns shared folder metadata by its folder ID. Warning: This endpoint
        is in beta and is subject to minor but possibly backwards-incompatible
        changes.

        :param str shared_folder_id: The ID for the shared folder.
        :rtype: :class:`dropbox.sharing.SharedFolderMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.SharedFolderAccessError`
        """
        o = sharing.GetMetadataArgs(shared_folder_id)
        r = self.request(self.HOST_API,
                         'sharing/get_folder_metadata',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.GetMetadataArgs),
                         bv.Struct(sharing.SharedFolderMetadata),
                         bv.Union(sharing.SharedFolderAccessError),
                         o,
                         None)
        return r

    def sharing_list_folder_members(self,
                                    shared_folder_id):
        """
        Returns shared folder membership by its folder ID. Warning: This
        endpoint is in beta and is subject to minor but possibly
        backwards-incompatible changes.

        :param str shared_folder_id: The ID for the shared folder.
        :rtype: :class:`dropbox.sharing.SharedFolderMembers`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.SharedFolderAccessError`
        """
        o = sharing.ListFolderMembersArgs(shared_folder_id)
        r = self.request(self.HOST_API,
                         'sharing/list_folder_members',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.ListFolderMembersArgs),
                         bv.Struct(sharing.SharedFolderMembers),
                         bv.Union(sharing.SharedFolderAccessError),
                         o,
                         None)
        return r

    def sharing_list_folder_members_continue(self,
                                             cursor):
        """
        Once a cursor has been retrieved from :meth:`list_folder_members`, use
        this to paginate through all shared folder members. Warning: This
        endpoint is in beta and is subject to minor but possibly
        backwards-incompatible changes.

        :param str cursor: The cursor returned by your last call to
            :meth:`list_folder_members` or :meth:`list_folder_members_continue`.
        :rtype: :class:`dropbox.sharing.SharedFolderMembers`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.ListFolderMembersContinueError`
        """
        o = sharing.ListFolderMembersContinueArg(cursor)
        r = self.request(self.HOST_API,
                         'sharing/list_folder_members/continue',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.ListFolderMembersContinueArg),
                         bv.Struct(sharing.SharedFolderMembers),
                         bv.Union(sharing.ListFolderMembersContinueError),
                         o,
                         None)
        return r

    def sharing_share_folder(self,
                             path,
                             member_policy=sharing.MemberPolicy.anyone,
                             acl_update_policy=sharing.AclUpdatePolicy.owner,
                             shared_link_policy=sharing.SharedLinkPolicy.anyone,
                             force_async=False):
        """
        Share a folder with collaborators. Most sharing will be completed
        synchronously. Large folders will be completed asynchronously. To make
        testing the async case repeatable, set `ShareFolderArg.force_async`. If
        a ``ShareFolderLaunch.async_job_id`` is returned, you'll need to call
        :meth:`check_share_job_status` until the action completes to get the
        metadata for the folder. Warning: This endpoint is in beta and is
        subject to minor but possibly backwards-incompatible changes.

        :param str path: The path to the folder to share. If it does not exist,
            then a new one is created.
        :param member_policy: Who can be a member of this shared folder.
        :type member_policy: :class:`dropbox.sharing.MemberPolicy`
        :param acl_update_policy: Who can add and remove members of this shared
            folder.
        :type acl_update_policy: :class:`dropbox.sharing.AclUpdatePolicy`
        :param shared_link_policy: The policy to apply to shared links created
            for content inside this shared folder.
        :type shared_link_policy: :class:`dropbox.sharing.SharedLinkPolicy`
        :param bool force_async: Whether to force the share to happen
            asynchronously.
        :rtype: :class:`dropbox.sharing.ShareFolderLaunch`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.ShareFolderError`
        """
        o = sharing.ShareFolderArg(path,
                                   member_policy,
                                   acl_update_policy,
                                   shared_link_policy,
                                   force_async)
        r = self.request(self.HOST_API,
                         'sharing/share_folder',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.ShareFolderArg),
                         bv.Union(sharing.ShareFolderLaunch),
                         bv.Union(sharing.ShareFolderError),
                         o,
                         None)
        return r

    def sharing_check_share_job_status(self,
                                       async_job_id):
        """
        Returns the status of an asynchronous job for sharing a folder. Warning:
        This endpoint is in beta and is subject to minor but possibly
        backwards-incompatible changes.

        :param str async_job_id: Id of the asynchronous job. This is the value
            of a response returned from the method that launched the job.
        :rtype: :class:`dropbox.sharing.ShareFolderJobStatus`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.PollError`
        """
        o = async.PollArg(async_job_id)
        r = self.request(self.HOST_API,
                         'sharing/check_share_job_status',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(async.PollArg),
                         bv.Union(sharing.ShareFolderJobStatus),
                         bv.Union(async.PollError),
                         o,
                         None)
        return r

    def sharing_check_job_status(self,
                                 async_job_id):
        """
        Returns the status of an asynchronous job. Warning: This endpoint is in
        beta and is subject to minor but possibly backwards-incompatible
        changes.

        :param str async_job_id: Id of the asynchronous job. This is the value
            of a response returned from the method that launched the job.
        :rtype: :class:`dropbox.sharing.JobStatus`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.PollError`
        """
        o = async.PollArg(async_job_id)
        r = self.request(self.HOST_API,
                         'sharing/check_job_status',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(async.PollArg),
                         bv.Union(sharing.JobStatus),
                         bv.Union(async.PollError),
                         o,
                         None)
        return r

    def sharing_unshare_folder(self,
                               shared_folder_id,
                               leave_a_copy):
        """
        Allows a shared folder owner to unshare the folder. You'll need to call
        :meth:`check_job_status` to determine if the action has completed
        successfully. Warning: This endpoint is in beta and is subject to minor
        but possibly backwards-incompatible changes.

        :param str shared_folder_id: The ID for the shared folder.
        :param bool leave_a_copy: If true, members of this shared folder will
            get a copy of this folder after it's unshared. Otherwise, it will be
            removed from their Dropbox. The current user, who is an owner, will
            always retain their copy.
        :rtype: :class:`dropbox.sharing.LaunchEmptyResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.UnshareFolderError`
        """
        o = sharing.UnshareFolderArg(shared_folder_id,
                                     leave_a_copy)
        r = self.request(self.HOST_API,
                         'sharing/unshare_folder',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.UnshareFolderArg),
                         bv.Union(async.LaunchEmptyResult),
                         bv.Union(sharing.UnshareFolderError),
                         o,
                         None)
        return r

    def sharing_transfer_folder(self,
                                shared_folder_id,
                                to_dropbox_id):
        """
        Transfer ownership of a shared folder to a member of the shared folder.
        Warning: This endpoint is in beta and is subject to minor but possibly
        backwards-incompatible changes.

        :param str shared_folder_id: The ID for the shared folder.
        :param str to_dropbox_id: A account or team member ID to transfer
            ownership to.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.TransferFolderError`
        """
        o = sharing.TransferFolderArg(shared_folder_id,
                                      to_dropbox_id)
        r = self.request(self.HOST_API,
                         'sharing/transfer_folder',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.TransferFolderArg),
                         bv.Void(),
                         bv.Union(sharing.TransferFolderError),
                         o,
                         None)
        return None

    def sharing_update_folder_policy(self,
                                     shared_folder_id,
                                     member_policy=None,
                                     acl_update_policy=None,
                                     shared_link_policy=None):
        """
        Update the sharing policies for a shared folder. Warning: This endpoint
        is in beta and is subject to minor but possibly backwards-incompatible
        changes.

        :param str shared_folder_id: The ID for the shared folder.
        :param Nullable member_policy: Who can be a member of this shared
            folder. Only set this if the current user is on a team.
        :param Nullable acl_update_policy: Who can add and remove members of
            this shared folder.
        :param Nullable shared_link_policy: The policy to apply to shared links
            created for content inside this shared folder.
        :rtype: :class:`dropbox.sharing.SharedFolderMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.UpdateFolderPolicyError`
        """
        o = sharing.UpdateFolderPolicyArg(shared_folder_id,
                                          member_policy,
                                          acl_update_policy,
                                          shared_link_policy)
        r = self.request(self.HOST_API,
                         'sharing/update_folder_policy',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.UpdateFolderPolicyArg),
                         bv.Struct(sharing.SharedFolderMetadata),
                         bv.Union(sharing.UpdateFolderPolicyError),
                         o,
                         None)
        return r

    def sharing_add_folder_member(self,
                                  shared_folder_id,
                                  members,
                                  quiet=False,
                                  custom_message=None):
        """
        Allows an owner or editor (if the ACL update policy allows) of a shared
        folder to add another member. For the new member to get access to all
        the functionality for this folder, you will need to call
        :meth:`mount_folder` on their behalf. Warning: This endpoint is in beta
        and is subject to minor but possibly backwards-incompatible changes.

        :param str shared_folder_id: The ID for the shared folder.
        :param list members: The intended list of members to add.  Added members
            will receive invites to join the shared folder.
        :param bool quiet: Whether added members should be notified via email
            and device notifications of their invite.
        :param Nullable custom_message: Optional message to display to added
            members in their invitation.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.AddFolderMemberError`
        """
        o = sharing.AddFolderMemberArg(shared_folder_id,
                                       members,
                                       quiet,
                                       custom_message)
        r = self.request(self.HOST_API,
                         'sharing/add_folder_member',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.AddFolderMemberArg),
                         bv.Void(),
                         bv.Union(sharing.AddFolderMemberError),
                         o,
                         None)
        return None

    def sharing_remove_folder_member(self,
                                     shared_folder_id,
                                     member,
                                     leave_a_copy):
        """
        Allows an owner or editor (if the ACL update policy allows) of a shared
        folder to remove another member. Warning: This endpoint is in beta and
        is subject to minor but possibly backwards-incompatible changes.

        :param str shared_folder_id: The ID for the shared folder.
        :param member: The member to remove from the folder.
        :type member: :class:`dropbox.sharing.MemberSelector`
        :param bool leave_a_copy: If true, the removed user will keep their copy
            of the folder after it's unshared, assuming it was mounted.
            Otherwise, it will be removed from their Dropbox. Also, this must be
            set to false when kicking a group.
        :rtype: :class:`dropbox.sharing.LaunchEmptyResult`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.RemoveFolderMemberError`
        """
        o = sharing.RemoveFolderMemberArg(shared_folder_id,
                                          member,
                                          leave_a_copy)
        r = self.request(self.HOST_API,
                         'sharing/remove_folder_member',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.RemoveFolderMemberArg),
                         bv.Union(async.LaunchEmptyResult),
                         bv.Union(sharing.RemoveFolderMemberError),
                         o,
                         None)
        return r

    def sharing_update_folder_member(self,
                                     shared_folder_id,
                                     member,
                                     access_level):
        """
        Allows an owner or editor of a shared folder to update another member's
        permissions. Warning: This endpoint is in beta and is subject to minor
        but possibly backwards-incompatible changes.

        :param str shared_folder_id: The ID for the shared folder.
        :param member: The member of the shared folder to update.  Only the
            ``MemberSelector.dropbox_id`` may be set at this time.
        :type member: :class:`dropbox.sharing.MemberSelector`
        :param access_level: The new access level for ``member``.
            ``AccessLevel.owner`` is disallowed.
        :type access_level: :class:`dropbox.sharing.AccessLevel`
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.UpdateFolderMemberError`
        """
        o = sharing.UpdateFolderMemberArg(shared_folder_id,
                                          member,
                                          access_level)
        r = self.request(self.HOST_API,
                         'sharing/update_folder_member',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.UpdateFolderMemberArg),
                         bv.Void(),
                         bv.Union(sharing.UpdateFolderMemberError),
                         o,
                         None)
        return None

    def sharing_mount_folder(self,
                             shared_folder_id):
        """
        The current user mounts the designated folder. Mount a shared folder for
        a user after they have been added as a member. Once mounted, the shared
        folder will appear in their Dropbox. Warning: This endpoint is in beta
        and is subject to minor but possibly backwards-incompatible changes.

        :param str shared_folder_id: The ID of the shared folder to mount.
        :rtype: :class:`dropbox.sharing.SharedFolderMetadata`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.MountFolderError`
        """
        o = sharing.MountFolderArg(shared_folder_id)
        r = self.request(self.HOST_API,
                         'sharing/mount_folder',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.MountFolderArg),
                         bv.Struct(sharing.SharedFolderMetadata),
                         bv.Union(sharing.MountFolderError),
                         o,
                         None)
        return r

    def sharing_unmount_folder(self,
                               shared_folder_id):
        """
        The current user unmounts the designated folder. They can re-mount the
        folder at a later time using :meth:`mount_folder`. Warning: This
        endpoint is in beta and is subject to minor but possibly
        backwards-incompatible changes.

        :param str shared_folder_id: The ID for the shared folder.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.UnmountFolderError`
        """
        o = sharing.UnmountFolderArg(shared_folder_id)
        r = self.request(self.HOST_API,
                         'sharing/unmount_folder',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.UnmountFolderArg),
                         bv.Void(),
                         bv.Union(sharing.UnmountFolderError),
                         o,
                         None)
        return None

    def sharing_relinquish_folder_membership(self,
                                             shared_folder_id):
        """
        The current user relinquishes their membership in the designated shared
        folder and will no longer have access to the folder.  A folder owner
        cannot relinquish membership in their own folder. Warning: This endpoint
        is in beta and is subject to minor but possibly backwards-incompatible
        changes.

        :param str shared_folder_id: The ID for the shared folder.
        :rtype: None
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.sharing.RelinquishFolderMembershipError`
        """
        o = sharing.RelinquishFolderMembershipArg(shared_folder_id)
        r = self.request(self.HOST_API,
                         'sharing/relinquish_folder_membership',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(sharing.RelinquishFolderMembershipArg),
                         bv.Void(),
                         bv.Union(sharing.RelinquishFolderMembershipError),
                         o,
                         None)
        return None

    # ------------------------------------------
    # Routes in team namespace

    # ------------------------------------------
    # Routes in users namespace

    def users_get_account(self,
                          account_id):
        """
        Get information about a user's account.

        :param str account_id: A user's account identifier.
        :rtype: :class:`dropbox.users.BasicAccount`
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.users.GetAccountError`
        """
        o = users.GetAccountArg(account_id)
        r = self.request(self.HOST_API,
                         'users/get_account',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(users.GetAccountArg),
                         bv.Struct(users.BasicAccount),
                         bv.Union(users.GetAccountError),
                         o,
                         None)
        return r

    def users_get_current_account(self):
        """
        Get information about the current user's account.

        :rtype: :class:`dropbox.users.FullAccount`
        """
        o = None
        r = self.request(self.HOST_API,
                         'users/get_current_account',
                         self.ROUTE_STYLE_RPC,
                         bv.Void(),
                         bv.Struct(users.FullAccount),
                         bv.Void(),
                         o,
                         None)
        return r

    def users_get_space_usage(self):
        """
        Get the space usage information for the current user's account.

        :rtype: :class:`dropbox.users.SpaceUsage`
        """
        o = None
        r = self.request(self.HOST_API,
                         'users/get_space_usage',
                         self.ROUTE_STYLE_RPC,
                         bv.Void(),
                         bv.Struct(users.SpaceUsage),
                         bv.Void(),
                         o,
                         None)
        return r

    def users_get_account_batch(self,
                                account_ids):
        """
        Get information about multiple user accounts.  At most 300 accounts may
        be queried per request.

        :param list account_ids: List of user account identifiers.  Should not
            contain any duplicate account IDs.
        :rtype: list
        :raises: :class:`dropbox.exceptions.ApiError`

        If this raises, ApiError.reason is of type:
            :class:`dropbox.users.GetAccountBatchError`
        """
        o = users.GetAccountBatchArg(account_ids)
        r = self.request(self.HOST_API,
                         'users/get_account_batch',
                         self.ROUTE_STYLE_RPC,
                         bv.Struct(users.GetAccountBatchArg),
                         bv.List(bv.Struct(users.BasicAccount)),
                         bv.Union(users.GetAccountBatchError),
                         o,
                         None)
        return r

