# Makefile used to run ADMS on a Verilog-A source to emit C++ code.

# PREFIX can be passed as parameter to make:
# $make -f va2lib.make PREFIX='/qucs/prefix/'

######################
## Makefile Parameters
######################

# Module/file name
MODEL=

# Please define Qucs prefix, used to define include path
PREFIX=

# Location of installed Qucs XML files
INC=$(PREFIX)/include/qucs-core

# Locate admsXml, typicaly on the same prefix as Qucs
ADMSXML=$(PREFIX)/bin/admsXml

# file suffix
VA=.va

# handle deletion if Windows cmd.exe or MinGW MSYS terminal
ifeq ($(OS),Windows_NT)
  RM=del
  ifeq ($(MSYSTEM),MINGW32)
	RM=rm -f
  endif
endif

# Generated sources
GEN_SRC=$(MODEL).core.cpp $(MODEL).core.h \
        $(MODEL).analogfunction.h $(MODEL).analogfunction.cpp \
        $(MODEL).defs.h \

# Required Qucs XML files
XML_FILES=$(INC)/qucsVersion.xml    \
          $(INC)/qucsMODULEcore.xml \
          $(INC)/qucsMODULEdefs.xml \
          $(INC)/analogfunction.xml

# Files generated by admsXml
ADMS_GEN=.adms.implicit.xml .interface.xml .$(MODEL).va.adms

# Default
.PHONY: va2cpp

# Main target
# clean before building
va2cpp: clean $(GEN_SRC)

# Run admsXml, create C++ out of Verilog-A
# Last argument '-A dyload' enable code generation for the dynamic loader
# The '-A' is not really defined. admsXml will take almost any `-[CHAR] command`
# Include the search path to use constants.vams disciplines.vams distributed by qucs
# wich are known to work.
$(GEN_SRC): $(MODEL)$(VA)
	@echo '# va2cpp - Creating C++ sources.'
	$(ADMSXML) $(MODEL)$(VA) \
                           -I "$(INC)"                    \
                           -e "$(INC)/qucsVersion.xml"    \
                           -e "$(INC)/qucsMODULEcore.xml" \
                           -e "$(INC)/qucsMODULEdefs.xml" \
                           -e "$(INC)/analogfunction.xml" \
                           -A dyload
clean:
	@echo '# va2cpp - Removing autogenerated files.'
	- $(RM) $(GEN_SRC) $(ADMS_GEN)
	@echo ''
