/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.authorization;

import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.authorization.BasicAuthorizationDetectionMethod;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.utils.ApiUtils;

public class AuthorizationAPI
extends ApiImplementor {
    private static final Logger log = Logger.getLogger(AuthorizationAPI.class);
    private static final String PREFIX = "authorization";
    private static final String VIEW_GET_AUTHORIZATION_METHOD = "getAuthorizationDetectionMethod";
    private static final String ACTION_SET_AUTHORIZATION_METHOD = "setBasicAuthorizationDetectionMethod";
    public static final String PARAM_CONTEXT_ID = "contextId";
    public static final String PARAM_HEADER_REGEX = "headerRegex";
    public static final String PARAM_BODY_REGEX = "bodyRegex";
    public static final String PARAM_STATUS_CODE = "statusCode";
    public static final String PARAM_LOGICAL_OPERATOR = "logicalOperator";
    public static final String RESPONSE_TYPE = "methodType";
    public static final String RESPONSE_TAG = "authorizationDetectionMethod";

    public AuthorizationAPI() {
        this.addApiView(new ApiView(VIEW_GET_AUTHORIZATION_METHOD, new String[]{PARAM_CONTEXT_ID}));
        this.addApiAction(new ApiAction(ACTION_SET_AUTHORIZATION_METHOD, new String[]{PARAM_CONTEXT_ID}, new String[]{PARAM_HEADER_REGEX, PARAM_BODY_REGEX, PARAM_STATUS_CODE, PARAM_LOGICAL_OPERATOR}));
    }

    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        log.debug((Object)("handleApiView " + string + " " + jSONObject.toString()));
        switch (string) {
            case "getAuthorizationDetectionMethod": {
                Context context = ApiUtils.getContextByParamId(jSONObject, PARAM_CONTEXT_ID);
                return context.getAuthorizationDetectionMethod().getApiResponseRepresentation();
            }
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        log.debug((Object)("handleApiAction " + string + " " + jSONObject.toString()));
        switch (string) {
            case "setBasicAuthorizationDetectionMethod": {
                Context context = ApiUtils.getContextByParamId(jSONObject, PARAM_CONTEXT_ID);
                String string2 = jSONObject.optString(PARAM_HEADER_REGEX, null);
                String string3 = jSONObject.optString(PARAM_BODY_REGEX, null);
                BasicAuthorizationDetectionMethod.LogicalOperator logicalOperator = ApiUtils.getOptionalEnumParam(jSONObject, PARAM_LOGICAL_OPERATOR, BasicAuthorizationDetectionMethod.LogicalOperator.class);
                if (logicalOperator == null) {
                    logicalOperator = BasicAuthorizationDetectionMethod.LogicalOperator.AND;
                }
                int n = jSONObject.optInt(PARAM_STATUS_CODE, -1);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Setting basic authorization detection to: %s / %s / %d / %s", new Object[]{string2, string3, n, logicalOperator}));
                }
                BasicAuthorizationDetectionMethod basicAuthorizationDetectionMethod = new BasicAuthorizationDetectionMethod((Integer)n, string2, string3, logicalOperator);
                context.setAuthorizationDetectionMethod(basicAuthorizationDetectionMethod);
                return ApiResponseElement.OK;
            }
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }
}

