/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.Plugin;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.pscan.ExtensionPassiveScan;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;

public class PassiveScanAPI
extends ApiImplementor {
    private static final Logger logger = Logger.getLogger(PassiveScanAPI.class);
    private static final String PREFIX = "pscan";
    private static final String VIEW_RECORDS_TO_SCAN = "recordsToScan";
    private static final String VIEW_SCANNERS = "scanners";
    private static final String ACTION_SET_ENABLED = "setEnabled";
    private static final String ACTION_ENABLE_ALL_SCANNERS = "enableAllScanners";
    private static final String ACTION_DISABLE_ALL_SCANNERS = "disableAllScanners";
    private static final String ACTION_ENABLE_SCANNERS = "enableScanners";
    private static final String ACTION_DISABLE_SCANNERS = "disableScanners";
    private static final String ACTION_SET_SCANNER_ALERT_THRESHOLD = "setScannerAlertThreshold";
    private static final String PARAM_ENABLED = "enabled";
    private static final String PARAM_IDS = "ids";
    private static final String PARAM_ID = "id";
    private static final String PARAM_ALERT_THRESHOLD = "alertThreshold";
    private ExtensionPassiveScan extension;

    public PassiveScanAPI(ExtensionPassiveScan extensionPassiveScan) {
        this.extension = extensionPassiveScan;
        this.addApiAction(new ApiAction(ACTION_SET_ENABLED, new String[]{PARAM_ENABLED}));
        this.addApiAction(new ApiAction(ACTION_ENABLE_ALL_SCANNERS));
        this.addApiAction(new ApiAction(ACTION_DISABLE_ALL_SCANNERS));
        this.addApiAction(new ApiAction(ACTION_ENABLE_SCANNERS, new String[]{PARAM_IDS}));
        this.addApiAction(new ApiAction(ACTION_DISABLE_SCANNERS, new String[]{PARAM_IDS}));
        this.addApiAction(new ApiAction(ACTION_SET_SCANNER_ALERT_THRESHOLD, new String[]{PARAM_ID, PARAM_ALERT_THRESHOLD}));
        this.addApiView(new ApiView(VIEW_RECORDS_TO_SCAN));
        this.addApiView(new ApiView(VIEW_SCANNERS));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        switch (string) {
            case "setEnabled": {
                boolean bl = this.getParam(jSONObject, PARAM_ENABLED, false);
                this.extension.setPassiveScanEnabled(bl);
                break;
            }
            case "enableAllScanners": {
                this.extension.setAllPluginPassiveScannersEnabled(true);
                break;
            }
            case "disableAllScanners": {
                this.extension.setAllPluginPassiveScannersEnabled(false);
                break;
            }
            case "enableScanners": {
                this.setPluginPassiveScannersEnabled(jSONObject, true);
                break;
            }
            case "disableScanners": {
                this.setPluginPassiveScannersEnabled(jSONObject, false);
                break;
            }
            case "setScannerAlertThreshold": {
                int n;
                String string2 = jSONObject.getString(PARAM_ID);
                try {
                    n = Integer.valueOf(string2.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_ID);
                }
                if (!this.extension.hasPluginPassiveScanner(n)) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_ID);
                }
                Plugin.AlertThreshold alertThreshold = PassiveScanAPI.getAlertThresholdFromParamAlertThreshold(jSONObject);
                this.extension.setPluginPassiveScannerAlertThreshold(n, alertThreshold);
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_ACTION);
            }
        }
        return ApiResponseElement.OK;
    }

    private void setPluginPassiveScannersEnabled(JSONObject jSONObject, boolean bl) {
        String[] stringArray = this.getParam(jSONObject, PARAM_IDS, "").split(",");
        if (stringArray.length > 0) {
            for (String string : stringArray) {
                try {
                    int n = Integer.valueOf(string.trim());
                    if (n <= 0) continue;
                    this.extension.setPluginPassiveScannerEnabled(n, bl);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.error((Object)("Failed to parse scanner ID: " + numberFormatException.getMessage()), (Throwable)numberFormatException);
                }
            }
        }
    }

    private static Plugin.AlertThreshold getAlertThresholdFromParamAlertThreshold(JSONObject jSONObject) throws ApiException {
        String string = jSONObject.getString(PARAM_ALERT_THRESHOLD).trim().toUpperCase();
        try {
            return Plugin.AlertThreshold.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_ALERT_THRESHOLD);
        }
    }

    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        ApiResponse apiResponse;
        switch (string) {
            case "recordsToScan": {
                apiResponse = new ApiResponseElement(string, String.valueOf(this.extension.getRecordsToScan()));
                break;
            }
            case "scanners": {
                List<PluginPassiveScanner> list = this.extension.getPluginPassiveScanners();
                ApiResponseList apiResponseList = new ApiResponseList(string);
                for (PluginPassiveScanner pluginPassiveScanner : list) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put(PARAM_ID, String.valueOf(pluginPassiveScanner.getPluginId()));
                    hashMap.put("name", pluginPassiveScanner.getName());
                    hashMap.put(PARAM_ENABLED, String.valueOf(pluginPassiveScanner.isEnabled()));
                    hashMap.put(PARAM_ALERT_THRESHOLD, pluginPassiveScanner.getLevel(true).name());
                    apiResponseList.addItem(new ApiResponseSet("scanner", hashMap));
                }
                apiResponse = apiResponseList;
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_VIEW);
            }
        }
        return apiResponse;
    }
}

