/* linux/arch/arm/mach-exynos/include/mach/asv-exynos5410.h
*
* Copyright (c) 2012 Samsung Electronics Co., Ltd.
*              http://www.samsung.com/
*
* EXYNOS5410 - Adoptive Support Voltage Header file
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_EXYNOS5410_BIN2_ASV_H
#define __ASM_ARCH_EXYNOS5410_BIN2_ASV_H __FILE__

#define ARM_BIN2_DVFS_LEVEL_NR		(15)
#define ARM_BIN2_ASV_GRP_NR		(13)
#define ARM_BIN2_MAX_VOLT		(1237500)

#define INT_BIN2_DVFS_LEVEL_NR		(9)

#define INT_BIN2_ASV_GRP_NR		(13)
#define INT_BIN2_MAX_VOLT		(1150000)
#define G3D_BIN2_DVFS_LEVEL_NR		(6)
#define G3D_BIN2_ASV_GRP_NR		(13)
#define G3D_BIN2_MAX_VOLT		(1200000)
#define MIF_BIN2_DVFS_LEVEL_NR		(4)
#define MIF_BIN2_ASV_GRP_NR		(13)
#define MIF_BIN2_MAX_VOLT		(1062500)
#define KFC_BIN2_DVFS_LEVEL_NR		(10)
#define KFC_BIN2_ASV_GRP_NR		(13)
#define KFC_BIN2_MAX_VOLT		(1300000)

static unsigned int arm_asv_volt_info_bin2[ARM_BIN2_DVFS_LEVEL_NR][ARM_BIN2_ASV_GRP_NR + 1] = {
	{ 1600000, 1237500, 1225000, 1212500, 1200000, 1187500, 1200000, 1187500, 1175000, 1162500, 1137500, 1112500, 1112500, 1100000},
	{ 1500000, 1212500, 1200000, 1187500, 1175000, 1162500, 1175000, 1162500, 1150000, 1137500, 1112500, 1087500, 1087500, 1075000},
	{ 1400000, 1175000, 1162500, 1150000, 1137500, 1125000, 1137500, 1125000, 1112500, 1100000, 1075000, 1050000, 1050000, 1037500},
	{ 1300000, 1137500, 1125000, 1112500, 1100000, 1087500, 1100000, 1087500, 1075000, 1062500, 1037500, 1012500, 1012500, 1012500},
	{ 1200000, 1100000, 1087500, 1075000, 1062500, 1050000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000, 1000000,  987500},
	{ 1100000, 1075000, 1062500, 1050000, 1037500, 1025000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  975000,  962500},
	{ 1000000, 1037500, 1025000, 1012500, 1000000, 1000000, 1000000,  987500,  975000,  975000,  962500,  962500,  962500,  950000},
	{  900000, 1000000,  987500,  975000,  962500,  962500,  962500,  950000,  950000,  950000,  950000,  950000,  950000,  937500},
	{  800000,  962500,  950000,  937500,  925000,  925000,  925000,  925000,  925000,  925000,  925000,  925000,  925000,  912500},
	{  700000,  950000,  937500,  925000,  912500,  912500,  912500,  912500,  912500,  912500,  912500,  912500,  912500,  900000},
	{  600000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  500000,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  400000,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  300000,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  200000,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
};

static unsigned int kfc_asv_volt_info_bin2[KFC_BIN2_DVFS_LEVEL_NR][KFC_BIN2_ASV_GRP_NR + 1] = {
	{ 1200000, 1312500,	1300000, 1287500, 1275000,	1262500, 1250000,	1237500, 1225000,	1212500, 1200000,	1200000, 1200000, 1200000},
	{ 1100000, 1300000,	1275000, 1250000, 1237500,	1225000, 1212500,	1200000, 1187500,	1175000, 1162500,	1162500, 1162500, 1162500},
	{ 1000000, 1237500,	1212500, 1187500, 1175000,	1162500, 1150000,	1137500, 1125000,	1112500, 1100000,	1100000, 1087500, 1087500},
	{  900000, 1175000, 1150000, 1125000, 1112500,	1100000, 1087500,	1075000, 1062500,	1050000, 1037500,	1037500, 1025000, 1025000},
	{  800000, 1125000, 1100000, 1075000, 1062500,	1050000, 1037500,	1025000, 1012500,	1000000,  987500,	 987500,  975000,  975000},
	{  700000, 1075000, 1050000, 1025000, 1012500,	1000000,  987500,	 975000,  962500,	 950000,  950000,	 950000,  950000,  950000},
	{  600000, 1025000, 1000000,  987500,  975000,	 962500,  950000,	 950000,  950000,	 950000,  950000,	 950000,  950000,  950000},
	{  500000,  975000,  950000,  950000,  950000,	 950000,  950000,	 950000,  950000,	 950000,  950000,	 950000,  950000,  950000},
	{  400000,  950000,  950000,  950000,  950000,	 950000,  950000,	 950000,  950000,	 950000,  950000,	 950000,  950000,  950000},
	{  300000,  950000,  950000,  950000,  950000,	 950000,  950000,	 950000,  950000,	 950000,  950000,	 950000,  950000,  950000},
	{  200000,  950000,  950000,  950000,  950000,	 950000,  950000,	 950000,  950000,	 950000,  950000,	 950000,  950000,  950000},
};

static unsigned int int_mif_lv0_asv_volt_info_bin2[INT_BIN2_DVFS_LEVEL_NR][INT_BIN2_ASV_GRP_NR + 1] = {
	{  800000, 1150000, 1125000,	1112500, 1100000,	1087500, 1075000,	1062500, 1037500,	1025000, 1012500,	1000000, 1000000, 1000000},
	{  700000, 1125000, 1100000,	1075000, 1062500,	1050000, 1037500,	1025000, 1012500,	1000000,  987500,	 975000,  975000,  975000},
	{  400000, 1100000, 1075000,	1050000, 1037500,	1025000, 1012500,	1000000,  987500,	 975000,  975000,	 962500,  962500,  962500},
	{  267000, 1100000, 1075000,	1050000, 1037500,	1025000, 1012500,	1000000,  987500,	 975000,  975000,	 962500,  962500,  962500},
	{  200000, 1100000, 1075000,	1050000, 1037500,	1025000, 1012500,	1000000,  987500,	 975000,  975000,	 962500,  962500,  962500},
	{  160000, 1100000, 1075000,	1050000, 1037500,	1025000, 1012500,	1000000,  987500,	 975000,  975000,	 962500,  962500,  962500},
	{  100000, 1100000, 1075000,	1050000, 1037500,	1025000, 1012500,	1000000,  987500,	 975000,  975000,	 962500,  962500,  962500},
	{   50000, 1100000, 1075000,	1050000, 1037500,	1025000, 1012500,	1000000,  987500,	 975000,  975000,	 962500,  962500,  962500},
};

static unsigned int int_mif_lv1_asv_volt_info_bin2[INT_BIN2_DVFS_LEVEL_NR][INT_BIN2_ASV_GRP_NR + 1] = {
	{  800000, 1150000, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1037500, 1025000, 1012500, 1000000, 1000000, 1000000},
	{  700000, 1125000, 1100000, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  975000,  975000},
	{  400000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  925000},
	{  267000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  925000},
	{  200000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  925000},
	{  160000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  925000},
	{  100000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  925000},
	{   50000, 1000000,  975000,  962500,  950000,  937500,  925000,  925000,  925000,  925000,  925000,  925000,  925000,  925000},
};

static unsigned int int_mif_lv2_asv_volt_info_bin2[INT_BIN2_DVFS_LEVEL_NR][INT_BIN2_ASV_GRP_NR + 1] = {
	{  800000, 1150000, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1037500, 1025000, 1012500, 1000000, 1000000, 1000000},
	{  700000, 1125000, 1100000, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  975000,  975000},
	{  400000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  925000},
	{  267000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  925000},
	{  200000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  925000},
	{  160000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  925000},
	{  100000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  925000},
	{   50000, 1000000,  975000,  962500,  950000,  937500,  925000,  925000,  925000,  925000,  925000,  925000,  925000,  925000},
};

static unsigned int int_mif_lv3_asv_volt_info_bin2[INT_BIN2_DVFS_LEVEL_NR][INT_BIN2_ASV_GRP_NR + 1] = {
	{  800000, 1150000, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1037500, 1025000, 1012500, 1000000, 1000000, 1000000},
	{  700000, 1125000, 1100000, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  975000,  975000},
	{  400000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  925000},
	{  267000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  925000},
	{  200000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  925000},
	{  160000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  925000},
	{  100000, 1050000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  925000},
	{   50000, 1000000,  975000,  962500,  950000,  937500,  925000,  925000,  925000,  925000,  925000,  925000,  925000,  925000}
};

static unsigned int mif_asv_volt_info_bin2[MIF_BIN2_DVFS_LEVEL_NR][MIF_BIN2_ASV_GRP_NR + 1] = {
	{  800000, 1062500, 1050000, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  950000,  950000},
	{  400000,  962500,  950000,  937500,  925000,  925000,  912500,  912500,  912500,  912500,  912500,  900000,  900000,  900000},
	{  200000,  950000,  925000,  912500,  912500,  900000,  900000,  900000,  900000,  887500,  887500,  875000,  875000,  875000},
	{  100000,  925000,  912500,  912500,  900000,  900000,  900000,  900000,  887500,  887500,  875000,  875000,  875000,  875000},
};

static unsigned int g3d_asv_volt_info_bin2[G3D_BIN2_DVFS_LEVEL_NR][G3D_BIN2_ASV_GRP_NR + 1] = {
	{  532000, 1200000, 1187500, 1175000, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1050000},
	{  480000, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000},
	{  350000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  975000,  962500,  962500,  950000,  950000,  937500,  937500},
	{  266000, 1000000,  987500,  975000,  962500,  950000,  937500,  937500,  925000,  925000,  912500,  912500,  912500,  912500},
	{  177000,  975000,  962500,  950000,  937500,  925000,  925000,  912500,  912500,  900000,  900000,  900000,  900000,  900000},
	{   89000,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
};

#endif /* EXYNOS5410_BIN2_ASV_H */
