/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.security.CodeSource;
import java.util.Objects;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.NashornLoader;

final class ScriptLoader
extends NashornLoader {
    private static final String NASHORN_PKG_PREFIX = "jdk.nashorn.internal.";
    private final Context context;

    Context getContext() {
        return this.context;
    }

    ScriptLoader(ClassLoader parent, Context context) {
        super(parent);
        this.context = context;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ScriptLoader.checkPackageAccess(name);
        if (name.startsWith(NASHORN_PKG_PREFIX)) {
            return this.context.getSharedLoader().loadClass(name);
        }
        return super.loadClass(name, resolve);
    }

    synchronized Class<?> installClass(String name, byte[] data, CodeSource cs) {
        return this.defineClass(name, data, 0, data.length, Objects.requireNonNull(cs));
    }
}

